/*
 *                        B G _ D I C E . C
 * This module handles all the functions of the Dice.
 * O.F.Ransen:    21st June    1991
 * This version:  22nd January 1993
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "bg.h"

/*************************************************************************/

Stats_t Statistics [N_PLAYERS] ;
Throw_t Throw = AUTO_THROW ;  /* The computer throws the dice */

/*************************************************************************/

Dice_t Throw_Dice (Player_t Player,
                   Player_t Opponent,
                   Player_t Human,
                   boolean* Doubled, boolean* Rejected,
                   Layout_t  Curr_Lay[2])
/*
PURPOSE: To throw the two dice and return the values we get. We pass in
         the player in because we need to know which statistics to
         update.
NOTES:   1) Starting to work on doubling cube...
*/
{
    extern Mesg_t Messages[N_MESGS] ;
    extern short Lang ;
    extern boolean F10_Hit ;
    Dice_t Dummy_Dice ;

    Dummy_Dice.N_Vals = 0 ;

    if (Player == Human) {
        (*Doubled) = Human_Doubles (Player) ;
        if (F10_Hit) {
            return (Dummy_Dice) ;
        }
    } else {
        (*Doubled) = Computer_Doubles (Player,Curr_Lay) ;
    }

    if (*Doubled) {
        if (Opponent == Human) {
            Framed_Center_String (Messages[YOU_ACC_MSG].Message[Lang],12,PUSH) ;
            (*Rejected) = Human_Rejects_Double () ;
            Erase_Framed_String () ;
            if (F10_Hit) {
                return (Dummy_Dice) ;
            }
        } else {
            if (Player == BLACK_PLAYER) {
                Print_Message (BLK_PROP_DBL_MSG) ;
            } else {
                Print_Message (WHT_PROP_DBL_MSG) ;
            }
            (*Rejected) = Computer_Rejects_Double (Opponent,Curr_Lay) ;
        }
    }

    if ((*Doubled) && (*Rejected)) {
        if (Player == Human) {
            Print_Message (COM_REJ_MSG) ;
        } else {
            if (Player == BLACK_PLAYER) {
                Print_Message (WHT_REJ_DBL_MSG) ;
            } else {
                Print_Message (BLK_REJ_DBL_MSG) ;
            }
        }
        return (Dummy_Dice) ;
    } else {
        if (*Doubled) {
            extern int      Double_Value ;
            extern Player_t Double_Possessor ;

            Double_Value     = Double_Value * 2 ;
            Double_Possessor = Opponent ;
            Draw_Double_Cube (Double_Possessor,Double_Value) ;
            if (Player == Human) {
                Print_Message (COM_ACC_MSG) ;
            } else {
                if (Player == BLACK_PLAYER) {
                    Print_Message (WHT_ACC_DBL_MSG) ;
                } else {
                    Print_Message (BLK_ACC_DBL_MSG) ;
                }
            }
        }
        if (Throw == AUTO_THROW) {
            return (Computer_Throws_Dice (Player)) ;
        } else {
            return (Human_Throws_Dice (Player,Player)) ;
        }
    }
}

/*************************************************************************/

Dice_t Computer_Throws_Dice (Player_t George)
/*
PURPOSE: To get the computer to generate the dice.
*/
{
    Dice_t Throw ;
    short n,Score ;
    int Rand_Rolls,r ;
    extern boolean Genetics ;

    if (Genetics) {
        Rand_Rolls = 1 ;
    } else {
        Rand_Rolls = Int_Rand_Range (MIN_ROLLS,MAX_ROLLS) ;
    }
    for (r = 0 ; r < Rand_Rolls ; r++) {
        Throw.Values[0] = (char)Int_Rand_Range (1,6) ;
        Throw.Values[1] = (char)Int_Rand_Range (1,6) ;
        Throw.N_Vals    = 2 ;
        Draw_Dice_Pair (&Throw,George) ;
    }

    if (Throw.Values[0] == Throw.Values[1]) {
        /* Lucky George, he threw a double */
        Throw.Values[2] = Throw.Values[0] ;
        Throw.Values[3] = Throw.Values[0] ;
        Throw.N_Vals    = 4 ;
        Statistics [George].Doubles ++ ;
    } else {
        Throw.Values[2] = 0 ;
        Throw.Values[3] = 0 ;
        Throw.N_Vals    = 2 ;
    }

    Statistics [George].N_Throws ++ ;
    Score = 0 ;
    for (n = 0 ; n < Throw.N_Vals ; n++) {
        Score += Throw.Values[n] ;
    }
    Statistics [George].Total += Score ;

    // !!!!OWEN!!!!
    // Throw.N_Vals = 2 ;
    // Throw.Values[0] = 1 ;
    // Throw.Values[1] = 4 ;


    return (Throw) ;
}

/**********************************************************************/

Dice_t Human_Throws_Dice (Player_t First, Player_t Second)
/*
PURPOSE: To get the human to input the dice.
NOTES:   1) Usually First == Second and is either BLACK_PLAYER or
         WHITE_PLAYER. On the first throw tho First != Second and
         dice of different colours have to be drawn.
         2) If the user at any point hits F10 then we set F10_Hit.
*/
{
    extern boolean F10_Hit ;
    Dice_t Throw ;
    short Score,d,Key ;
    Player_t List[N_PLAYERS] ;

    List [0] = First ;
    List [1] = Second ;

    if (First == Second) {
        Print_Message (THROW_DICE_MSG) ;
    } else {
        Print_Message (INIT_DICE_MSG) ;
    }

    Throw.N_Vals = 0 ;
    Key          = 0 ;

    Clear_Die (1) ;
    Clear_Die (2) ;

    while ((Throw.N_Vals != 2) || (Key != ENTER_KEY)) {
        Key = getch () ;
        if (Key == FUN_PREFIX) {
            if (getch () == F10_KEY) {
                F10_Hit = TRUE ;
                Throw.N_Vals = 0 ;
                Clear_Help_Line () ;
                return (Throw) ;
            }
        } else if ((Key > '0') && (Key < '7') && (Throw.N_Vals < 2)) {
            Throw.Values[Throw.N_Vals] = (char)(Key - (short)'0') ;
            Throw.N_Vals++ ;
        } else if ((Key == BACK_KEY) && (Throw.N_Vals > 0)) {
            Throw.N_Vals-- ;
        } else if (Key == ESC_KEY) {
            Throw.N_Vals = 0 ;
        }
        for (d = 0 ; d < 2 ; d++) {
            if (d < Throw.N_Vals) {
                Draw_Die (Throw.Values[d],d+1,List[d]) ;
            } else {
                Clear_Die (d+1) ;
            }
        }
    }

    if (First == Second) {
        /* This is a throw of a single player, update his stats */
        if (Throw.Values[0] == Throw.Values[1]) {
            /* Lucky George, he threw a double */
            Throw.Values[2] = Throw.Values[0] ;
            Throw.Values[3] = Throw.Values[0] ;
            Throw.N_Vals    = 4 ;
            Statistics [First].Doubles ++ ;
        }

        Statistics [First].N_Throws ++ ;
        Score = 0 ;
        for (d = 0 ; d < Throw.N_Vals ; d++) {
            Score += Throw.Values[d] ;
        }
        Statistics [First].Total += Score ;
    }
    Clear_Help_Line () ;
    return (Throw) ;
}

/**********************************************************************/

void Init_Stats (void)
/*
PURPOSE: To reset all the statistics.
*/
{
    ushort p ;
    for (p=0 ; p < N_PLAYERS ; p++) {
        Statistics[p].Total      =     0 ;
        Statistics[p].N_Throws   =     0 ;
        Statistics[p].Doubles    =     0 ;
        Statistics[p].Games_Won = 0 ;
    }
}

/***************************************************************************/

void Copy_Dice (Dice_t* Dest, Dice_t* Source)
/*
PURPOSE: To copy the dice.
*/
{
    short i ;
    Dest->N_Vals = Source->N_Vals ;
    for (i = 0 ; i < Source->N_Vals ; i++) {
        Dest->Values[i] = Source->Values[i] ;
    }
}

/***************************************************************************/

void Deplete_Dice_Pool (Dice_t* Dice, ushort Index)
/*
PURPOSE: To remove a dice from the pool.
*/
{
    ushort i ;

    if (Index > 3) {
        Error_Exit ("\nDepleting a dice which does not exist.") ;
    } else if (Index > (ushort)Dice->N_Vals-1) {
        Error_Exit ("\nDepleting more dice than I have.") ;
    } else if (Dice->N_Vals == 0) {
        Error_Exit ("\nAll dice used up") ;
    } else if (Dice->N_Vals > 4) {
        Error_Exit ("\nToo many dice") ;
    }

    i = Index ;
    while (i < (ushort)Dice->N_Vals-1) {
        Dice->Values[i] = Dice->Values[i+1] ;
        i++ ;
    }

    Dice->N_Vals-- ;
}

/***************************************************************************/

