/*
 *
 *
 *   B  G  .  H , main include file for BG.C, 31st December 1993
 *
 *
 */

#define VER_STR "VERSION 2.31"

/* Version numbers and dates:
    1.00 25th April 1992
    1.01 27th April 1992 -- American release
    1.02  1st May   1992 -- Corrected uninitted ptr bug
    1.03                 -- Std openings under development
    1.04  22nd May  1992 -- Corrected EGA only bug,
    1.05  27th May  1992 -- Better Security score, added Tense_Aggro
    1.06  30th May  1992 -- Solid colours, -mono option added.
    1.07  31st May  1992 -- Release for LIBRERIA ATALA.
    1.08   5th June 1992 -- Game end message, who won what.
    1.09   8th June 1992 -- As sent to Mr.Watkins, Gloucester Museum.
    1.1   20th June 1992 -- Another release for ATALA, def=Italiano.
    1.11  27th June 1992 -- Jamie and Fred release, ESC from menu too.
    1.1X  working on doubling cube...
    1.2   30th Oct  1992 -- Got rid of protection, still no doubling
    1.2X  working on the doubling cube...
    2.01  6-Feb-1993 With doubling cube, sent to Dossena
    2.03  Better 'constructor' scoring in BG_EVAL.C
    2.04  Trying to get him to shift trailing pieces faster
    2.10  31-Oct-1993, More genetics training
    2.11  Does not reject double at start of game
    2.20  STDOP 5,1 corrected
    2.25  Getting a 12 neuron neural network to play too.
    2.3   14th May 1994, NN plays badly, removed it.
    2.31  25th March 1994, TD-Gammons openings for 4,1 and 2,1 in BG_STDOP.C
*/

#define DEBUG_SOURCE TRUE  /* Set to FALSE ten years from now */
#define DRODBAR      0     /* Always 0, used to exclude unwanted source */

/***** Generally useful types and constants *****/

typedef unsigned char  uchar ;
typedef unsigned long  ulong ;
typedef unsigned short ushort ;
typedef short          boolean ;
typedef unsigned int   uint ;

#define TRUE            1
#define FALSE           0
#define SAME_STRING     0   /* for strcmpx functions */
#define NUL       (char)0   /* String terminator */
#define EVEN(a) (((a/2)*2)==a)
#define GERR_LEN     1024   /* Length of global error string */


/***** Describe a board *****/

#define N_PLAYERS       2
#define GRID_COLS      14   /* 12 points + the bar + home */
#define GRID_ROWS      12   /* Space for 6 pieces         */
#define BAR_COL         7   /* The 7th column is the bar  */
#define DOUBLE_ROW   (GRID_ROWS/2)
#define HOME_COL        0   /* The zeroth column is home  */

#define XI              0  /* X_Coord index */
#define YI              1  /* Y_Coord index */
#define TWOD_COORDS     2  /* There are 2   */

#define Reverse_Index(a) ((N_PLACES-1)-(a)) /* To go from an index on the
        black layout to an index on the white layout and vice versa */

typedef short Player_t ;
#define BLACK_PLAYER   0
#define WHITE_PLAYER   1
#define NULL_PLAYER    2
#define OPPONENT(p) (p==BLACK_PLAYER) ? WHITE_PLAYER : BLACK_PLAYER

#define N_POINTS      24
#define N_PLACES (N_POINTS+2)   /* 24 points, home and the bar */
#define BAR_I           0
#define POINT1_I        1
#define POINT24_I      24
#define HALF_POINT_I   13
#define HOME_I         25
#define MAX_MOVES       4  /* At most a player can move 4 pieces */
#define WORST_SCORE   (-1) /* So all scores are longs and +ve */
#define N_PIECES       15  /* Per player of course */
#define NOT_VALID_END (-1) /* Cannot move to here code */

typedef char Layout_t [N_PLACES] ; /* One layout for each player */


/***** Points for the different types of winning game *****/

#define NO_WIN     0
#define SIMPLE     1
#define GAMMON     2
#define BACKGAMMON 3


/***** Transit_t, used to describe a move *****/

typedef struct {
    Layout_t Layout ;                 /* The new layout after the transition */
    short    N_Moves ;                /* 0..4 moves to get to new layout */
    short    Old_Points [MAX_MOVES] ; /* Where the piece was */
    short    Places_Movd[MAX_MOVES] ; /* Places moved, can be negative */
    short    Old_Row    [MAX_MOVES] ; /* The level of the old pos of piece */
    short    New_Row    [MAX_MOVES] ; /* The level of the new pos of piece */
} Transit_t ;


/***** The Search_t type *****/

typedef enum {
    Bestest,  /* Search for best legal move */
    Legalest  /* Search for the most legal move only */
} Search_t ;


/***** Some colour definitions *****/

#define BLACK   0
#define BLUE    1
#define GREEN   2
#define CYAN    3
#define RED     4
#define GREY    7
#define WHITE  15

/***** Framed_Center_String operations *****/

typedef enum {
    OVERWRITE = 0 ,
    PUSH      = 1
} FCS_Op_t ;

/***** Definition of Speed_t, how fast to update the screen *****/

typedef enum {
    PAUSING     = 0,   /* Hit key after a transit */
    SLOW_SPEED  = 1,   /* Transits and a delay */
    MED_SPEED   = 2,   /* Transits shown */
    FULL_SPEED  = 3    /* No transits shown */
} Speed_t ;


/***** These are used to plot semicircles of motion *****/

#define PI      ((double)3.1416)
#define TWO_PI  ((double)2.0*PI)
#define NSC_SEGS         25
#define NSC_POINTS (NSC_SEGS+1)
#define DELTA_ANGLE (PI/NSC_SEGS)  /* +ve = anticlockwise */


/***** Define the TEXT area sizes, postitions and so on *****/

#define SIDE_ROWS     14   /* This is the size in characters...  */
#define SIDE_COLS     16   /* ...of the side text area.          */
#define HELP_ROWS      1   /* The number of cols is whatever is left */

/* Graphical margin around text menus, should be an even number */
#define MARGIN    4

/* Position of text strings on title page */
#define TITLE_BG_ROW    1
#define TITLE_SWS_ROW   4
#define TITLE_VER_ROW   7
#define TITLE_LOGO_ROW 10
#define TITLE_LOGO_DIV  6

/* Placement of statistics */
#define ID_ROW       0                /* Black and White ids */
#define TOTALM_ROW   1                /* Total Message row */
#define TOTALN_ROW   (TOTALM_ROW+1)   /* Total Number row */
#define DOUBM_ROW    4
#define DOUBN_ROW    (DOUBM_ROW+1)
#define POINTSM_ROW  7
#define POINTSN_ROW  (POINTSM_ROW+1)
#define TARGETM_ROW  9
#define TARGETN_ROW  (TARGETM_ROW+1)
#define OPP_ROW      (POINTSN_ROW+5)  /* "OPPONENT" */
#define NUM_WIDE  8
#define OFFSET    4   /* End of field name text */

#define THREAT_ROW   (STATS_ROW + 8)

/***** The message type, what and how they are *****/

#define MESS_CHARS  64   /* Max number of message chars exc NUL */
#define N_LANGS   2
#define ENG_LANG  0
#define ITA_LANG  1

typedef struct {
    char     Message [N_LANGS][MESS_CHARS+1] ;
    char     Area ;
    char     Row,Col ;
    short    Sound ;    /* If 0 no sound, else the freq of the sound */
    FCS_Op_t Op ;
} Mesg_t ;


#define STAT_MSG          0
#define ID_MSG            1
#define TOTAL_MSG         2
#define DOUBLE_MSG        3
#define POINTS_MSG        4
#define HELP_MSG          5
#define HIT_MOUSE_MSG     6
#define SETUP_MSG         7

#define MAIN_SETUP_MSG    8
#define FIRST_MAIN_MSG    MAIN_SETUP_MSG
#define MAIN_PLAY_MSG     9
#define MAIN_EXIT_MSG    10
#define LAST_MAIN_MSG    MAIN_EXIT_MSG

#define MENU_HELP_MSG    11
#define CANT_START_MSG   12
#define CANT_END_MSG     13
#define SEL_STA_MSG      14
#define SEL_END_MSG      15
#define CLK_GO_MSG       16
#define B_NOGO_MSG       17
#define W_NOGO_MSG       18
#define CTLC_MSG         19
#define INIT_DICE_MSG    20
#define THROW_DICE_MSG   21
#define HAKTOC_MSG       22
#define DBL_MSG          23
#define DBL_LIM_MSG      24
#define ACC_DBL_MSG      25
#define COM_REJ_MSG      26
#define COM_ACC_MSG      27
#define YOU_ACC_MSG      28
#define WHT_PROP_DBL_MSG 29
#define BLK_PROP_DBL_MSG 30
#define WHT_REJ_DBL_MSG  31
#define BLK_REJ_DBL_MSG  32
#define WHT_ACC_DBL_MSG  33
#define BLK_ACC_DBL_MSG  34
#define NO_CUBE_MSG      35
#define PLAY_TO_MSG      36
#define COM_WINS_SET_MSG 37
#define YOU_WIN_SET_MSG  38

#define N_MESGS          39

/* Some text defines which should really be variables... */
#define LAST_ROW 24 /* Horrid ! */
#define MID_COL  40 /* Horrid ! */


/* MAIN menu */
#define MAIN_MENU_ROWS   (LAST_MAIN_MSG - FIRST_MAIN_MSG + 1)
#define MAIN_MENU_ROW    (LAST_ROW - MAIN_MENU_ROWS)
#define MAIN_COLS_WIDE   20
#define MAIN_MENU_COL    (MID_COL - (MAIN_COLS_WIDE/2))
#define HELP_KEY     F1_KEY
#define SETUP_KEY    F3_KEY
#define PLAY_KEY  ENTER_KEY

/* SETUP menu */
#define N_SETUP_FIELDS         6
#define S_TITLE_ROW      (LAST_ROW - (N_SETUP_FIELDS+3))
#define SETUP_ROW        (S_TITLE_ROW+1)
#define LANG_FIELD             0
#define SPEED_FIELD            1
#define COL_FIELD              2
#define OPP_FIELD              3
#define TARG_FIELD             4
#define THROW_FIELD            5
#define FIELD_CHARS           12  /* Size of a field name or an option name */
#define MAX_OPTIONS            4
#define FIELD_COL      (SETUP_COL + FIELD_CHARS + 2)
#define SETUP_COLS_WIDE ((MAX_OPTIONS+1)*FIELD_CHARS)
#define SETUP_COL       (40 - (SETUP_COLS_WIDE/2))

/***** The structure for a string menu, used in SETUP menu *****/

typedef struct {
    char Name [N_LANGS][FIELD_CHARS+1] ;
    char Options [N_LANGS][MAX_OPTIONS][FIELD_CHARS+1] ;
    char Selector ;          /* Which option selected now */
    char N_Options ;         /* Length of option list */
    char O_Width ;           /* Cols between start of options */
} String_Menu_t ;


/***** defines for opponents, see BG_USER1.C for names *****/
#define SERGIO     0
#define ENZO       1
#define OWEN       2
#define BRIAN      3  // The brain
#define N_OPPS     4


/* WEIGHTS menu */
#define N_WEIGHTS    13
#define MAX_WEIGHT  100
#define N_W_FIELDS    (N_WEIGHTS * N_PLAYERS)
#define N_W_ROWS      (N_W_FIELDS + 1)
#define W_TITLE_ROW    4
#define W_TOP         (W_TITLE_ROW + 1)
#define W_STRSIZE    30  /* num chars to describe a weighting function */
#define W_NUM_COL     (W_LEFT + W_STRSIZE + 1)
#define W_FIELD_SIZE    4
#define W_COLS_WIDE    (W_STRSIZE+W_FIELD_SIZE+1)
#define W_LEFT       (40 - (W_COLS_WIDE/2))


/***** Layout Selector Type *****/

typedef struct {
    long     Moves_Made ; /* Comes first in selecting which move */
    long     Goodness   ; /* Equally legal moves use this as a selector */
} Lay_Sel_t ;


/***** Statistics structure *****/

typedef struct {
    ushort Total ;      /* Total score of the player so far, with doubles */
    ushort Doubles ;    /* Number of doubles thrown by the player */
    ushort N_Throws ;   /* Number of times the two dice thrown */
    ushort Games_Won ;
} Stats_t ;

#define MIN_ROLLS  5
#define MAX_ROLLS  25
typedef struct {
    char N_Vals ;    /* 2 or 4 if double */
    char Values[MAX_MOVES] ; /* List of values, e.g. [1,3] or [4,4,4,4] */
} Dice_t ;

/* Are the die thrown by the computer or by the human ? */
typedef enum {
    AUTO_THROW,MANUAL_THROW
} Throw_t ;

typedef struct {
    short Text_X,Text_Y ;           /* Top left pixel of text area */
    short Dice_Area_X,Dice_Area_Y ; /* Top left pixel of Dice_Area area */
    short Text_Wide,Text_High ;     /* In pixels */
    short Help_X,Help_Y ;           /* Top left pixel of help area */
    short Help_Wide,Help_Cols ;     /* Height is always 1 char */
    short Board_X,Board_Y ;         /* Top left pixel of board area */
    short Board_Wide,Board_High ;   /* Pixel size, inclusive */
    short Logo_X,Logo_Y ;           /* Top left pixel of logo area */
    short Logo_Wide,Logo_High ;     /* Pixel size, inclusive */
    short Logo_Center ;             /* Pixel X_Center of logo area */
    short Grid_Wide,Grid_High ;     /* A unit positioner on the board */
    short Unit_Wide,Unit_High ;     /* 4 pixels less than the above */
    short Double_X,Double_Y ;       /* Cell for the doubling button */
} Screen_Const_t ; /* Const coz initialised and then never changed */

typedef struct {
    short   X_Pixels,Y_Pixels   ;
    short   Aspect_H, Aspect_V  ; /* See README.C for explanation */
    short   Char_Wide,Char_High ;
    short   Text_Rows,Text_Cols ;
    boolean Colour ;
} Disp_Cfg_t ;


/***** Keyboard code defines *****/

#define FUN_PREFIX  0
#define UP_KEY     72
#define DN_KEY     80
#define LF_KEY     75
#define RT_KEY     77
#define F1_KEY     59
#define F2_KEY     60
#define F3_KEY     61
#define F4_KEY     62
#define F5_KEY     63
#define F6_KEY     64
#define F9_KEY     67
#define F10_KEY    68
#define ENTER_KEY  13
#define BACK_KEY    8
#define ESC_KEY    27


/***** Function prototypes *****/

/* BG.C */
void    main (int argc, char * argv[]) ;
boolean Play_The_Game (Speed_t Speed, Player_t Human, short O_Index) ;
void    Select_Starter (Player_t* Player, Dice_t* Dice) ;
void    Seconds_Delay (short seconds) ;
void    Record_Move (Player_t Ply, Dice_t* Di, Layout_t Blk, Layout_t Wht) ;
void    Print_Layouts (Layout_t B, Layout_t W) ;
void    Print_Layout (Layout_t Layout, Player_t Player) ;
void    Test_Move (void) ;

/* BG_CDPNT.C */
void  Go_Graph_Mode (void) ;
void  Go_Text_Mode (void) ;
void  Get_Display_Config (Disp_Cfg_t* Cfg) ;
void  Draw_Line (short x0, short y0, short x1, short y1, short Col) ;
void  Draw_Rect (short x0, short y0, short Wide, short High, short Col) ;
void  Fill_Rect (short x0, short y0, short Wide, short High, short Col) ;
void  Fill_Poly (short N_Points, short* Points, short Colour);
void  Draw_Point (short x, short y, short c) ;
void  Set_Solid_Fill_Style (void) ;
void  Draw_Ellipse (short x, short y, short X_r, short Y_r, short Col) ;
void  Fill_Ellipse (short X_Cen, short Y_Cen, short X_Rad, short Y_Rad, short Col) ;
void  Graf_Text (short Row, short Col, char* String, short Color) ;
void  Text_At_Pixel (short x, short y, char* String, short Col) ;
void  Error_Exit (char* Last_Words) ;
void  Init_Rannum_Gen (void) ;
void  Randomise (void) ;
int   Int_Rand_Range (int least, int most) ;
void  Set_Ctl_C_Handler (void) ;
void  Ctl_C_Handler (void) ;

/* BG_DICE.C */
Dice_t Throw_Dice (Player_t Pl, Player_t Op, Player_t Hu,
                   boolean* Doubled, boolean* Rejected,
                   Layout_t Curr_Lay[2]) ;
Dice_t Computer_Throws_Dice (Player_t George) ;
Dice_t Human_Throws_Dice (Player_t First, Player_t Second) ;
void   Init_Stats (void) ;
void   Copy_Dice (Dice_t* Dest, Dice_t* Source) ;
void   Deplete_Dice_Pool (Dice_t* Dice, ushort Index) ;

/* BG_DOUBL.C */
boolean Human_Doubles (Player_t Player) ;
boolean Computer_Doubles (Player_t Player, Layout_t Curr_Lay[2]) ;
boolean Human_Rejects_Double (void) ;
boolean Computer_Rejects_Double (Player_t Player, Layout_t Curr_Lay[2]) ;

/* BG_EVAL.C */
long    Aggression_Score (Layout_t Me, Layout_t Him) ;
boolean Overlap (Layout_t Me, Layout_t Him) ;
short   Pip_Count (Layout_t Layout) ;
short   Pip_Count_Diff (Layout_t Me, Layout_t Him) ;
long    Pip_Count_Score (Layout_t Me, Layout_t Him) ;
short   Total_Pieces_On_Board (Layout_t Me, Layout_t Him) ;
short   Pieces_On_Board (Layout_t Layout) ;
void    Edit_Weights (void) ;
void    Draw_Weight (ushort Rw, char* Ds, ushort Nm, ushort Cl, Player_t p) ;
long    Evaluate_Move (Layout_t Me, Layout_t Him, Player_t Player) ;
void    Setup_Weights (short New_Opponent, Player_t Player) ;
void    Init_Genetic_Opponents (short Black, short White) ;
void    Print_Eval_Stats (void) ;

/* BG_EVAL2.C */
boolean Propose_The_Double (Player_t Player, Layout_t Layout[2]) ;
boolean Reject_The_Double (Player_t Player, Layout_t Layout[2]) ;

/* BG_FACE.C */
void Init_Faces (void) ;
void Pixel_Transform (short* x, short* y) ;
void Draw_Eyes (short N_Vals, short o) ;
void Draw_Face_Outline (short Face, short Col) ;
void Redraw_Mouth (short o, short S_Val, short T_Val) ;
void Draw_Mouth (short o, short S_Val, short T_Val, short Colour) ;
void Redraw_Eyebrows (short o, short Eb_Val) ;
void Draw_Eyebrows (short o, short Eb_Val, short Colour) ;
void Draw_Face (Layout_t Me, Layout_t Him, short o) ;
void Show_Opponents_Face (Layout_t Lays[2], Player_t Hum, short O_Ind);

/* BG_GENES.C */
void  Genetic_Selection (void) ;
void  Read_Weights (long Weights[N_OPPS][N_WEIGHTS]) ;
void  Write_Weights (long Weights [N_OPPS][N_WEIGHTS], short Pos[N_OPPS]) ;
void  Reinforce_Or_Shuffle (short Deltas[N_WEIGHTS], short Pos, short Old_Pos) ;
void  Randomise_Deltas (short Deltas[N_WEIGHTS], short Position) ;
void  Remake_Weights (long Weights[N_WEIGHTS], short Deltas[N_WEIGHTS]);
void  Tournament (short Pos[N_OPPS]);
short Get_Winner (short Black, short White) ;

/* BG_GMOV.C */
void Draw_Transits (Transit_t* Me, Transit_t* Hm, Player_t Plyr) ;

/* BG_GRAF1.C */
void Init_Graphics (void) ;
void Get_Grid_Corner (short* X, short* Y, short Col, short Row) ;
void Get_Grid_Center (short* X, short* Y, short Col, short Row) ;
void Go_Graphics (int V_Mode) ;
void Draw_Dice_Pair (Dice_t* Pair, Player_t Player) ;
void Draw_Die (short Value, short Dice_Num, Player_t Player) ;
void Clear_Die (short Dice_Num) ;
void Draw_Stats (void) ;
void Side_Number (ushort Row, ushort Col, ushort Number,
                  ushort F_Size, ushort Color) ;
void Clear_Side_Line (ushort Row) ;
void Graf_Number (ushort Row, ushort Col, ushort Number,
                  ushort F_Size, ushort Color) ;
void Init_And_Draw_Logo (void) ;
void Clear_Logo_Area (void) ;
boolean Even (short Number) ;
void Show_Dice_List (Dice_t* Dice) ;

/* BG_GRAF2.C */
void Get_Pbox_Coords (short    Box_Coords[2][2],
                      Player_t Player, short Point_Num) ;
void Draw_Board_Full  (Layout_t Layouts[N_PLAYERS]) ;
void Draw_Board_Quick (Layout_t Black, Layout_t White) ;
void Clear_Point (Player_t Player, short Point_Num) ;
void Get_Piece_Center (short* X_Center, short* Y_Center, Player_t Player,
                       short Point_Num, short Piece_Row, short Tot_Pieces,
                       short Available_Rows) ;
char Show_Transits_And_Kb_Look (Transit_t* Me, Transit_t* Hm,
                                Player_t Plr, Speed_t Spd) ;
void Side_Text (short Row, short Col, char* String, short Color)  ;
void Help_Text (short Col, char* String, short Color) ;
void Clear_Help_Line (void) ;
boolean Pixel_To_Grid (short* Col, short* Row, short x, short y) ;
short Grid_To_Point (short G_Col, short G_Row, short Player) ;

/* BG_GRAF3.C */
void Title_Page (void) ;
void Framed_Center_String (char* String, short Row, FCS_Op_t Operation) ;
void Erase_Framed_String (void) ;
void Clear_Screen (void) ;
void Draw_Prob_Diag (char Disp[6][6]) ;
void Draw_Pline (short N_Points, short Line[][2], short Col) ;
void Draw_Pgon (short N_Points, short Line[][2], short Col) ;
void Draw_Double_Button (void) ;
void Draw_Double_Cube (Player_t Possesor, short Number) ;

/* BG_MESG.C */
void Print_Message (ushort Message_Number) ;
void Print_Players (short Opponent, Player_t Human) ;
void Print_Opponents (short Black, Player_t White) ;
void Print_Tournament (short T_Num, short Pos[N_OPPS]) ;
void Show_Winner (Player_t Wnr, Player_t Man, short Points) ;

/* BG_MOVE.C */
void Initial_Board (Layout_t Layouts[2]) ;
void Select_Best_Move (Dice_t*    The_Dice,
                       Layout_t   Mine_Old,   Layout_t   His_Old,
                       Transit_t* My_Best_Tr, Transit_t* His_Best_Tr,
                       Player_t   Player,     Search_t   s) ;
void Select_Best_2Dice_Move (Dice_t*    The_Dice,
                             Transit_t* My_Old_Tr,  Transit_t* His_Old_Tr,
                             Transit_t* My_Best_Tr, Transit_t* His_Best_Tr,
                             Player_t   Player) ;
void Select_Best_Ndice_Move (Dice_t*    Dice_List,  short      This_Dice,
                             Transit_t* My_Curr_Tr, Transit_t* His_Curr_Tr,
                             Transit_t* My_Best_Tr, Transit_t* His_Best_Tr,
                             Lay_Sel_t* Best_Score, Player_t   Player,
                             Search_t   s) ;
void    Choose_Move (Transit_t* Mine,    Transit_t* His,
                     Player_t   Player,  short Moves_Done,
                     Transit_t* My_Best, Transit_t* His_Best,
                     Lay_Sel_t* Best,    Search_t s) ;
void    Execute_Move (char p, char Die, Transit_t* Mine, Transit_t* His) ;
boolean Can_Move (char p, char Die, Layout_t Me, Layout_t Him) ;
void    Copy_Layout (Layout_t Dst, Layout_t Src) ;
boolean Bearing_Off (Layout_t Lay) ;
short   Won (Layout_t Me, Layout_t Him) ;
boolean Pieces_Behind (Layout_t Me, short p) ;
void    Check_Layout (Layout_t Layout, char* Err_Mess) ;
void    Copy_Transit (Transit_t* Dest, Transit_t* Source) ;
void    Init_Transit (Transit_t* New, Layout_t Old) ;
boolean Move_Possible (Layout_t P_Lay, Layout_t O_Lay) ;

/* BG_STDOP.C */
boolean Standard_Opening (Dice_t*    The_Dice,
                          Transit_t* My_Old_Tr,  Transit_t* His_Old_Tr,
                          Transit_t* My_Best_Tr, Transit_t* His_Best_Tr) ;

/* BG_USER1.C */
void    Setup (Speed_t* Speed, Player_t* Human, short* Opponent) ;
boolean Top_Level_Interact (Speed_t* Speed, Player_t* Human, short* Op) ;
void    Top_Level_Menu (boolean Draw) ;
void    Draw_Field (ushort Field, String_Menu_t* Item, ushort Colour) ;
int     Get_Key (void) ;
void    Help (void) ;
boolean First_Interaction (Speed_t* Speed, Player_t* Man, short* Op) ;
short   Get_Vmode (void) ;
void    Protect (void) ;
void    Decode (uchar* String, ushort* Shorts, ushort Checksum) ;
void    Make_Key (char* Key, char* Resp) ;
ushort  Get_Check_Sum (uchar* String) ;
void    Demask (char* String) ;
void    Decode_And_Show_Titles (void) ;
void    Show_Titles (void) ;

/* BG_USER2.C */
char User_Selects_Move (Dice_t* Dice, Layout_t Mine, Layout_t His_Old,
                        Transit_t* My_Best_Tr, Transit_t* His_Best_Tr,
                        Player_t   Player) ;
short Get_User_Point_Choice (char* Key, Player_t p, short Shape) ;
short Legal_Start (Transit_t* Me, Transit_t* Him, Dice_t* Dice, short Point,
                   short End_Points[MAX_MOVES], short D_I_List[MAX_MOVES]) ;
short Legal_End (short Point, short List[MAX_MOVES], short N_Ends) ;
void  Update_User_Move (Layout_t User, Layout_t Comp, Player_t Player) ;
void  Init_Human_Vars (short*  Moves_Made, Dice_t* Pool, Dice_t* Dice,
                       Transit_t* Loc_User, Transit_t* Loc_Comp,
                       Layout_t   User_Old, Layout_t   Comp_Old) ;
void  User_Error_Exit (void) ;
void  Show_Threat (Layout_t Me, Layout_t Him, short Point) ;
short Key_And_Delay (short Seconds) ;
