//
// BARCODES-PLUS 4.5.0
// GRAFTech Development Corporation
// Copyright (c) 1988-95 - All Rights Reserved
//
// MSVCDEMO.C
//

#include <windows.h>
#include <malloc.h>
#include <string.h>
#include "msvcdemo.h"

     typedef struct
     {
                   int   bwidth;       // Bar Code Width
                   int   bhight;       // Bar Code Height
                   int   symbol;       // Bar Code Symbology
                   int   endlen;       // Bar Code Data Length
          unsigned char  endata[29];   // Bar Code Data
          unsigned char  check1[2];    // Bar Code Check Digit 1
          unsigned char  check2[2];    // Bar Code Check Digit 2
          unsigned char  header[50];   // Human Readable Header
     } BCP450DT ;
    
     static BCP450DT  Bc_Data;
            
     int  FAR  PASCAL  _export  BCPWBMP( HWND , BCP450DT * );

     static void  GDCBitmap ( HDC, HBITMAP, short, short ) ;
     static int   GDCbitm   ( HWND, int ) ;
     static void  GDCTitle  ( HDC, unsigned char *, short ) ;
     
     long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;

     static char szAppName [] = "bitclip" ;
     static char BCPTitle[100] ;
     static int a, b, c, d, x, y, z ;
     static int BCPError ;
     static RECT rect ;
     static HDC hdc ;
     static HBITMAP  gdcBitmap ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     BCPError = -1 ;

     if (!hPrevInstance) 
     {    wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon ( hInstance, szAppName ) ;
          wndclass.hCursor       = LoadCursor (hInstance, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;
          RegisterClass (&wndclass) ; }

     hwnd = CreateWindow ( szAppName, 
                           "GRAFTech Development Corporation",
                           WS_OVERLAPPEDWINDOW,
                           0,       //CW_USEDEFAULT, 
                           0,       //CW_USEDEFAULT,
                           600,     //CW_USEDEFAULT, 
                           300,     //CW_USEDEFAULT,
                           NULL, 
                           NULL, 
                           hInstance, 
                           NULL ) ;

     ShowWindow (hwnd, nCmdShow) ;

     hdc = GetDC( hwnd ) ;
     
     UpdateWindow (hwnd) ;
     
     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam,
                                                          LONG lParam)
{
     PAINTSTRUCT    ps ;
     int            RET ;
     
     switch (message)
          {
          case WM_COMMAND:
               SelectObject (hdc, GetStockObject ( WHITE_PEN )) ;
               SelectObject (hdc, GetStockObject ( WHITE_BRUSH )) ;
               Rectangle (hdc, 10, 10, 490, 290) ;
               Bc_Data.bwidth = 2 ;
               Bc_Data.bhight = 20 ;
               switch ( wParam )
               {
                    case GDCM_UPCA :
                         strcpy( BCPTitle, "UPC Version A@" ) ;
                         Bc_Data.symbol = 100 ;
                         strcpy(Bc_Data.endata, "78211301054") ;
                         Bc_Data.endlen = 11 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_UPCE :
                         strcpy( BCPTitle, "UPC Version E@" ) ;
                         Bc_Data.symbol = 125 ;
                         strcpy(Bc_Data.endata, "01230000026") ;
                         Bc_Data.endlen = 11 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_UEI1 :
                         strcpy( BCPTitle, "UPC/EAN/IAN - 13@" ) ;
                         Bc_Data.symbol = 150 ;
                         strcpy(Bc_Data.endata, "108322612378") ;
                         Bc_Data.endlen = 12 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_UEI8 :
                         strcpy( BCPTitle, "UPC/EAN/IAN - 8@" ) ;
                         Bc_Data.symbol = 155 ;
                         strcpy(Bc_Data.endata, "2664345") ;
                         Bc_Data.endlen = 7 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_I25C :
                         strcpy( BCPTitle, "Interleaved 2 of 5 - Commercial Length@" ) ;
                         Bc_Data.symbol = 200 ;
                         strcpy(Bc_Data.endata, "1078211300054") ;
                         Bc_Data.endlen = 13 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_I25V :
                         strcpy( BCPTitle, "Interleaved 2 of 5 - Variable Length@" ) ;
                         Bc_Data.symbol = 205 ;
                         strcpy(Bc_Data.endata, "1108322612378") ;
                         Bc_Data.endlen = 13 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_I25N :
                         strcpy( BCPTitle, "Interleaved 2 of 5 - No Check Digit@" ) ;
                         Bc_Data.symbol = 210 ;
                         strcpy(Bc_Data.endata, "102781310540") ;
                         Bc_Data.endlen = 12 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_S252C :
                         strcpy( BCPTitle, "Standard 2 of 5 - 2:1 Check Digit@" ) ;
                         Bc_Data.symbol = 300 ;
                         strcpy(Bc_Data.endata, "1450280911") ;
                         Bc_Data.endlen = 10 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_S252N :
                         strcpy( BCPTitle, "Standard 2 of 5 - 2:1 No Check Digit@" ) ;
                         Bc_Data.symbol = 305 ;
                         strcpy(Bc_Data.endata, "918273540") ;
                         Bc_Data.endlen = 9 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_S253C :
                         strcpy( BCPTitle, "Standard 2 of 5 - 3:1 Check Digit@" ) ;
                         Bc_Data.symbol = 320 ;
                         strcpy(Bc_Data.endata, "11772345") ;
                         Bc_Data.endlen = 8 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_S253N :
                         strcpy( BCPTitle, "Standard 2 of 5 - 3:1 No Check Digit@" ) ;
                         Bc_Data.symbol = 325 ;
                         strcpy(Bc_Data.endata, "623802") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39R2N :
                         strcpy( BCPTitle, "Code 39 - 2:1 No Check Digit (Standard)@" ) ;
                         Bc_Data.symbol = 400 ;
                         strcpy(Bc_Data.endata, "102689") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39R2C :
                         strcpy( BCPTitle, "Code 39 - 2:1 Check Digit (Standard)@" ) ;
                         Bc_Data.symbol = 405 ;
                         strcpy(Bc_Data.endata, "940117") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39F2N :
                         strcpy( BCPTitle, "Code 39 - 2:1 No Check Digit (Extended)@" ) ;
                         Bc_Data.symbol = 410 ;
                         strcpy(Bc_Data.endata, "080157") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39F2C :
                         strcpy( BCPTitle, "Code 39 - 2:1 Check Digit (Extended)@" ) ;
                         Bc_Data.symbol = 415 ;
                         strcpy(Bc_Data.endata, "120278") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39R3N :
                         strcpy( BCPTitle, "Code 39 - 3:1 No Check Digit (Standard)@" ) ;
                         Bc_Data.symbol = 440 ;
                         strcpy(Bc_Data.endata, "L30501") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39R3C :
                         strcpy( BCPTitle, "Code 39 - 3:1 Check Digit (Standard)@" ) ;
                         Bc_Data.symbol = 445 ;
                         strcpy(Bc_Data.endata, "918-56") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39F3N :
                         strcpy( BCPTitle, "Code 39 - 3:1 No Check Digit (Extended)@" ) ;
                         Bc_Data.symbol = 450 ;
                         strcpy(Bc_Data.endata, "98105") ;
                         Bc_Data.endlen = 5 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C39F3C :
                         strcpy( BCPTitle, "Code 39 - 3:1 Check Digit (Extended)@" ) ;
                         Bc_Data.symbol = 455 ;
                         strcpy(Bc_Data.endata, "14693") ;
                         Bc_Data.endlen = 5 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C93 :
                         strcpy( BCPTitle, "Code 93@" ) ;
                         Bc_Data.symbol = 500 ;
                         strcpy(Bc_Data.endata, "11305") ;
                         Bc_Data.endlen = 5 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C128A :
                         strcpy( BCPTitle, "Code 128 - Series 'A'@" ) ;
                         Bc_Data.symbol = 600 ;
                         strcpy(Bc_Data.endata, "ABC123") ;
                         Bc_Data.endlen = 6 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C128B :
                         strcpy( BCPTitle, "Code 128 - Series 'B'@" ) ;
                         Bc_Data.symbol = 605 ;
                         strcpy(Bc_Data.endata, "12345def") ;
                         Bc_Data.endlen = 8 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_C128C :
                         strcpy( BCPTitle, "Code 128 - Series 'C'@" ) ;
                         Bc_Data.symbol = 610 ;
                         strcpy(Bc_Data.endata, "GHIJKLMN") ;
                         Bc_Data.endlen = 8 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_CBARN :
                         strcpy( BCPTitle, "Codabar - No Check Digit@" ) ;
                         Bc_Data.symbol = 700 ;
                         strcpy(Bc_Data.endata, "A98776A") ;
                         Bc_Data.endlen = 7 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_CBARC :
                         strcpy( BCPTitle, "Codabar - Check Digit@" ) ;
                         Bc_Data.symbol = 705 ;
                         strcpy(Bc_Data.endata, "B24236B") ;
                         Bc_Data.endlen = 7 ;
                         BCPError = BCPWBMP( hwnd, &Bc_Data ) ;
                         SendMessage( hwnd, WM_PAINT, 0, 0L ) ;
                         return 0 ;
                    case GDCM_HELP1 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 1) ;
                         return 0 ;
                    case GDCM_HELP2 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 100) ;
                         return 0 ;
                    case GDCM_HELP3 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 105) ;
                         return 0 ;
                    case GDCM_HELP4 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 110) ;
                         return 0 ;
                    case GDCM_HELP5 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 500) ;
                         return 0 ;
                    case GDCM_HELP6 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_CONTEXT, 1000) ;
                         return 0 ;
                    case GDCM_HELP7 :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_HELPONHELP, 0) ;
                         return 0 ;
                    case GDCM_HELP8 :
                         return 0 ;
                    case GDCM_EXIT :
                         RET = WinHelp( hwnd, "BCP450.HLP", HELP_QUIT, 0) ;
                         SendMessage( hwnd, WM_CLOSE, 0, 0L ) ;
                         return 0 ;
               }
          case WM_PAINT:
               BeginPaint (hwnd, &ps) ;
               if( BCPError != -1 )
               {
                    for( x = 0 ; x < 100 ; x++ )
                    {
                         if( BCPTitle[x] == '@' ) break ;
                    }
                    GDCTitle( hdc, BCPTitle, x ) ;
                    b = GDCbitm( hwnd, BCPError ) ;
               }
               EndPaint (hwnd, &ps) ;
               return 0 ;
          case WM_DESTROY:
               RET = WinHelp( hwnd, "BCP450.HLP", HELP_QUIT, 0) ;
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

void GDCBitmap ( HDC hdc, HBITMAP hBitmap, short xStart, short yStart )
{
     BITMAP    bm ;
     HDC       hdcMem ;
     POINT     ptSize, ptOrg ;
     
     hdcMem = CreateCompatibleDC ( hdc ) ;
     SelectObject ( hdcMem, hBitmap ) ;
     SetMapMode ( hdcMem, GetMapMode ( hdc ) ) ;
     
     GetObject ( hBitmap, sizeof ( BITMAP ), (LPSTR) &bm ) ;
     ptSize.x = bm.bmWidth ;
     ptSize.y = bm.bmHeight ;
     DPtoLP ( hdc, &ptSize, 1 ) ;
     
     ptOrg.x = 0 ;
     ptOrg.y = 0 ;
     DPtoLP ( hdc, &ptOrg, 1 ) ;
     
     BitBlt ( hdc, xStart, yStart, ptSize.x, ptSize.y,
              hdcMem, ptOrg.x, ptOrg.y, SRCCOPY ) ;

     StretchBlt ( hdc, xStart, ( yStart + 40 ), ptSize.x, (ptSize.y * 2),
                  hdcMem, ptOrg.x, ptOrg.y, ptSize.x, ptSize.y,
                  SRCCOPY ) ;
              
     DeleteDC ( hdcMem ) ;
}

int GDCbitm ( HWND hwnd, int a )
{
     unsigned char line1[250];
          
     strcpy( line1, "Returned Error Code:  " ) ;
     c = strlen( line1 ) ;
     line1[c++] = (char) (a + 48) ;
     TextOut( hdc, 35, 40, line1, c ) ;
     strcpy( line1, "            Check Digit 1:  " ) ;
     c = strlen( line1 ) ;
     line1[c++] = Bc_Data.check1[0] ;
     TextOut( hdc, 35, 56, line1, c ) ;
     strcpy( line1, "            Check Digit 2:  " ) ;
     c = strlen( line1 ) ;
     line1[c++] = Bc_Data.check2[0] ;
     TextOut( hdc, 35, 72, line1, c ) ;
     strcpy( line1, "     Bar Code Header:  " ) ;
     c = strlen( line1 ) ;
     for( x = 0 ; x < 50 ; x++ ) 
     {    if( 0 == Bc_Data.header[x] ) break ;
          line1[c++] = Bc_Data.header[x] ; }
     TextOut( hdc, 35, 88, line1, c ) ;
     OpenClipboard ( hwnd ) ;
     if( gdcBitmap = GetClipboardData ( CF_BITMAP ) )
          GDCBitmap ( hdc, gdcBitmap, 15, 115 ) ;
     CloseClipboard () ;

     return 0 ;
}

void GDCTitle ( HDC hdc, unsigned char *Title, short Tlen )
{
     SetTextColor( hdc, RGB( 255, 0, 0 ) ) ;
     TextOut( hdc, 35, 20, Title, Tlen ) ;
     SetTextColor( hdc, RGB( 0, 0, 0 ) ) ;
}
