/*
 * | BARCODES-PLUS 4.5.0
 * | GRAFTech Development Corporation
 * | Copyright (c) 1988-95 - All Rights Reserved
 * |
 * | BCP450.H
 * |
 * | ELEMENT   TYPE   LENGTH   DESCRIPTION
 * |
 * | BWIDTH    INTEGER         BAR CODE WIDTH
 * |   [1 THRU 50] THE NUMBER OF PIXELS (SMALLEST IMAGE ELEMENT UNITS)
 * |               TO BE USED FOR THE NARROW BAR OR SPACE WIDTH
 * |
 * | BHIGHT    INTEGER         BAR CODE HEIGHT
 * |   [1 THRU 50] THE NUMBER OF PIXELS (SMALLEST IMAGE ELEMENT UNITS)
 * |                TO BE USED FOR THE OVERALL BAR CODE HEIGHT
 * |
 * | SYMBOL    INTEGER         BAR CODE SYMBOLOGY
 * |   [100] UPC VERSION A
 * |   [125] UPC VERSION E
 * |   [150] UPC/EAN/IAN - 13
 * |   [155] UPC/EAN/IAN - 8
 * |   [200] INTERLEAVED 2 OF 5 - COMMERCIAL LENGTH
 * |   [205] INTERLEAVED 2 OF 5 - VARIABLE
 * |   [210] INTERLEAVED 2 OF 5 - NO CHECK DIGIT
 * |   [300] STANDARD CODE 2 OF 5 - 2:1 CHECK DIGIT
 * |   [305] STANDARD CODE 2 OF 5 - 2:1 NO CHECK DIGIT
 * |   [320] STANDARD CODE 2 OF 5 - 3:1 CHECK DIGIT
 * |   [325] STANDARD CODE 2 OF 5 - 3:1 NO CHECK DIGIT
 * |   [400] CODE 39 (3 OF 9) - 2:1 NO CHECK DIGIT
 * |   [405] CODE 39 (3 OF 9) - 2:1 CHECK DIGIT
 * |   [410] CODE 39 (3 OF 9) - 2:1 NO CHECK DIGIT (FULL 128 ASCII)
 * |   [415] CODE 39 (3 OF 9) - 2:1 CHECK DIGIT (FULL 128 ASCII)
 * |   [440] CODE 39 (3 OF 9) - 3:1 NO CHECK DIGIT
 * |   [445] CODE 39 (3 OF 9) - 3:1 CHECK DIGIT
 * |   [450] CODE 39 (3 OF 9) - 3:1 NO CHECK DIGIT (FULL 128 ASCII)
 * |   [455] CODE 39 (3 OF 9) - 3:1 CHECK DIGIT (FULL 128 ASCII)
 * |   [500] CODE 93
 * |   [600] CODE 128 - SERIES "A"
 * |   [605] CODE 128 - SERIES "B"
 * |   [610] CODE 128 - SERIES "C"
 * |   [700] CODABAR - NO CHECK DIGIT
 * |   [705] CODABAR - CHECK DIGIT
 * |    
 * | ENDLEN    INTEGER         BAR CODE DATA LENGTH
 * |   [1 THRU 28] THE NUMBER OF VALID CHARACTERS CONTAINED IN THE BAR
 * |               CODE DATA FIELD
 * |
 * | ENDATA    CHAR     29     BAR CODE DATA
 * |   ANY VALID CHARACTERS FOR SPECIFIED BAR CODE SYMBOLOGY
 * |
 * | CHECK1    CHAR      2     RETURNED BAR CODE CHECK DIGIT 1
 * |   RETURNS THE FIRST BAR CODE DATA CHECK DIGIT (IF REQUIRED)
 * |
 * | CHECK2    CHAR      2     RETURNED BAR CODE CHECK DIGIT 2
 * |   RETURNS THE SECOND BAR CODE DATA CHECK DIGIT (IF REQUIRED)
 * |
 * | HEADER    CHAR     50     RETURNED HUMAN READABLE HEADER
 * |   RETURNS THE BAR CODE DATA HUMAN READABLE HEADER (IF APPLICABLE)
 * |
 * |
 * |
 * | FUNCTION RETURN CODE (INTEGER)
 * |      [0] SUCCESSFUL - NO ERRORS
 * |      [1] INVALID BAR CODE WIDTH
 * |      [2] INVALID BAR CODE HEIGHT
 * |      [3] INVALID BAR CODE SYMBOLOGY
 * |      [4] INVALID BAR CODE DATA CHARACTERS
 * |      [5] INVALID BAR CODE DATA LENGTH
 * |    [100] UNABLE TO ALLOCATE REQUIRED MEMORY
 * |    [900] GENERAL PROGRAM/LIBRARY FAULT
 * |   [1000] INVALID DEMONSTRATION PROGRAM CALL
 * |
 */

	typedef struct
	{
			    int   bwidth;       // Bar Code Width
			    int   bhight;       // Bar Code Height
			    int   symbol;       // Bar Code Symbology
			    int   endlen;       // Bar Code Data Length
		unsigned char  endata[29];   // Bar Code Data
		unsigned char  check1[2];    // Bar Code Check Digit 1
		unsigned char  check2[2];    // Bar Code Check Digit 2
		unsigned char  header[50];   // Human Readable Header
	} BCP450DT ;

    int  FAR  PASCAL  _export  BCPWBMP( HWND, BCP450DT * );

    static  BCP450DT  Bc_Data;

