@echo off
cls
rem -------------------------------------------------------------------
rem   This batch file copies key BlueBook components (files) FROM your
rem installation directory TO a directory that you specify WHICH IS IN
rem YOUR SYSTEM PATH.
rem   This is so that, when running from DOS, you can run from ANY
rem directory simply by executing BLUEBOOK.EXE wherever it happens to
rem be.  In other words, so you do not have to put BlueBook's own
rem directory ("C:\BLUEBOOK" ?) in your PATH, or be continually
rem changing to it when you want to run the program.
rem -------------------------------------------------------------------
rem   The files copied are:
rem   - BBMain.Exe     (main BlueBook program launched by BLUEBOOK.EXE)
rem   - BBIni.Exe      (program to set options in BLUEBOOK.INI file)
rem   - BBView.Com     (file viewing utility - from DOS or via BBMain)
rem   - BlueBook.Hlp   (Help file for BlueBook's internal Help button)
rem   - BlueBook.Doc   (Manual: viewable from Help if with above file)
rem   - BBZipBak.Bat   (implements backup-with-compression in BlueBook)
rem   - BBZip.Bat      (implements automatic database zip compression)
rem   - BBPull.Bat     (autocompression of other files: document mgmt)
rem   - AskUser.Exe    (general yes/no-type utility used by BBPull.Bat)
rem   If you choose the delete option after copying, what you are
rem effectively doing is a MOVE - saves on disk space, but may cause
rem SLIGHTLY slower performance.  It's up to you.
rem -------------------------------------------------------------------
echo You are about to copy BlueBook components
if "%1"=="" goto noparms
if "%2"=="" goto noparms
echo -------------------------------------------------------
echo Do you want to continue?
echo -------------------------------------------------------
%1\askuser Type Y to proceed, N to cancel.....
if errorlevel 1 goto doit
goto endit
:doit
cls
copy %1\bbview.com   %2\bbview.com
copy %1\bbmain.exe   %2\bbmain.exe
copy %1\bbini.exe    %2\bbini.exe
copy %1\bbzipbak.bat %2\bbzipbak.bat
copy %1\bbzip.bat    %2\bbzip.bat
copy %1\bbpull.bat   %2\bbpull.bat
copy %1\askuser.exe  %2\askuser.exe
copy %1\bluebook.hlp %2\bluebook.hlp
copy %1\bluebook.doc %2\bluebook.doc
echo Copying complete.
echo -------------------------------------------------------
echo Did it work?  Do you want to delete the original files?
echo -------------------------------------------------------
%1\askuser Type Y to delete, N to cancel.....
if errorlevel 1 goto wipe
goto stop
:wipe
del %1\bbmain.exe
del %1\bbzipbak.bat
del %1\askuser.exe
del %1\bluebook.hlp
del %1\bluebook.doc
echo Original files deleted.
:done
echo Transfer complete.
echo -------------------------------------------------------
echo This file, "CopyFilz.Bat", can now be deleted.
goto stop
:noparms
echo -------------------------------------------------------
echo But you did not say what drive and directory you want
echo to copy/move from, and to...
echo -------------------------------------------------------
echo Assuming your installed to C:\BLUEBOOK, and supposing
echo you want to transfer files to C:\UTILS, you type:
echo "c:\bluebook\copyfilz  c:\bluebook  c:\utils  [Enter]"
:endit
echo -------------------------------------------------------
echo CopyFilz aborted.
:stop
pause
