@echo off
rem -------------------------------------------------------------------
rem BBZIP is a sample batch file to indicate how to keep your databases
rem and pick list files in space-saving compressed format except when
rem actually in use.  You can use it "off the shelf" but you'll need to
rem
rem (1)  remember to open compressed databases indirectly, using BBZip;
rem (2)  give up using BlueBook's File/Next command;
rem (3)  have PKZip.Exe and PKUnZip.Exe accessible via your PATH;
rem (4)  ensure BlueBook, BBMain, BBView & BBSort are also accessible
rem      (ie, in the current directory, or one in your PATH statement).
rem
rem See ":help", below, for input details and restrictions
rem NB: You may need to add a path before BlueBook in "BlueBook %1\%2".
rem -------------------------------------------------------------------
rem Note that databases do not have to be compressed BEFORE using BBZip
rem -------------------------------------------------------------------
rem ALL LINES STARTING "rem" CAN BE DELETED - ACTUAL BATCH FILE FOLLOWS
rem ===================================================================
if "%1"=="?" goto help
if "%1"==""  goto usage
if "%2"==""  goto usage
rem -------------------------------------------------------------------
rem                     where %1 and %2 are your parameter strings
rem -------------------------------------------------------------------
PKUnZip   %1\%2.ZIP  %2.BB* %2.PL* %1\
BlueBook  %1\%2
PKZip -mu %1\%2.ZIP  %1\%2.BB* %1\%2.PL*
rem -------------------------------------------------------------------
rem                     "-mu" (move/update) moves files back to zip
rem                     ONLY if updated, a move being a copy plus
rem                     delete.  Files that have not been updated are
rem                     simply deleted.
rem -------------------------------------------------------------------
goto end
:help
cls
echo        BBZip.Bat --- BlueBook "compression in place" batch file utility
echo        ----------------------------------------------------------------
echo        Allows DATABASES to be stored compressed, and expanded as needed
echo        then automatically recompressed after use.  You'll need programs
echo        PKZip/UnZip, BlueBook/BBMain, BBView and BBSort (if you have it)
echo        accessible at runtime - ie, in current directory or system PATH.
echo        ----------------------------------------------------------------
echo            You must supply
echo        (1) a shared PATH (only) for both zipfile AND database, plus
echo        (2) a shared NAME (only - no extension) for zipfile AND database
echo            in that order, separated by spaces.
echo        Zipfile and database MUST share the same name
echo        Pre-zipped databases MUST be in a file with a ".zip" extension
echo        eg, for zip file:    C:\BlueBook\AnyDBase.Zip   { zipped dbase }
echo                 YOU RUN:    bbzip  c:\bluebook  anydbase
echo            for zip file:    A:\Another1.Zip            {NB: no \ below}
echo                 YOU RUN:    bbzip  a:  another1
echo            for database:    C:\Docs\YetMore.BBL,I & D  {not yet zipped}
echo                 YOU RUN:    bbzip  c:\docs  yetmore
echo        ----------------------------------------------------------------
echo        NB: For correct operation, PATH must NEVER end in a "\"
echo        ----------------------------------------------------------------
goto end
:usage
cls
echo BBZip.Bat
echo ---------
echo Parameters:    PATH to Zip & Dbase    ZipFile & Database NAME (only)
echo eg:            c:\bluebook            anydbase
echo would unzip database "anydbase" from "anydbase.zip" in "c:\bluebook"
echo --------------------------------------------------------------------
echo NB - PATH must NEVER end in "\"      (Run "BBZip ?" for fuller help)
echo --------------------------------------------------------------------
:end
