/*****************************************************************************
 *                                                                           *
 *    BBBS is Copyright 1990,1992-1995, Kim Heino and Tapani T. Salmi.       *
 *                                                                           *
 *    Definitions and variables for BBBS, version number is below.           *
 *    You may use this file as long as this is totally unmodified.           *
 *    We take no responsibility over any program using this file.            *
 *                                                                           *
 *****************************************************************************/

#pragma pack(1)

#if defined(__GNUC__) && !defined(__MSDOS__) && !defined(__OS2__) && !defined(AMIGA)
typedef unsigned char         boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
typedef unsigned long int     ulong;      /* 32 bit, unsigned */
#endif
#if defined(__MSDOS__)
typedef unsigned char         boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
typedef unsigned long int     ulong;      /* 32 bit, unsigned */
#endif
#if defined(__OS2__)
typedef unsigned char         boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
typedef unsigned long int     ulong;      /* 32 bit, unsigned */
#endif
#if defined(AMIGA)
typedef unsigned char         boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
typedef unsigned long int     ulong;      /* 32 bit, unsigned */
#endif

#define true                  1
#define false                 0
#define Lund                  false
#define Kube                  void

#if defined(__MSDOS__)
#define lines_in_editor       1000        /* max lines in editor */
#define max_msg               2048        /* max unread messages per area */
#else
#define lines_in_editor       4096        /* max lines in editor */
#define max_msg               8192        /* max unread messages per area */
#endif
#define buffer_len            4096        /* com incoming buffer length, must be 2^something */
#define buffer_open           3000
#define buffer_close          3900
#define buffer_out_len        4096        /* com outgoing buffer length */
#define txtsize               660         /* bbbstxt lines */
#define commands_saved        20          /* inputs saved */
#define fileaccess_NONE       0
#define fileaccess_W          2
#define fileaccess_R          4
#define desclen               768
#define linkoverflow          128
#define num_of_akas           10

#define stat_must       1       /* status bits */
#define stat_member     2
#define stat_invite     4
#define stat_fidoarea   8
#define stat_postarea   16
#define stat_allowpriv  32
#define stat_nomarks    64
#define stat_noreply    128
#define stat_nostrip    256
#define stat_allfix     512
#define stat_namefix    1024
#define stat_alias      2048
#define stat_sempty5    4096
#define stat_sempty6    8192
#define stat_moderated  16384   /* used internally, DO NOT SET */
#define stat_sempty7    32768

#define mstat_killed    1       /* mstatust bits */
#define mstat_mempty12  2
#define mstat_private   4
#define mstat_sent      8
#define mstat_readed    16
#define mstat_extraline 32
#define mstat_nntpsent  64
#define mstat_mempty3   128
#define mstat_mempty4   256
#define mstat_mempty5   512
#define mstat_mempty6   1024
#define mstat_mempty7   2048
#define mstat_mempty8   4096
#define mstat_mempty9   8192
#define mstat_mempty10  16384
#define mstat_mempty11  32768

#define char_IBM        0       /* charsets */
#define char_SF7        1
#define char_ISO        2
#define char_IBN        3
#define char_US7        4
#define char_GE7        5
#define char_NO7        6
#define char_FR7        7
#define char_IT7        8
#define char_SP7        9
#define char_MAC        10

#define acc_readmsg     1       /* accesst bits */
#define acc_writemsg    2
#define acc_aempty12    4
#define acc_aempty13    8
#define acc_sigop       16
#define acc_aempty1     32
#define acc_aempty2     64
#define acc_aempty3     128
#define acc_aempty4     256
#define acc_aempty5     512
#define acc_aempty6     1024
#define acc_aempty7     2048
#define acc_aempty8     4096
#define acc_aempty9     8192
#define acc_aempty10    16384
#define acc_aempty11    32768

#define bzs_alias_len   1024
#define bzs_set_len     1024
#define bzs_end         0
#define bzs_foo2        1
#define bzs_alias       2
#define bzs_set         3
#define bzs_script      4

#define bun_year(l)     (int)(((l>>25) & 127)+80)
#define bun_month(l)    (int)((l>>21) & 15)
#define bun_day(l)      (int)((l>>16) & 31)
#define bun_hour(l)     (int)((l>>11) & 31)
#define bun_minute(l)   (int)((l>>5) & 63)
#define bun_second(l)   (int)((l & 31)<<1)

struct userrec {                /* maindir/bbbsusr.dat */
  char            name[30];
  byte            password[16];
  char            address[30];
  char            city[30];
  char            phone[18];
  char            birth[18];
  byte            ok2login;     /* 0=yes,1=getlost,2=killed */
  byte            termcap;      /* Bit 0-3: 0=TTY,1=ANSI,3=VT320, Bit 4-7: 0=Line,1=FSE,2=MG */
  byte            pagelength;
  byte            charset;
  byte            language;     /* 0..9 (0=English,1=Suomi,2=Svenska,3=Norsk) */
  byte            readmode;     /* Bit 0-3: 0=Marked,1=Reference,2=Forward, Bit 4-7: 0=Text,1=Hippo1,2=Hippo2,3=OMEN,4=QWK */
  byte            packtype;     /* 0=text,1=arc,2=zip,3=lzh,4=arj,5=zoo,6=hpk,7=rar */
  byte            protocol;     /* 0=Z,1=Y,2=X,3=SHYDRA,4=XCRC,5=YB,6=SZmodem,7=HYDRA,8=ZedZap */
  byte            nodemsgfilt;
  integer         timelimit;
  integer         timeleft;
  word            timeson;
  word            msgleft;
  word            uploaded;
  word            downloaded;
  word            pmsgleft;
  word            pfileup;
  word            pfiledown;
  word            pcalled;
  word            fchecked;
  word            timebank;
  word            resume;
  word            limits;
  ulong           access;       /* Bit 0=DOS,1=Confs,2=Files,3=Priv,4=Pass,30=Download,31=Upload */
  ulong           utoggles;     /* Bit 0=!Insert,1=Indent,2=XYdisp,3=!Flash,4=ConfS,5=Expert,6=G&R,7=Colors,8=Review,9=RealVT100keyboard,10=Quote,11=Silent */
  ulong           envpos;
  ulong           lasttime;
  ulong           msgread;
  ulong           msgdumped;
  ulong           bytesup;
  ulong           bytesdown;
  ulong           userbits;     /* Feel free to use this variable as you want - just note that somebody else might also use it */
  ulong           todaydown;
  word            pminutes;
  word            account;
  byte            uempty[11];   /* 0=none */
  byte            bztype;
  ulong           bzlong;
};

#define uacc_sysop_mask         0x000000FF
#define uacc_dos                0x00000001
#define uacc_confs              0x00000002
#define uacc_files              0x00000004
#define uacc_priv               0x00000008
#define uacc_pass               0x00000010
#define uacc_useredit           0x00000020
#define uacc_download           0x40000000
#define uacc_upload             0x80000000

#define utog_not_insert         0x00000001
#define utog_indent             0x00000002
#define utog_xydisp             0x00000004
#define utog_not_flash          0x00000008
#define utog_confs              0x00000010
#define utog_expert             0x00000020
#define utog_gr                 0x00000040
#define utog_colors             0x00000080
#define utog_review             0x00000100
#define utog_vt100key           0x00000200
#define utog_quote_include      0x00000400
#define utog_silent             0x00000800
#define utog_return             0x00001000

struct account {
  char    name[30];
  longint money;
  word    flags;          /* bit 0:allow nega */
  word    users;          /* # of users in this account */
};

#define account_negative        0x0001

struct msgrec {                 /* maindir/ *.dat */
  word            number;
  char            msgfrom[30];
  word            msgfromn;
  char            msgto[30];
  word            msgton;
  char            subject[40];
  word            status;
  ulong           offset;
  word            lines;
  ulong           dated;
  word            replyto;
  word            nextreply;
  word            firstreply;
  word            zonefrom;
  word            netfrom;
  word            nodefrom;
  longint         msgid;
};

struct hihhi {                  /* maindir/bbbshi.dat */
  word            times;
  word            unused2;      /* day# */
  char            name[30];
  char            msg[80];
};

struct noderec {                /* tempdir/bbbsnode */
  word            split;        /* unused */
  byte            bstatus;      /* Bit 0=MNP, 1=mailsession */
  byte            zstatus;      /* 0=off,1=active,2=not,3=writing,4=grab,5=down,6=up,7=chat,8=door,9=groupchat,10=telnet */
  ulong           speed;        /* 0=local */
  word            time;
  word            endtime;      /* when downloading */
  char            name[46];
  char            realname[30];
};

struct chatrec {                /* tempdir/bbbsmsg.* */
  word            node;
  word            filter;
  char            msg[80];
};

struct bstatrec {               /* maindir/bbbsstat.dat */
  ulong           data [7]      /* day */
                       [3]      /* user/sysop/fido */
                       [6];     /* day/min/call/msg/up/down */
};

struct cfgrec2 {
  ulong           count_of_confs;
  ulong           post_conf;
  ulong           resume_conf;
  ulong           fileinfo_conf;
};

struct confrec1 {
  word            lastread;
  byte            charsets;             /* hi: bbbs->msg, lo: bbbs<-msg */
  byte            foo;
  word            status;
  char            confname[60];
  char            description[60];
};

struct confrec2 {
  char            fidopath[70];
  char            nntpname[64];
  word            nntphost;
  ulong           nntpnumber;
  word            nodenumber;
  word            originnumber;
  word            moderator_zone;
  word            moderator_net;
  word            moderator_node;
  word            moderator_point;
  word            bpc_min;
  word            bpc_max;
};

/* next: 617 */

struct global_config {
  char    bbbs_name[30],                                /*   0     */
          sysop_name[30],                               /*   1     */
          newu_account[30],                             /* 591     */
          closed_password[8],                           /*   2     */
          grabfile[14],                                 /*   3     */
          maindir[70],                                  /*  10     */
          updir[70],                                    /*  12     */
          tempdir[70],                                  /*  14     */
          menudir[70],                                  /* 278     */
          origins[10][60],                              /*  26- 35 */
          tickdir[70],                                  /* 280     */
          netmail[70],                                  /* 281     */
          extlog[70],                                   /* 526     */
          tmp_in_pkt[70],                               /* 502     */
          tmp_out_pkt[70],                              /* 503     */
          bundle_dir[70],                               /* 504     */
          badechodir[70],                               /* 505     */
          badsecuredir[70],                             /* 506     */
          sitename[60],                                 /* 306     */
          location[60],                                 /* 307     */
          phone[60],                                    /* 308     */
          speed[60],                                    /* 309     */
          flags[60],                                    /* 310     */
          cdtempdrives[40],                             /* 612     */
          akam[10][60],                                 /* 311-320 */
          freq_magic[70],                               /* 357     */
          freq_normal[70],                              /* 358     */
          dialconvfrom[10][27],                         /* 337-346 */
          dialconvto[10][27],                           /* 347-356 */
          faxdir[70],                                   /* 414     */
          btermdown[70],                                /* 417     */
          inbound[70];                                  /* 282     */
  word    max_nodes,                                    /*  36     */
          bankmax,                                      /*  40     */
          whodown_size,                                 /* 291     */
          maxbundlesize,                                /* 615     */
          boguspktsize,                                 /* 530     */
          tranxzone,                                    /* 302     */
          tranxnet,                                     /* 303     */
          tranxnode,                                    /* 304     */
          tranxpoint,                                   /* 305     */
          freqlimit[3][4],                              /* 321-332 */
          limits_kbday[16],                             /* 542-557 */
          cost_start[16],                               /* 558-573 */
          cost_min[16],                                 /* 574-589 */
          cost_hour[16],                                /* 596-611 */
          zone[num_of_akas],                            /*  41- 50 */
          net[num_of_akas],                             /*  51- 60 */
          node[num_of_akas],                            /*  61- 70 */
          point[num_of_akas];                           /*  71- 80 */
  integer newu_time;                                    /*  81     */
  byte    bankrate,                                     /*  84     */
          msgrate,                                      /*  85     */
          tick_convert,                                 /* 286     */
          desc_max_lines,                               /* 289     */
          present_akas,                                 /* 425     */
          limits_byte[16],                              /* 118-133 */
          limits_file[16],                              /* 102-117 */
          rescantime,                                   /* 300     */
          busydelay,                                    /* 333     */
          tries_busy,                                   /* 334     */
          tries_bad,                                    /* 522     */
          faxerror,                                     /* 416     */
          mailerror,                                    /* 301     */
          max_open_files,                               /* 507     */
          bogus_dupes,                                  /* 529     */
          hydra_tx,                                     /* 520     */
          hydra_rx,                                     /* 521     */
          usermailerror;                                /* 411     */
  ulong   newu_access,                                  /*  86     */
          gtoggles;                                     /*  below  */
};

#define cfgg_up_down_check           0x00000001         /*  91     */
#define cfgg_show_privates           0x00000002         /*  92     */
#define cfgg_brobocop                0x00000004         /*  93     */
#define cfgg_hippo                   0x00000008         /*  94     */
#define cfgg_show_empty              0x00000010         /*  97     */
#define cfgg_whotext                 0x00000020         /*  99     */
#define cfgg_pack_messages           0x00000040         /* 290     */
#define cfgg_fido_hydra              0x00000080         /* 292     */
#define cfgg_fido_zedzap             0x00000100         /* 293     */
#define cfgg_fido_tranx              0x00000200         /* 294     */
#define cfgg_fido_unlistnode         0x00000400         /* 295     */
#define cfgg_fido_unlistpoint        0x00000800         /* 296     */
#define cfgg_fido_unprotnode         0x00001000         /* 297     */
#define cfgg_fido_freq_answering     0x00002000         /* 298     */
#define cfgg_fido_freq_calling       0x00004000         /* 299     */
#define cfgg_show_sysop_in_stats     0x00008000         /* 410     */
#define cfgg_bmt_check_destination   0x00010000         /* 413     */
#define cfgg_disable_newu_address    0x00020000         /* 419     */
#define cfgg_disable_newu_birthday   0x00040000         /* 420     */
#define cfgg_users_are_hidden        0x00080000         /* 421     */
#define cfgg_upload_scan             0x00100000         /* 422     */
#define cfgg_poll_all_crashes        0x00200000         /* 423     */
#define cfgg_delete_dup_uploads      0x00400000         /* 424     */
#define cfgg_savebad                 0x00800000         /* 508     */
#define cfgg_savesecure              0x01000000         /* 509     */
#define cfgg_bmt_log_headers         0x02000000         /* 531     */
#define cfgg_no_remote_sysop         0x04000000         /* 532     */
#define cfgg_bogus_save_netmail      0x08000000         /* 541     */
#define cfgg_kb_day_relative         0x10000000         /* 590     */
#define cfgg_global_download         0x20000000         /* 613     */

struct local_config {
  char    modem_init_string1[60],                       /*   4     */
          modem_init_string2[60],                       /* 283     */
          modem_init_string3[60],                       /* 284     */
          modem_hangup_string[60],                      /*   5     */
          modem_busy_string[60],                        /*   6     */
          modem_answer_string[60],                      /* 279     */
          modem_aftercall[60],                          /* 527     */
          data_after_voice[60],                         /* 533     */
          voice_playback[60],                           /* 534     */
          voice_record[60],                             /* 535     */
          voicedir[70],                                 /* 536     */
          voicegreetings[70],                           /* 537     */
          bterm_init[60],                               /* 427     */
          dont_crash_flags[60],                         /* 426     */
          only_crash_flags[60],                         /* 593     */
          fd_dobbs[70],                                 /*   7     */
          logfile[70],                                  /*   8     */
          loginlog[70],                                 /*   9     */
          grabdir[70],                                  /*  11     */
          menudir[70],                                  /*  13     */
          newdir[70],                                   /*  15     */
          voicepass[5],                                 /* 540     */
          dial1[5][20],                                 /* 447-451 */
          dial2[5][10],                                 /* 452-456 */
          dial3[5][50],                                 /* 457-461 */
          macros[10][50],                               /*  16- 25 */
          hotlogin[10][40];                             /* 429-438 */
  word    event_dial_zone[10],                          /* 370-379 */
          event_dial_net[10],                           /* 380-389 */
          event_dial_node[10],                          /* 390-399 */
          event_dial_point[10],                         /* 400-409 */
          base_address;                                 /*  39     */
  byte    irq,                                          /*  82     */
          pollrate,                                     /*  83     */
          checksleep,                                   /* 287     */
          ringingcount,                                 /* 539     */
          answer_ring_count,                            /*  98     */
          screensaver_timeout,                          /* 285     */
          aftercall_lines,                              /* 528     */
          voicecompression,                             /* 538     */
          rush_hour[24],                                /* 134-157 */
          event_day[10],                                /* 158-167 */
          event_start_hour[10],                         /* 168-177 */
          event_start_min[10],                          /* 178-187 */
          event_end_hour[10],                           /* 188-197 */
          event_end_min[10],                            /* 198-207 */
          event_errorlevel[10],                         /* 208-217 */
          event_toggles[10],                            /*  below  */
          event_last_dial[10],                          /* 360-369 */
          event_last_day[10],                           /* 248-257 */
          priorities[8];                                /* 439-446 */
  ulong   start_speed,                                  /*  37     */
          faxbaud,                                      /* 415     */
          min_speed,                                    /*  38     */
          ltoggles;                                     /*  below  */
};

#define cfgl_event_dont_allow_users  0x01               /* 218-227 */
#define cfgl_event_flexible          0x02               /* 228-237 */
#define cfgl_event_must              0x04               /* 238-247 */
#define cfgl_event_dont_allow_mail   0x08               /* 462-471 */
#define cfgl_event_dont_allow_pickup 0x10               /* 472-481 */
#define cfgl_event_dont_send_cm      0x20               /* 482-491 */
#define cfgl_event_send_all          0x40               /* 492-501 */
#define cfgl_event_dont_allow_freq   0x80               /* 510-519 */

#define cfgl_local_bell              0x00000001         /*  87     */
#define cfgl_rts_cts                 0x00000002         /*  88     */
#define cfgl_reset_speed             0x00000004         /*  89     */
#define cfgl_hangup_at_exit          0x00000008         /*  90     */
#define cfgl_set_16550               0x00000010         /*  95     */
#define cfgl_local_sysop_keys        0x00000020         /*  96     */
#define cfgl_local_echo              0x00000040         /* 100     */
#define cfgl_save_screen             0x00000080         /* 101     */
#define cfgl_null_modem_login        0x00000100         /* 288     */
#define cfgl_send_crashmail          0x00000200         /* 359     */
#define cfgl_backdoor                0x00000400         /* 412     */
#define cfgl_fast_fax                0x00000800         /* 418     */
#define cfgl_dont_check_carrier      0x00001000         /* 428     */
#define cfgl_nocarrier_is_busy       0x00002000         /* 523     */
#define cfgl_show_shell_output       0x00004000         /* 524     */
#define cfgl_allow_shell_break       0x00008000         /* 525     */
#define cfgl_slow_protocols          0x00010000         /* 592     */
#define cfgl_fax_receive_revbit      0x00020000         /* 594     */
#define cfgl_fax_send_revbit         0x00040000         /* 595     */
#define cfgl_buffered_output         0x00080000         /* 614     */
#define cfgl_rockwell_kludge         0x00100000         /* 616     */

#if defined(__OS2__) && !defined(BAG) && !defined(BCFG4)

struct comstruct {            /* for named memory communication */
  ulong modemhead, modemtail, s, c;
  byte  modembuf[buffer_len];
};

#endif

#if !defined(__BBBS_NO_EXTERNS__)

extern  char                  *ver;           /* "3.14.95 GT"; Version number   */
extern  char                  hexs[17];       /* "0123456789ABCDEF";      */
extern  char                  *vername;       /* "BBBS/D", "BBBS/2", etc. */

extern  struct userrec        u;
extern  struct global_config  cfgg;
extern  struct local_config   cfgl;
extern  struct cfgrec2        cfg2;
extern  struct noderec        node;
extern  struct fos_struct     fos_info;
extern  struct confrec1       **confs;
extern  FILE                  *grabfile;
extern  char                  *buffer, *outbuffer, *txt[txtsize+1], *txtstart, commands[commands_saved][80], local_buffer[128], comstring[256], temp_string[256], *bzsalias, *bzsset, interface, *areamod, *groups, crrdir[128], holdreal[128], hddesc[128], serna[21];
extern  ulong                 tempsys, startdump, startread, realbaud, baud;
extern  word                  unum, confnro, loginhour, loginmin, lastmsg, curmsg, firstmsg, lastreaded, foryou, newavail, reserved1, reserved2, reserved3, reserved4, msgreaded[max_msg+1], startleft, gnubuf, serno, *lastr, nodenumber, reduced, nextevent;
extern  integer               lastwarn, temptime;
extern  byte                  chartable[2][256], jobtype, com, errl, commands_in_memory, pagecounter, lastinchar, spymode, brobot, dinged, bzltc, bzlts[2], tomenu, getdown, remotey, fossil, forcefossil, script_count, pktcount, currentevent;
extern  boolean               realmnp, carrier, outputstopped, files_checked, desqview, quicklogin, paged, script_running, rupted, bzchanged, askpass, localecho, userlocked, debugmode, nobreaknow;
#if defined(__OS2__) && !defined(BAG) && !defined(BCFG4)
extern  int                   socket1;
extern  HFILE                 modem;
extern  boolean               freemodem, thread_active, broken_pipe;
extern  char                  comdevice[80];
extern  byte                  pipecommunication;
#endif
#if defined(__MSDOS__)
extern  char                  filna[13];
#else
extern  char                  filna[80];
#endif

#endif

/******************************************************************************

confh2o4.dat  word highwater[count_of_confs+1];

confusr4.dat  struct {                                    unum*4L*(count_of_confs+1)+confnro*4L
                word lastread;                                  0
                word status;                                    2
              } userconfstat[count_of_confs+1];

confcfg4.dat  ulong count_of_confs;                        0
              ulong post_conf;                             4
              ulong resume_conf;                           8
              ulong fileinfo_conf;                        12
              struct {                                    16+confnum*282
                word lastread;                                  0
                byte charsets;                                  2
                byte foo;                                       3
                word status;                                    4
                char confnames[60];                             6
                char description[60];                          66
                char fidopath[70];                            126
                char nntpname[64];                            196
                word nntphost;                                260
                ulong nntpnumber;                             262
                word nodenumber;                              266
                word originnumber;                            268
                word moderator_zone;                          270
                word moderator_net;                           272
                word moderator_node;                          274
                word moderator_point;                         276
                word bpc_min;                                 278
                word bpc_max;                                 280
              } confstats[count_of_confs+1];                  282

*******************************************************************************

              A Quick Guide to Convert C struct to Pascal Record

struct foobar {                   type foobar = record
  char b1;                          b1 : shortint;
  char b2[128];                     b2 : string[127];           { 128-1=127 }
  byte b3;                          b3 : byte;
  word b4;                          b4 : word;
  word b5[128];                     b5 : array[0..127] of word; { 128-1=127 }
  integer b6;                       b6 : integer;
  longint b7;                       b7 : longint;
  ulong b8;                         b8 : longint;               { unsigned }
};                                end;


You still have to convert C-alike null-terminated strings (b2) to
Pascal-alike strings.

******************************************************************************/

struct fos_struct {
  word            strsize;        /* size of the structure in bytes     */
  byte            majver;         /* FOSSIL spec driver conforms to     */
  byte            minver;         /* rev level of this specific driver  */
  char            *ident;         /* FAR pointer to ASCII ID string     */
  word            ibufr;          /* size of the input buffer (bytes)   */
  word            ifree;          /* number of bytes left in buffer     */
  word            obufr;          /* size of the output buffer (bytes)  */
  word            ofree;          /* number of bytes left in the buffer */
  byte            swidth;         /* width of screen on this adapter    */
  byte            sheight;        /* height of screen    "      "       */
  byte            speed;          /* ACTUAL speed, computer to modem    */
};

struct ftsc001 {
  char  fromuser[36];
  char  touser[36];
  char  subject[72];
  char  datetime[20];
  word  timesread;        /* not used */
  word  destnode;
  word  orignode;
  word  cost;             /* not used */
  word  orignet;
  word  destnet;
  word  destzone;
  word  origzone;
  word  destpoint;
  word  origpoint;
  word  replyto;          /* not used */
  word  attribute;
  word  nextreply;        /* not used */
};

struct pktmessage {
  word version, orignode, destnode, orignet, destnet, attribute, cost;
  /* byte datetime[20]; */ /* OPUS does it wrong! */
  /* char to[], from[], subject[], text[]; */
};

#define fido_attr_private       0x00000001L
#define fido_attr_crash         0x00000002L
#define fido_attr_sent          0x00000008L
#define fido_attr_file          0x00000010L
#define fido_attr_kill          0x00000080L
#define fido_attr_local         0x00000100L
#define fido_attr_hold          0x00000200L
#define fido_attr_freq          0x00000800L
#define fido_attr_delete        0x00010000L
#define fido_attr_trunc         0x00020000L
#define fido_attr_direct        0x00040000L
#define fido_attr_lock          0x00080000L
#define fido_attr_immediate     0x00100000L

struct packetheader2 {
  word orignode, destnode, year, month, day, hour, minute, second, baud,
       version, orignet, destnet;
  byte prodcode, serial, password[8];
  word origzone, destzone;
  byte empty[20];
};

struct packetheader2p {
  word orignode, destnode, year, month, day, hour, minute, second, baud,
       version, orignet, destnet;
  byte prodcodel, revisionh, password[8];
  word origzoneq, destzoneq, auxnet, cwcopy;
  byte prodcodeh, revisionl;
  word cw, origzone, destzone, origpoint, destpoint;
  long psd;
};

struct packetheader22 {
  word orignode, destnode, origpoint, destpoint;
  long res1, res2;
  word subversio, version, orignet, destnet;
  byte prodcode, revision, password[8];
  word origzone, destzone;
  byte origdomain[8], destdomain[8];
  long psd;
};

