unit bbbsdef;

{==============================================================================

  This unit is Copyright 1992, Kim Heino.

  Definitions and variables for BBBS, version number is below.
  You may use this file as long as this is totally unmodified.
  I take no responsibility over any program using this file.
  Also included to original packet: BBBSPACK.TPU

==============================================================================}

{$f+,o-,v-}

interface

const ver : string[4] = '0.28';       { version }
      maxnodes = 9;                   { max node numbers }
      max_msg = 3200;                 { max unread messages per area }
      buffer_len = 320;               { com incoming buffer length }
      buffer_open = 64;
      buffer_close = 32;
      macro_len = 30;                 { macro length }
      txtsize = 414;                  { bbbstxt lines }
      max_macro = 5;                  { macros }
      commands_saved = 10;            { inputs saved }
      lines_in_editor = 600;          { max lines in editor }
      max_script_val = 9;             { max script variables }
      max_lread = 127;
      downloads_remembered = 512;
      hexs : string[16] = '0123456789ABCDEF';

type accesst = set of (readmsg, writemsg, download, upload, sigop, aempty1, aempty2, aempty3);
     statust = set of (must, member, invite, fidoarea, postarea, resume, fileinfo, noreply);
     mstatust = set of (killed, moved, private, sent, readed, mempty1, mempty2, mempty3);
     chars = (char_IBM, char_SF7, char_ISO, char_IBN, char_US7, char_GE7,
              char_NO7, char_FR7, char_IT7, char_SP7);

     timet = record
       date : record
         year, month, day : byte;
       end;
       time : record
         hour, minute, second : byte;
       end;
     end;

     userrec = record
       uempty1    : array[1..20] of byte;
       pmsgleft   : word;
       pfileup    : word;
       pfiledown  : word;
       pcalled    : word;
       timebank   : byte;
       todayused  : integer;
       name       : string[30];
       pass       : string[8];
       address    : string[30];
       city       : string[30];
       phone      : string[16];
       birth      : string[16];
       ok2login   : byte;       { 0 = yes, 1 = get lost, 2 = killed }
       lasttime   : timet;
       timelimit  : integer;
       timeson    : word;
       uploaded   : word;
       downloaded : word;
       msgleft    : word;
       msgread    : word;
       sysop      : byte;       { Bit 0=DOS,1=Confs,2=Files,3=Priv,4=Pass }
       charset    : chars;
       pagelength : byte;
       ansi       : boolean;    {*}
       fse        : boolean;    {*}
       expert     : byte;
       protocol   : byte;       { 0=Z, 1=Y, 2=X, 3=Bi, 4=XCRC, 5=YB, 6=HSL }
       fcheckedy  : byte;
       fcheckedm  : byte;
       fcheckedd  : byte;
       packtype   : byte;       { 0=text, 1=arc, 2=zip, 3=lzh, 4=arj, 5=zoo }
       bytesup    : longint;
       bytesdown  : longint;
       g_r        : boolean;    {*}
       msgdumped  : word;
       ansimenu   : boolean;    {*}
       colors     : boolean;    {*}
       review     : boolean;    {*}
       faccess    : byte;       { 0=up and down, 1=up, 2=down, 3=nothing }
       resume     : word;
       limits     : byte;
       language   : byte;       { 0..9 (0=English, 1=Suomi) }
       mistakes   : byte;
       toggles1   : byte;       { Bit 7=XYdisp,6=Lines,5=ConfS,4=Avatar,3=not(Flash) }
       readmode   : byte;       { 0=Marked,1=Reference,2=Forward }
     end;

     msgrec = record
       number     : word;
       status     : mstatust;
       msgfrom    : string[30];
       msgfromn   : word;
       msgto      : string[30];
       msgton     : word;
       subject    : string[40];
       dated      : timet;
       replyto    : word;
       nextreply  : word;
       firstreply : word;
       offset     : longint;
       lines      : word;
       zonefrom   : byte;
       netfrom    : word;
       nodefrom   : word;
       msgid      : longint;
       mempty     : array[1..3] of byte;
     end;

     msgusrrec = record
       lastread   : word;
       access     : accesst;
       status     : statust;
     end;

     filrec = record
       name       : string[12];
       dir        : string[60];
       desc       : string[40];
       dated      : timet;
       fsize      : longint;
       uploader   : word;
       downloaded : word;
       dirnum     : word;
       status     : byte;       { byte and $7F: 0=normal,1=del,2=p_user,3=free,4=p_conf (bit 7=reserved (repacked)) }
       finfo      : word;
       fileto     : word;
       fempty     : array[1..13] of byte;
     end;

     hihhi = record
       unused1    : word;       { times }
       unused2    : word;       { day# }
       name       : string[30];
       msg        : string[79];
     end;

     cfgrec = record
       versi : string[4];
       bbbsname : string[30];
       sysop : string[30];
       maxactiveconf : word;
       bell : boolean;
       rts_cts : boolean;
       fdbbs, bipath, dszpath : string[70];
       grab : string[12];
       packers,
       maindir,
       grabdir,
       holddir,
       updir,
       menudir,
       logfile,
       hippodir : string[70];
       zone, net, node, point : array[1..maxnodes] of word;
       postconf, resumeconf, fileinfoconf : word;
       newusertime : integer;
       newuserfaccess : byte;
       irq : array[0..5] of byte;
       upstatus : byte;
       allowext : byte; { Bit+1 8=HS,7=ARC,6=ZIP,5=ZOO,4=ARJ,3=LHA,2=DSZ,1=BI }
       maxnodes, nodenumber : word;
       startspeed : word;
       resetspeed, hangup : boolean;
       initstring : string[40];
       loginlog : string[70];
       eventcount : byte;
       eventh, eventm, evente : array[1..9] of byte;
       pass : string[8];
       updowncheck : boolean;
       showprivate : boolean;
       chatdir : string[70];
       buildin : byte; { Bit+1 5=5_3,4=5_2,3=5_1,2=Hippo,1=Robo }
       baseaddr : array[0..4] of word;
       set16550 : array[0..4] of boolean;
       hspath : string[70];
       allfiles : string[12];
       commercial : string[70];
       macros : array[1..10] of string[40];
       limits : array[0..15,1..2] of byte;
       rush : array[0..23] of byte;
       min_speed : word;
       local_keys : boolean;
       show_empty_nodes : boolean;
       newdir : string[70];
       bankmax : byte;
       bankrate : byte;
     end;

     noderec = record
       status : byte; { 0=off,1=active,2=not,3=writing,4=grab,5=down,6=up,7=chat,8=door,9=groupchat }
       speed  : word;
       mnp    : boolean;
       name   : string[44];
     end;

     chatrec = record
       node : byte;
       msg  : string[79];
     end;

     statrec = record
       day    : byte; { 0=sunday, 1=monday, etc... }
       min1   : word; { user online minutes }
       min2   : word; { sysop online minutes }
       call1  : word; { user calls }
       call2  : word; { sysop calls }
       msg1   : word; { user msgs entered }
       msg2   : word; { sysop msgs entered }
     end;

var buffer : array[0..buffer_len] of char;
    chartable : array[1..2, 0..255] of char;
    msgreaded : array[1..max_msg] of word;
    txt : array[1..txtsize] of ^string;
    macros : array[1..max_macro, 1..2] of string[macro_len];
    commands : array[1..commands_saved] of string[72];
    lread : array[0..max_lread] of msgusrrec;
    inval : array[1..max_script_val] of string[70];
    u : userrec;
    cfg : cfgrec;
    ustatus, confparam : msgusrrec;
    node : noderec;
    confname : string[20];
    logfile, script, grabfile : text;
    local_buffer, comstring : string;
    unum : longint;
    old_guru : pointer;
    confnro, baud, realbaud, loginhour, loginmin, lastmsg, curmsg, firstmsg,
    lastreaded, foryou, newavail, reserved2, reserved3, reserved4, startleft,
    startdump, startread : word;
    lastwarn, temptime : integer;
    jobtype, com, reserved1, errl, tempsys, commands_in_memory, pagecounter : byte;
    lastinchar : char;
    realmnp, carrier, outputstopped, files_checked, desqview, quicklogin,
    paged, script_running : boolean;
    filna : string[12];

implementation

{begin}
end.

===============================================================================

unit bbbspack;

{$f+,o-,v-}

interface

function  pack(s : string) : string;
function  unpack(s : string) : string;
procedure clrstr(var s : string);
function  whatcpu : byte;

var _32_bit_processor : boolean;

implementation

===============================================================================

