/******************************************************************************

  This unit is Copyright 1992, Kim Heino and Tapani T. Salmi.

  Definitions and variables for BBBS, version number is below.
  You may use this file as long as this is totally unmodified.
  We take no responsibility over any program using this file.

******************************************************************************/

#ifdef __GNUC__
typedef char                  boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
#endif
#ifdef __MSDOS__
typedef char                  boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
#endif
#ifdef LATTICE
typedef char                  boolean;    /*  8 bit, true or false */
typedef unsigned char         byte;       /*  8 bit, unsigned */
typedef signed short int      integer;    /* 16 bit, signed */
typedef unsigned short int    word;       /* 16 bit, unsigned */
typedef signed long int       longint;    /* 32 bit, signed */
#endif

#define true                  1
#define false                 0

#define rupted                1

#define maxnodes              9           /* max node numbers */
#define max_msg               4096        /* max unread messages per area */
#define buffer_len            256         /* com incoming buffer length */
#define buffer_open           190
#define buffer_close          220
#define buffer_out_len        256         /* com outgoing buffer length */
#define macro_len             30          /* macro length */
#define txtsize               552         /* bbbstxt lines */
#define max_macro             5           /* macros */
#define commands_saved        10          /* inputs saved */
#define lines_in_editor       2000        /* max lines in editor */
#define max_lread             127         /* lread cache size (0 to xxx) */
#define downloads_remembered  1024        /* whodown file size */
#define max_script_val        9           /* max script variables */

#define acc_readmsg     1                 /* accesst bits */
#define acc_writemsg    2
#define acc_download    4
#define acc_upload      8
#define acc_sigop       16
#define acc_aempty1     32
#define acc_aempty2     64
#define acc_aempty3     128

#define stat_must       1                 /* status bits */
#define stat_member     2
#define stat_invite     4
#define stat_fidoarea   8
#define stat_postarea   16
#define stat_sempty1    32
#define stat_sempty2    64
#define stat_noreply    128

#define mstat_killed    1                 /* mstatust bits */
#define mstat_moved     2
#define mstat_private   4
#define mstat_sent      8
#define mstat_readed    16
#define mstat_mempty1   32
#define mstat_mempty2   64
#define mstat_mempty3   128

#define char_IBM        0                 /* charsets */
#define char_SF7        1
#define char_ISO        2
#define char_IBN        3
#define char_US7        4
#define char_GE7        5
#define char_NO7        6
#define char_FR7        7
#define char_IT7        8
#define char_SP7        9
#define char_MAC        10

#define sysop_dos       1                 /* sysop access bits */
#define sysop_confs     2
#define sysop_files     4
#define sysop_priv      8
#define sysop_pass      16

struct dat {
  byte year, month, day;
};
struct tim {
  byte hour, minute, second;
};

struct timet {
  struct dat date;
  struct tim time;
};

struct userrec {
  byte            uempty1[20];
  word            pmsgleft;
  word            pfileup;
  word            pfiledown;
  word            pcalled;
  byte            timebank;
  integer         todayused;
  char            name[31];
  char            pass[9];
  char            address[31];
  char            city[31];
  char            phone[17];
  char            birth[17];
  byte            ok2login;     /* 0 = yes, 1 = get lost, 2 = killed */
  struct timet    lasttime;
  integer         timelimit;
  word            timeson;
  word            uploaded;
  word            downloaded;
  word            msgleft;
  word            msgread;
  byte            sysop;        /* Bit 0=DOS,1=Confs,2=Files,3=Priv,4=Pass */
  byte            charset;
  byte            pagelength;
  byte            ansi;         /* Bit 0=ANSI */
  byte            fse;          /* Bit 0=FSE */
  byte            expert;
  byte            protocol;     /* 0=Z, 1=Y, 2=X, 3=Bi, 4=XCRC, 5=YB, 6=HSL */
  byte            fcheckedy;
  byte            fcheckedm;
  byte            fcheckedd;
  byte            packtype;     /* 0=text, 1=arc, 2=zip, 3=lzh, 4=arj, 5=zoo */
  longint         bytesup;
  longint         bytesdown;
  byte            g_r;          /* Bit 0=G&R */
  word            msgdumped;
  byte            ansimenu;     /* Bit 0=ANSImenu */
  byte            colors;       /* Bit 0=Colors */
  byte            review;       /* Bit 0=Review */
  byte            faccess;      /* 0=up and down, 1=up, 2=down, 3=nothing */
  word            resume;
  byte            limits;
  byte            language;     /* 0..9 (0=English, 1=Suomi, 2=Svenska) */
  byte            mistakes;
  byte            toggles1;     /* Bit 7=XYdisp,6=Lines,5=ConfS,4=Avatar,3=!Flash,2=Hotkeys,1=Indent,0=!Insert */
  byte            readmode;     /* 0=Marked,1=Reference,2=Forward */
};

struct msgrec {
  word            number;
  byte            status;
  char            msgfrom[31];
  word            msgfromn;
  char            msgto[31];
  word            msgton;
  char            subject[41];
  struct timet    dated;
  word            replyto;
  word            nextreply;
  word            firstreply;
  longint         offset;
  word            lines;
  byte            zonefrom;
  word            netfrom;
  word            nodefrom;
  longint         msgid;
  byte            mempty[3];
};

struct msgusrrec {
  word            lastread;
  byte            access;
  byte            status;
};

struct filrec {
  char            name[13];
  char            dir[61];
  char            desc[41];
  struct timet    dated;
  longint         fsize;
  word            uploader;
  word            downloaded;
  word            dirnum;
  byte            status;       /* byte and $7F: 0=normal,1=del,2=p_user,3=free,4=p_conf (bit 7=reserved (repacked)) */
  word            finfo;
  word            fileto;
  byte            fempty[13];
};

struct hihhi {
  word            times;
  word            unused2;  /* day# */
  char            name[31];
  char            msg[80];
};

struct cfgrec {
  char            versi[5];
  char            bbbsname[31];
  char            sysop[31];
  word            maxactiveconf;
  boolean         bell;
  boolean         rts_cts;
  char            fdbbs[71],
                  bipath[71],
                  dszpath[71];
  char            grab[13];
  char            packers[71],
                  maindir[71],
                  grabdir[71],
                  holddir[71],
                  updir[71],
                  menudir[71],
                  logfile[71],
                  hippodir[71];
  word            zone[maxnodes], net[maxnodes], node[maxnodes], point[maxnodes];
  word            postconf, resumeconf, fileinfoconf;
  integer         newusertime;
  byte            newuserfaccess;
  byte            irq[5];
  byte            pollrate;
  byte            upstatus;
  byte            allowext; /* Bit 7=HS,6=ARC,5=ZIP,4=ZOO,3=ARJ,2=LHA,1=DSZ,0=BI */
  word            maxactivenodes, nodenumber;
  word            startspeed;
  boolean         resetspeed, hangup;
  char            initstring[41];
  char            loginlog[71];
  byte            eventcount;
  byte            eventh[9], eventm[9], evente[9];
  char            pass[9];
  boolean         updowncheck;
  boolean         showprivate;
  char            chatdir[71];
  byte            buildin; /* Bit 5=Blitz,4=5_3,3=5_2,2=5_1,1=Hippo,0=BRoboCop */
  word            baseaddr[5];
  boolean         set16550[5];
  char            hspath[71];
  char            allfiles[13];
  char            commercial[71];
  char            macros[10][41];
  byte            limits[16][2];
  byte            rush[24];
  word            min_speed;
  boolean         local_keys;
  boolean         show_empty_nodes;
  char            newdir[71];
  byte            bankmax;
  byte            bankrate;
};

struct noderec {
  byte            status;  /* 0=off,1=active,2=not,3=writing,4=grab,5=down,6=up,7=chat,8=door,9=groupchat */
  word            speed;
  boolean         mnp;
  char            name[45];
};

struct chatrec {
  byte            node;
  char            msg[80];
};

struct statrec {
  byte            day;    /* 0=sunday, 1=monday, etc... */
  word            min1;   /* user online minutes */
  word            min2;   /* sysop online minutes */
  word            call1;  /* user calls */
  word            call2;  /* sysop calls */
  word            msg1;   /* user msgs entered */
  word            msg2;   /* sysop msgs entered */
};

extern  char              ver[6];         /* "0.29"; Version number  */
extern  char              hexs[17];       /* "0123456789ABCDEF";      */
extern  char              *vername;       /* "BBBS/D", "BBBS/2", etc. */

extern  struct msgusrrec  lread[max_lread+1], ustatus, confparam;
extern  struct userrec    u;
extern  struct cfgrec     cfg;
extern  struct noderec    node;
extern  FILE              *logfile, *script, *grabfile;
extern  char              bzbuf[512], buffer[buffer_len+1], outbuffer[buffer_out_len+1], *txt[txtsize+1], *txt_start, macros[max_macro][2][macro_len+1], commands[commands_saved][80], filna[13], confname[50], local_buffer[256], comstring[512], temp_string[256], inval[max_script_val+1][80];
extern  word              unum, confnro, baud, realbaud, loginhour, loginmin, lastmsg, curmsg, firstmsg,lastreaded, foryou, newavail, reserved2, reserved3, reserved4, startleft, startdump, startread, msgreaded[max_msg+1];
extern  integer           lastwarn, temptime;
extern  byte              bzlink, chartable[2][256], jobtype, com, reserved1, errl, tempsys, commands_in_memory, pagecounter, lastinchar, spymode, brobot;
extern  boolean           realmnp, carrier, outputstopped, files_checked, desqview, quicklogin, paged, script_running, hotkeys;

