;****************************************************************************;
;                                                                            ;
; Typical parameter control file for AA4RE BBS                               ;
;                                                                            ;
; Note that the values I supply in this file are probably NOT what you want  ;
; Many are left over from testing.  Please go thru it carefully and compare  ;
; each setting with the description in PARMS.BB to see what you want or need ;
; for your particular situation.                                             ;
;                                                                            ;
; A few minutes of spent checking your file will eliminate many many         ;
; problems later on.                                                         ;
;                                                                            ;
;      Roy                                                                   ;
;                                                                            ;
;****************************************************************************;

*---------------------------------------------------------------------*
* General Board Defines                                               *
*---------------------------------------------------------------------*

  name                  = Roy
  location              = Gilroy
  bb_sign               = AA4RE
  bb_addr               = AA4RE
  bb_hier_addr          = .#NOCAL.CA.USA.NA

*---------------------------------------------------------------------*
* Work directory for temporary files.  RAM Disk is ok.                *
*---------------------------------------------------------------------*

  temp_dir             = D:\

*---------------------------------------------------------------------*
* Dynamic File Defines                                                *
*---------------------------------------------------------------------*

  user_file             = USER.BB
  msg_file              = MSG.BB
  msg_dir               = H:msg\
  bid_file              = BID.BB
  log_file              = H:WEEKLY
  mon_file              = MON.BB
  trace_file            = TRACE.BB

*---------------------------------------------------------------------*
* Static File Defines                                                 *
*---------------------------------------------------------------------*

  message_list          = MESSAGE.BB
  route_file            = ROUTE.BB
  path_file             = PATH.BB
  help_file             = HELP.BB
  dos_message_file      = MESSAGE.DOS
  wakeup_file           = WAKEUP.BB
  h_lookup_file         = HLOOKUP.BB
  action_file           = ACTION.BB
  password_file         = PASSWORD.BB

*---------------------------------------------------------------------*
* MSG Defines                                                         *
*---------------------------------------------------------------------*

  blank_to_p            = N
  allow_types           = BPT
  blank_to_bbs          = Y
  auto_set_to_bbs       = Y

*---------------------------------------------------------------------*
* Message clean up                                                    *
*---------------------------------------------------------------------*

  rename_killed_msg     = N

*---------------------------------------------------------------------*
* Forwarding Defines                                                  *
*---------------------------------------------------------------------*

  no_fwd_kill           = B_
  hold_duplicate        = Y
  hold_dup_header       = 5
  kill_userbbs_on_error = Y
  forward_delay         = 10
  bbs_to_fwd_time       = 420
  already_connect_check = Y
  auto_hlookup          = N

*---------------------------------------------------------------------*
* BID Defines                                                         *
*---------------------------------------------------------------------*

  bid_for_P             = Y
  bid_for_T             = Y
  bid_for_blank         = Y
  bid_max               = 1200

*---------------------------------------------------------------------*
* Screen defines                                                      *
*---------------------------------------------------------------------*

  operator_color        = 5
  status_color          = 82
  monitor_time_stamp    = Y
  direct_video          = Y
  check_snow            = N
  time_updates_status   = Y
  connect_scroll_size   = 70
  monitor_scroll_size   = 70
  operator_scroll_size  = 80
  top_window_%          = 50
  suppress_prefix       = N

*---------------------------------------------------------------------*
* System defines                                                      *
*---------------------------------------------------------------------*

  trace                 = Y
  max_task              = 1
  show_yapp_states      = N
  show_binary_data      = N
  mono_trace            = N

*---------------------------------------------------------------------*
* Sysop controls                                                      *
*---------------------------------------------------------------------*

  sysop_is_in           = N
  sysop_bell            = N
  loud_sysop_bell       = Y

*---------------------------------------------------------------------*
* Register controls                                                   *
*---------------------------------------------------------------------*

  send_wp_to_bbs        = WD6CMU.#NOCAL.CA.USA.NA
  home_bbs_expires      = 120

*---------------------------------------------------------------------*
* Mail beacons                                                        *
*---------------------------------------------------------------------*

  broadcast_interval    = 5
  own_call_in_bcst      = N

*---------------------------------------------------------------------*
* Privileges                                                          *
*---------------------------------------------------------------------*

  bbs_see_p             = N

*---------------------------------------------------------------------*
* Emergency mode control                                              *
*---------------------------------------------------------------------*

  emergency_types = STUVWXYZ

*---------------------------------------------------------------------*
* Miscellaneous                                                       *
*---------------------------------------------------------------------*

  new_user_l_time       = 2
  mon_list_length       = 5

; NO_FULLSCREEN_REVIEW -- Used to bypass the local review processor.  Should
; normally be "N"
  no_fullscreen_review  = N

; WAKEUP_INTERVAL -- Controls minimum time between wakeups
;
  wakeup_interval       = 5

; MAX_L_MESSAGES -- How many messages to show for "L" command
;
  max_l_messages        = 25

*---------------------------------------------------------------------*
* PORT A Defines                                                      *
*---------------------------------------------------------------------*

  port

  ; ***** During testing, I use several different port types.  I am leaving
  ;       in all the different lines I use so you can see what they look like.
  ;       Lines starting with a semicolon are comments so only one port is
  ;       really defined for my test setup.

  ; The following setup is for a telephone modem type of attach
  ; port_type       = MODEM-ATCMD
  ; com             = 1
  ; max_connect     = 1
  ; max_channel     = 2

  ; These parameters are for modem ports ONLY!!!!

  ; ANSWER_ON_RING -- Sets the number of rings the BBS will wait for before
  ;     answering the phone.  Note that the BBS does not set S0 to this count.
  ;     Instead each ring is counted by the program itself which will then
  ;     tell the modem to answer.  This is to prevent a dead BBS from answering
  ;     the phone and causing someone to pay long distance charges.
  ; answer_on_ring  = 1

  ; The following setup is for a G8BPQ node (V4.03) type of attach
    port_type       = G8BPQ-HOST-1
    com             = 127
    max_connect     = 5
    max_channel     = 6

    max_pac         = 230
    speed           = 9600
    max_pending     = 1
    monitor         = yes
    time_out        = 180
    fwd_min         = 0
    minimum_class_allowed = new_user
    remote_sysop    = Y
    upload_download = Y
    broadcast       = n
    port_name       = Telephone
    monitor_color   = 121
    no_out_fwd      = Y

    disconnect_delay      = 10
    default_forward_order = TA

  ; LOCK_MODEM_SPEED -- Used when you have a modem that doesn't need
  ;     a speed change between the computer and the modem when the
  ;     input speed changes;
;   lock_modem_speed = y

  ; INITIALIZE_FILE -- A file downloaded into the TNC/modem to set any
  ;     parameters you want.  Normally not needed.
  ;     Here I am using the following file to set any modem parms that
  ;     I want different from the program's normal setting.
    initialize_file = MODEM.INI

  ; ACCESS_CONTROL -- Sets the minimum authentication needed for access.
    access_control  = S

  ; NEW_USER_DISPLAY_FORMAT -- Sets the display format for a new user from
  ;     this port
    new_user_display_format = 0


    remove_ssid_addresses = y

endport

*=====================================================================*
* File defines                                                        *
*=====================================================================*

*---------------------------------------------------------------------*
* Allow local sysop access to whole system                            *
*---------------------------------------------------------------------*

  file_directory
    directory_name     = SYSTEM
    directory_alias    = SYS
    directory_desc     = SYSTEM
    directory_path     = ANY
    class_for_upload   = local_sysop
    class_for_download = local_sysop
    subdirectory_ok    = YES
    binary_ok          = YES
  endfile

*---------------------------------------------------------------------*
* Test area                                                           *
*---------------------------------------------------------------------*

  file_directory
    directory_name     = TEST
    directory_alias    = NONE
    directory_desc     = TEST
    directory_path     = ANY
    class_for_upload   = remote_sysop
    class_for_download = remote_sysop
    subdirectory_ok    = YES
    binary_ok          = YES
  endfile
