' LZWTEST.BAS - Test Lempel-Ziv-Welch compression/de-compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

' Compile Instructions: BC /O LZWTEST;
'                       BC /O LZWC;
'                       BC /O LZWD;
'                       LINK /E LZWTEST LZWC LZWD,,NUL,PRO;
'                    or LINK /NOD/E LZWTEST LZWC LZWD,,NUL,PRO BASIC7 PDQ;

DEFINT A-Z

' $INCLUDE: 'LZWDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)

DIM LZW AS LZWType

Source$ = "LZWDECL.BAS"
Mask$ = ",########"
BitsVal = 12

CmdPrm$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))

BPos = INSTR(CmdPrm$, "/1")
IF BPos THEN
  BitsVal = VAL(MID$(CmdPrm$, BPos + 1, 2))
  CmdPrm$ = RTRIM$(RTRIM$(LEFT$(CmdPrm$, BPos - 1)) + _
                   LTRIM$(MID$(CmdPrm$ + " ", BPos + 3)))
END IF

IF Exist(CmdPrm$) THEN
  Source$ = CmdPrm$
END IF

Dest$ = LEFT$(Source$, INSTR(Source$ + ".", "."))
Out$ = Dest$ + "OUT"
Dest$ = Dest$ + "LZW"

PRINT
PRINT "LZWTEST - Test LZW Compression/De-compression"
PRINT
PRINT " Reading File: '"; Source$; "'"
PRINT "Creating File: '"; Dest$; "'"
PRINT
PRINT "   Bytes read: "
PRINT "Bytes written: ";
LZW.Bits = BitsVal
LZW.OutLin = CSRLIN
LZW.OutCol = POS(0)
LZW.InLin = LZW.OutLin - 1
LZW.InCol = LZW.OutCol

LZWCompress Source$, Dest$, Mask$, LZW

IF LZW.Stat THEN
  PRINT : PRINT
  PRINT "Error code: "; LTRIM$(STR$(LZW.Stat))
  BEEP
  END
END IF

IF LZW.BytesIn = 0 THEN
  CmpPct = 0
ELSE
  CmpPct = (LZW.BytesIn - LZW.BytesOut) * 100 \ LZW.BytesIn
END IF
PRINT " - "; LTRIM$(STR$(CmpPct)); "% compression achieved."

PRINT
PRINT " Reading File: '"; Dest$; "'"
PRINT "Creating File: '"; Out$; "'"
PRINT
PRINT "   Bytes read: "
PRINT "Bytes written: ";
LZW.OutLin = CSRLIN
LZW.OutCol = POS(0)
LZW.InLin = LZW.OutLin - 1
LZW.InCol = LZW.OutCol

LZWDeCompress Dest$, Out$, Mask$, LZW

PRINT : PRINT

PRINT "Test complete."

BEEP
END

