' LZWD.BAS - Lempel-Ziv-Welch data de-compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

DEFINT A-Z

COMMON SHARED Bits, HashingShift, MaxValue, MaxCode, TableSize, OptBuf
COMMON SHARED BytesIn&, BytesOut&, FileSize&, CodeValue(), PrefixCode()
COMMON SHARED AppendChar(), InBytes(), OutBytes(), DecodeStack()

' $INCLUDE: 'LZWDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)
DECLARE FUNCTION FUsing$ (Num$, Image$)
DECLARE FUNCTION DecodeString (Code, Start)
DECLARE FUNCTION InputCode (InCh)
DECLARE FUNCTION DGetChar (InCh)

DECLARE SUB DiskInfo (Drv$, Bytes, Sectors, FreeClust, TotClust)
DECLARE SUB FGetA (Handle, SEG Address, NumBytes)
DECLARE SUB FPutA (Handle, SEG Address, NumBytes)
DECLARE SUB ShiftIL (IntVar, NumBits)
DECLARE SUB ShiftIR (IntVar, NumBits)
DECLARE SUB ShiftLL (Longvar&, NumBits)
DECLARE SUB ShiftLR (Longvar&, NumBits)

FUNCTION DecodeString (Code, Start) STATIC

  StackPtr = Start
  DCode = Code
  WHILE DCode > 255
    DecodeStack(StackPtr) = AppendChar(DCode)
    StackPtr = StackPtr + 1
    DCode = PrefixCode(DCode)
  WEND
  DecodeStack(StackPtr) = DCode
  DecodeString = StackPtr

END FUNCTION

FUNCTION DGetChar (InCh) STATIC

  IF BytesIn& = FileSize& THEN
    DGetChar = -1
  ELSE
    IF CPos = 0 OR CPos = OptBuf THEN
      FGetA FILEATTR(InCh, 2), SEG InBytes(0), OptBuf
      CPos = 0
    END IF
    CPos = CPos + 1
    C = InBytes((CPos - 1) \ 2)
    IF (CPos MOD 2) THEN
      C = C AND 255
    ELSE
      ShiftIR C, 8
    END IF
    BytesIn& = BytesIn& + 1
    DGetChar = C
  END IF

END FUNCTION

FUNCTION InputCode (InCh) STATIC

  WHILE InputBitCount <= 24
    LCode& = CLNG(DGetChar(InCh))
    ShiftLL LCode&, 24 - InputBitCount
    InputBitBuffer& = InputBitBuffer& OR LCode&
    InputBitCount = InputBitCount + 8
  WEND
  ReturnValue& = InputBitBuffer&
  ShiftLR ReturnValue&, 32 - Bits
  ShiftLL InputBitBuffer&, Bits
  InputBitCount = InputBitCount - Bits
  InputCode = CINT(ReturnValue&)

END FUNCTION

SUB LZWDeCompress (Source$, Dest$, Mask$, LZW AS LZWType) STATIC

  LZW.Stat = 0
  LZW.BytesIn = 0
  LZW.BytesOut = 0

  IF NOT Exist(Source$) THEN
    LZW.Stat = 1
    EXIT SUB
  END IF

  Bits = LZW.Bits
  IF Bits < 12 OR Bits > 14 THEN
    Bits = 12
  END IF
  HashingShift = Bits - 8
  MaxValue = 1
  ShiftIL MaxValue, Bits
  MaxValue = MaxValue - 1
  MaxCode = MaxValue - 1

  IF Bits = 14 THEN
    TableSize = 18041
  ELSEIF Bits = 13 THEN
    TableSize = 9029
  ELSE
    TableSize = 5021
  END IF

  REDIM CodeValue(TableSize), PrefixCode(TableSize), AppendChar(TableSize), DecodeStack(4095)

  InCh = FREEFILE
  OPEN Source$ FOR BINARY AS InCh

  Drv$ = ""
  IF LEN(Source$) > 1 THEN
    IF MID$(Source$, 2, 1) = ":" THEN
      Drv$ = LEFT$(Source$, 1)
    END IF
  END IF

  DiskInfo Drv$, Bytes, Sectors, FreeClust, TotClust
  OptBuf = Bytes * Sectors
  FileSize& = LOF(InCh)

  REDIM InBytes((OptBuf \ 2) - 1), OutBytes((OptBuf \ 2) - 1)

  IF Exist(Dest$) THEN
    KILL Dest$
  END IF

  OutCh = FREEFILE
  OPEN Dest$ FOR BINARY AS OutCh

  NextCode = 256

  OldCode = InputCode(InCh)
  Character = OldCode
  OutBytes(0) = OldCode
  OutPtr = 1
  BytesIn& = 0
  BytesOut& = 1

  DO
    NewCode = InputCode(InCh)
    IF NewCode <> MaxValue THEN
      IF LZW.InLin THEN
        IF (BytesIn& MOD OptBuf) = 0 THEN
          LOCATE LZW.InLin, LZW.InCol
          PRINT FUsing$(" " + STR$(BytesIn&), Mask$);
        END IF
      END IF
      IF NewCode >= NextCode THEN
        DecodeStack(0) = Character
        StackPtr = DecodeString(OldCode, 1)
      ELSE
        StackPtr = DecodeString(NewCode, 0)
      END IF
      Character = DecodeStack(StackPtr)
      FOR cnt = StackPtr TO 0 STEP -1
        OutChar = DecodeStack(cnt)
        sb = OutPtr \ 2
        IF (OutPtr MOD 2) THEN
          ShiftIL OutChar, 8
          OutBytes(sb) = OutBytes(sb) OR OutChar
        ELSE
          OutBytes(sb) = OutChar
        END IF
        OutPtr = OutPtr + 1
        BytesOut& = BytesOut& + 1
        IF OutPtr = OptBuf THEN
          FPutA FILEATTR(OutCh, 2), SEG OutBytes(0), OptBuf
          OutPtr = 0
          IF LZW.OutLin THEN
            LOCATE LZW.OutLin, LZW.OutCol
            PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
          END IF
        END IF
      NEXT cnt
      IF NextCode <= MaxCode THEN
        PrefixCode(NextCode) = OldCode
        AppendChar(NextCode) = Character
        NextCode = NextCode + 1
      END IF
      OldCode = NewCode
    END IF
  LOOP UNTIL NewCode = MaxValue
  IF OutPtr > 0 THEN
    FPutA FILEATTR(OutCh, 2), SEG OutBytes(0), OutPtr
  END IF
  IF LZW.InLin THEN
    LOCATE LZW.InLin, LZW.InCol
    PRINT FUsing$(" " + STR$(BytesIn&), Mask$);
  END IF
  IF LZW.OutLin THEN
    LOCATE LZW.OutLin, LZW.OutCol
    PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
  END IF

  CLOSE InCh, OutCh

  LZW.BytesIn = BytesIn&
  LZW.BytesOut = BytesOut&

END SUB

