' HUFFTEST.BAS - Test Huffman compression/de-compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

' Compile Instructions: BC /O HUFFTEST;
'                       BC /O HUFFC;
'                       BC /O HUFFD;
'                       LINK /E HUFFTEST HUFFC HUFFD,,NUL,PRO;
'                    or LINK /NOD/E HUFFTEST HUFFC HUFFD,,NUL,PRO BASIC7 PDQ;

DEFINT A-Z

' $INCLUDE: 'HUFFDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)

DIM Huff AS HuffType

Source$ = "HUFFDECL.BAS"
Mask$ = ",########"

CmdPrm$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
IF Exist(CmdPrm$) THEN
  Source$ = CmdPrm$
END IF

Dest$ = LEFT$(Source$, INSTR(Source$ + ".", "."))
Out$ = Dest$ + "OUT"
Dest$ = Dest$ + "HUF"

PRINT
PRINT "HUFFTEST - Test Huffman Compression/De-compression"
PRINT
PRINT " Reading File: '"; Source$; "'"
PRINT "Creating File: '"; Dest$; "'"
PRINT
PRINT "   Bytes read:"
PRINT "Bytes written: ";
Huff.OutLin = CSRLIN
Huff.OutCol = POS(0)
Huff.InLin = Huff.OutLin - 1
Huff.InCol = Huff.OutCol
Huff.AnLin = Huff.OutLin - 1
Huff.AnCol = Huff.OutCol

HuffCompress Source$, Dest$, Mask$, Huff

IF Huff.Stat THEN
  PRINT : PRINT
  PRINT "Error code: "; LTRIM$(STR$(Huff.Stat))
  BEEP
  END
END IF

IF Huff.BytesIn = 0 THEN
  CmpPct = 0
ELSE
  CmpPct = (Huff.BytesIn - Huff.BytesOut) * 100 \ Huff.BytesIn
END IF
PRINT " - "; LTRIM$(STR$(CmpPct)); "% compression achieved."

PRINT
PRINT " Reading File: '"; Dest$; "'"
PRINT "Creating File: '"; Out$; "'"
PRINT
PRINT "   Bytes read:"
PRINT "Bytes written: ";
Huff.OutLin = CSRLIN
Huff.OutCol = POS(0)
Huff.InLin = Huff.OutLin - 1
Huff.InCol = Huff.OutCol

HuffDeCompress Dest$, Out$, Mask$, Huff

PRINT : PRINT

PRINT "Test complete."

BEEP
END

