' HUFFC.BAS - Huffman data compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

DEFINT A-Z

TYPE HTree
  Count  AS LONG
  Parent AS INTEGER
  Right  AS INTEGER
  Left   AS INTEGER
END TYPE

' $INCLUDE: 'HUFFDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)
DECLARE FUNCTION FUsing$ (Num$, Image$)

DECLARE SUB DiskInfo (Drv$, Bytes, Sectors, FreeClust, TotClust)
DECLARE SUB FGetA (Handle, SEG Address, NumBytes)
DECLARE SUB FPutA (Handle, SEG Address, NumBytes)
DECLARE SUB ShiftIL (Value, Places)
DECLARE SUB ShiftIR (Value, Places)

SUB HuffCompress (InFile$, OutFile$, Mask$, Huff AS HuffType) STATIC

  Huff.Stat = 0
  Huff.BytesIn = 0
  Huff.BytesOut = 0

  IF NOT Exist(InFile$) THEN
    Huff.Stat = 1
    EXIT SUB
  END IF

  REDIM HT(0 TO 511) AS HTree

  FOR i = 0 TO 511
    HT(i).Count = 0
    HT(i).Parent = -1
    HT(i).Right = -1
    HT(i).Left = -1
  NEXT i

  Drv$ = ""
  IF LEN(InFile$) > 1 THEN
    IF MID$(InFile$, 2, 1) = ":" THEN
      Drv$ = LEFT$(InFile$, 1)
    END IF
  END IF

  DiskInfo Drv$, Bytes, Sectors, FreeClust, TotClust
  OptBuf = Bytes * Sectors

  REDIM InBytes((OptBuf \ 2) - 1), OutBytes((OptBuf \ 2) - 1)

  InFile = FREEFILE
  OPEN InFile$ FOR BINARY AS InFile

  BytesRead& = 0
  FileLen& = LOF(InFile)
  BufSize = OptBuf
  TotRecs& = FileLen& \ BufSize
  LastBuf = (FileLen& MOD BufSize)

  FOR CurRec& = 1 TO TotRecs& + 1
    IF CurRec& = TotRecs& + 1 THEN
      BufSize = LastBuf
    END IF
    FGetA FILEATTR(InFile, 2), SEG InBytes(0), BufSize
    BytesRead& = BytesRead& + BufSize
    IF Huff.AnLin THEN
      LOCATE Huff.AnLin, Huff.AnCol
      PRINT FUsing$(" " + STR$(BytesRead&), Mask$);
    END IF
    FOR Count = 1 TO BufSize
      Sb = InBytes((Count - 1) \ 2)
      IF (Count MOD 2) THEN
        Sb = Sb AND 255
      ELSE
        Sb = Sb \ 256
      END IF
      HT(Sb).Count = HT(Sb).Count + 1
    NEXT Count
  NEXT CurRec&

  CLOSE InFile

  TreeCount = 256
  Null = -1
  DIM HRight AS HTree, HLeft AS HTree

  DO
    HRight.Count = Null
    HRight.Parent = Null
    HRight.Right = Null
    HRight.Left = Null
    HRPtr = Null
    HLeft.Count = Null
    HLeft.Parent = Null
    HLeft.Right = Null
    HLeft.Left = Null
    HLPtr = Null
    FOR i = 0 TO TreeCount - 1
      IF HT(i).Count > 0 AND HT(i).Parent = Null THEN
        IF HRight.Count = Null OR HT(i).Count < HRight.Count THEN
          IF HLeft.Count = Null OR HRight.Count < HLeft.Count THEN
            HLeft = HRight
            HLPtr = HRPtr
          END IF
          HRight = HT(i)
          HRPtr = i
        ELSEIF HLeft.Count = Null OR HT(i).Count < HLeft.Count THEN
          HLeft = HT(i)
          HLPtr = i
        END IF
      END IF
    NEXT i
    IF HLeft.Count <> Null THEN
      HT(HRPtr).Parent = TreeCount
      HT(HLPtr).Parent = TreeCount
      HT(TreeCount).Count = HRight.Count + HLeft.Count
      HT(TreeCount).Right = HRPtr
      HT(TreeCount).Left = HLPtr
      TreeCount = TreeCount + 1
    END IF
  LOOP UNTIL HLeft.Count = Null OR TreeCount > 511
  Root = HRPtr

  InFile = FREEFILE
  OPEN InFile$ FOR BINARY AS InFile

  FileLen& = LOF(InFile)
  BufSize = OptBuf
  TotRecs& = FileLen& \ BufSize
  LastBuf = (FileLen& MOD BufSize)

  IF Exist(OutFile$) THEN
    KILL OutFile$
  END IF

  OutFile = FREEFILE
  OPEN OutFile$ FOR BINARY AS OutFile

  HdrOut$ = MKL$(BytesRead&) + MKI$(Root)
  FOR Count = 256 TO Root
    HdrOut$ = HdrOut$ + MKI$(HT(Count).Right) + MKI$(HT(Count).Left)
  NEXT Count

  PUT OutFile, , HdrOut$
  BytesOut& = LEN(HdrOut$)
  BytesRead& = 0

  FOR CurRec& = 1 TO TotRecs& + 1
    IF CurRec& = TotRecs& + 1 THEN
      BufSize = LastBuf
    END IF
    FGetA FILEATTR(InFile, 2), SEG InBytes(0), BufSize
    BytesRead& = BytesRead& + BufSize
    IF Huff.InLin THEN
      LOCATE Huff.InLin, Huff.InCol
      PRINT FUsing$(" " + STR$(BytesRead&), Mask$);
    END IF
    FOR Knt = 1 TO BufSize
      BitsIn = 0
      BitsInCount = 0
      Lbs = InBytes((Knt - 1) \ 2)
      IF (Knt MOD 2) THEN
        Lbs = Lbs AND 255
      ELSE
        Lbs = Lbs \ 256
      END IF
      Bs = Lbs
      DO
        IF HT(Lbs).Parent <> -1 THEN
          Bs = HT(Lbs).Parent
        END IF
        BitsIn = BitsIn * 2
        BitsInCount = BitsInCount + 1
        IF HT(bs).Right = Lbs THEN
          BitsIn = BitsIn OR 1
        END IF
        Lbs = Bs
      LOOP UNTIL HT(Lbs).Parent = -1
      FOR Bi = 1 TO BitsInCount
        BitsOut = (BitsOut * 2) OR (BitsIn AND 1)
        BitsIn = BitsIn \ 2
        BitsOutCount = BitsOutCount + 1
        IF BitsOutCount = 16 THEN
          BitsOutLeft = BitsOut
          ShiftIL BitsOutLeft, 8
          BitsOutRight = BitsOut
          ShiftIR BitsOutRight, 8
          OutBytes(OutPtr) = BitsOutLeft OR BitsOutRight
          OutPtr = OutPtr + 1
          BytesOut& = BytesOut& + 2
          BitsOutCount = 0
          IF OutPtr = (OptBuf \ 2) THEN
            FPutA FILEATTR(OutFile, 2), SEG OutBytes(0), OptBuf
            OutPtr = 0
            IF Huff.OutLin THEN
              LOCATE Huff.OutLin, Huff.OutCol
              PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
            END IF
          END IF
        END IF
      NEXT Bi
    NEXT Knt
  NEXT CurRec&

  IF BitsOutCount <> 0 THEN
    ShiftIL BitsOut, 16 - BitsOutCount
    BitsOutLeft = BitsOut
    ShiftIL BitsOutLeft, 8
    BitsOutRight = BitsOut
    ShiftIR BitsOutRight, 8
    OutBytes(OutPtr) = BitsOutLeft OR BitsOutRight
    OutPtr = OutPtr + 1
    BytesOut& = BytesOut& + 2 + (BitsOutCount < 9)
  END IF

  OutBytes = OutPtr * 2 + (BitsOutCount > 0 AND BitsOutCount < 9)

  IF OutBytes > 0 THEN
    FPutA FILEATTR(OutFile, 2), SEG OutBytes(0), OutBytes
  END IF

  IF Huff.OutLin THEN
    LOCATE Huff.OutLin, Huff.OutCol
    PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
  END IF

  CLOSE InFile, OutFile

  Huff.BytesIn = BytesRead&
  Huff.BytesOut = BytesOut&

END SUB

