#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define CONFIG_PORT_FILE	"/usr/local/ax25/etc/ports"

typedef struct _port
{
	struct _port *Next;
	char Call[10];
	int  Baud;
	int  DefaultWindow;
	char Frequency[24];
} Port;

static Port *ports=NULL;
static Port *port_tail=NULL;

int config_num_ports(void)
{
	int ct=0;
	Port *p=ports;
	while(p!=NULL)
	{
		ct++;
		p=p->Next;
	}
	return ct;
}

static Port *port_ptr(int n)
{
	Port *p=ports;
	while(n-- && p)
		p=p->Next;
	return p;
}

char *config_get_addr(int port)
{
	Port *p=port_ptr(port);
	if(p==NULL)
		return NULL;
	return p->Call;
}

int config_get_window(int port)
{
	Port *p=port_ptr(port);
	if(p==NULL)
		return 0;
	return p->DefaultWindow;
}

int config_get_baud(int port)
{
	Port *p=port_ptr(port);
	if(p==NULL)
		return 0;
	return p->Baud;
}

char *config_get_freq(int port)
{
	Port *p=port_ptr(port);
	if(p==NULL)
		return 0;
	return p->Frequency;
}


static Port *config_init_port(char *line)
{
	Port *p=(Port *)malloc(sizeof(Port));
	if(p==NULL)
	{
		fprintf(stderr,"Out of memory!\n");
		exit(1);
	}
	if(sscanf(line,"%10s %d %d %24s",p->Call,&p->Baud,&p->DefaultWindow,p->Frequency)==-1)
	{
		free(p);
		fprintf(stderr,"Unable to parse: %s",line);
		return NULL;
	}
	if(ports==NULL)
		ports=p;
	else
		port_tail->Next=p;
	port_tail=p;
	p->Next=NULL;
	return p;
}

int config_load_ports()
{
	FILE *f=fopen(CONFIG_PORT_FILE,"r");
	char buf[256];
	if(f==NULL)
	{
		perror(CONFIG_PORT_FILE);
		return -1;
	}
	while(fgets(buf,255,f)!=NULL)
		config_init_port(buf);
	fclose(f);
	if(config_num_ports()==0)
		return -1;
	return 0;
}
