-- Source Ex2.Ada
-- By Arthur V. Lopes, 7/12/94
-- This Program attemt to place ten times the letter A in the first screen line
-- and ten times the letter B in the second screen line.
-- The main program just cleans the screen and places the cursor in the
-- third screen row.
-- Instead of two procedures, two tasks are used to output its letter
-- designator to its screen line.
-- Study carfully the differences among the two approaches.
-- Compile and run this program.
-- You will see that the screen does not shown the same result as the 
-- previous program caused. Why?
-- The problem is caused by inadequate concurrent use of a shared resource.
-- To start with, depending on the scheduller used when you executed the
-- program, the screen is not cleared.
-- The bodyframe of procedure ClearScreen has two procedure calls.
-- The execution of the instructions generated by these two calls must
-- not be interrupted. Otherwise, the screen driver will not understand
-- the intended sequence issued by the two procedure calls.
-- This is one of the problems with program Concurrent_Programming_1.
-- It is a hint for you to find the other problems.
-- The next program, Concurrent_Programming_2 will show you one the most
-- efficient way to make a concurrent version of program 
-- Sequential_Programming.

WITH Ada.Text_IO, VT100; USE Ada.Text_IO;
PROCEDURE Concurent_Programming_1 IS

	SUBTYPE Interval IS INTEGER RANGE 1 .. 10;

	TASK Display_A; -- This is the specification part of Display_A
	TASK Display_B;

	TASK BODY Display_A IS -- This is the body part of Display_A
	BEGIN
		FOR I IN Interval LOOP
			VT100.MoveCursor(I,1);
			DELAY 0.01;
			Put('A');
		END LOOP;
	END Display_A;

	TASK BODY Display_B IS
	BEGIN
		FOR I IN Interval LOOP
			VT100.MoveCursor(I,2);
			DELAY 0.01;
			Put('B');
		END LOOP;
	END Display_B;

BEGIN
	VT100.ClearScreen;
	-- The procedure calls were removed.
	-- Tasks start on their own, after its ancestor task has been
	-- elaborated. Ada 9X does not allow a task call as a means
	-- to initiate the task execution!
	VT100.MoveCursor(1,3);
END Concurent_Programming_1;