;Copyright (c) 1993 Andy Harrover
;Version 1 - 29 July 1991
;Version 1.1 - 1 September 1991 Support for all hatches
;Version 1.2 - 12 September 1991 bug fix
;Version 1.3 - 12 OCT 1991 bug fix
;Version 1.4 - 24 OCT 1991 bug fix and computation of depths
;Version 2.0 - 11 MAR 92 MAJOR overhaul of code - split well and geology
;Version 2.1 - 21 JUN 93 First stable code....long delayed due to work...
;   !!!!!!! THIS IS VERSION 2.1 !!!!!!!
;
;
;
(defun C:AUTOLOG ()
; the following is an error-trapping routine for hatching
  (defun hatch ()
    (setq hatyes 0)
       (cond
          ((= hatyes 0)
            (setq pat(getstring "\nHatch Pattern: "))
            (hatchit)
          );end this case
          ((= hatyes 2)
             (prompt "\nNot Found!..Try Again")
             (setq pat(getstring "\nHatch Pattern: "))
             (hatchit)
          );end this case
       );end cond
    );defun
;hatching subroutine
   (defun hatchit ()
          (cond             
                   ((or (= pat "ar-conc") (= pat "AR-CONC"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-b816") (= pat "AR-B816"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-b816c") (= pat "AR-B816C"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-b88") (= pat "AR-B88"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-brelm") (= pat "AR-BRELM"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-brstd") (= pat "AR-BRSTD"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-hbone") (= pat "AR-HBONE"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-parq1") (= pat "AR-PARQ1"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-rroof") (= pat "AR-RROOF"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-rshke") (= pat "AR-RSHKE"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "box") (= pat "BOX"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "brass") (= pat "BRASS"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "brstone") (= pat "BRSTONE"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "cork") (= pat "CORK"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "earth") (= pat "EARTH"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "escher") (= pat "ESCHER"))
                   (setq pscala 0.1)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "flex") (= pat "FLEX"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "grass") (= pat "GRASS"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "grate") (= pat "GRATE"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "hex") (= pat "HEX"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "honey") (= pat "HONEY"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "hound") (= pat "HOUND"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "INSUL") (= pat "insul"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "line") (= pat "LINE"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "NET") (= pat "net"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "net3") (= pat "NET3"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "PLAST") (= pat "plast"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "plasti") (= pat "PLASTI"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "sacncr") (= pat "SACNCR"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "SQUARE") (= pat "square"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "stars") (= pat "STARS"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "STEEL") (= pat "steel"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "swamp") (= pat "SWAMP"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "trans") (= pat "TRANS"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "TRIANG") (= pat "triang"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "zigzag") (= pat "ZIGZAG"))
                   (setq pscala 0.04)
                   (command "hatch" pat pscala "" (entlast) "")        
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "dots") (= pat "DOTS"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "dolmit") (= pat "DOLMIT"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "u") (= pat "U"))
                   (setq pscala 0.1)
                   (command "hatch" pat "" pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "mudst") (= pat "MUDST"))
                   (setq pscala 0.5)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ar-sand") (= pat "AR-SAND"))
                   (setq pscala 0.06)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "brick") (= pat "BRICK"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "cross") (= pat "CROSS"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case          
                   ((or (= pat "clay") (= pat "CLAY"))
                   (setq pscalai 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "angle") (= pat "ANGLE"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI31") (= pat "ansi31"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ansi32") (= pat "ANSI32"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI33") (= pat "ansi33"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI34") (= pat "ansi34"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI35") (= pat "ansi35"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI36") (= pat "ansi36"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI37") (= pat "ansi37"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "ANSI38") (= pat "ansi38"))
                   (setq pscala 2)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                   ((or (= pat "dash") (= pat "DASH"))
                   (setq pscala 1)
                   (command "hatch" pat pscala "" (entlast) "")
                   (setq hatyes 1)
                );end this case
                  ((= hatyes 0)
                  (setq hatyes 2)
                  (prompt "\nNot Found!..Try Again")
                  (hatch)
                );end this cond
            ):end cond
       );end defun
(command "limits" "-5,-5" "20,20")
(command "zoom" "all")
;(command "setvar" "cmdecho" "0")
(command "pline" "0,8" "8.5,8" "");draws ground surface
(command "style" "b" "romans" ".07" "" "" "" "" "" "");sets style for well construction label
(command "pline" "0,0" "0,11" "8.5,11" "8.5,0" "0,0" "");draws box
(setq linelabel 4.65)
;
; **** Get overall depth and scale it.
;
(setq totald(getreal "\nEnter total depth: "));**** obtain overall depth*
(setq scale(/ totald 7))
;
; **** Get overall width and scale it.
;
(setq totalw(getreal "\nEnter total width: "));**** obtain overal width**
(setq scalew(/ totalw 2)); changed from 2.5 -> 2
;
;   ***********     This section draws the boreholes    *************
;
(setq borings(getint "\nEnter total number of borings: "))
     (if (= borings 1);       **** IF test statement ****  
;
;      ************** PROGN for a single boring ***************
;
        (progn
           (setq boringwidth(getreal "\nEnter boring diameter: "))
           (setq garbage (/ boringwidth scalew)) ; **** xr is scale for right side ****
           (setq offset (/ garbage 2))
           (setq xl (- 6.5 offset))
           (setq xr (+ 6.5 offset))
           (setq boringdepth(getreal "\nEnter boring depth: "))
           (setq scaled (/ boringdepth scale))
           (setq yl (- 8 scaled))
           (setq yu 8)  
           (setq ul(list xl yu))
           (setq ur(list xr yu));        **** upper  right of inner casing ****
           (setq ll(list xl yl));          **** lower left of inner casing **** 
           (setq lr(list xr yl));         **** lower right of inner casing **** 
           (command "pline" ul ur lr ll "c");      **** draws inner casing ****
           ;  ***** (hatch)                       **** calls hatching sub ****    
           ; **** LABEL FOR BORING ****
           (prompt "\nLabel for Boring: ")
           (setq borelabel(read-line))
           (setq midy (/ scaled 2));      **** these two lines find the middle
           (setq midy (- yu midy));     **** of the casing in the y direction
           (setq midxyr(list xl midy));   **** assigns xy for start of line ****
           (setq midxyl(list linelabel midy)) 
           (command "line" midxyr midxyl ""); draws line to casing label
           (setq try (- midy 0.035)); finds y starting point for text
           (setq trx (- xl 0.9)); finds x starting point for text
           (setq tstart(list trx try))
           (command "text" "j" "r" tstart "0" borelabel) ;adds casing label      
         ); **** end paren for progn ****
;
;      ******** PROGN for multiple borings *********
;    **** first block of code handles first boring ****
;
        (progn
           (setq boringwidth(getreal "\nEnter first boring diameter: "))
           (setq meso (/ boringwidth scalew)) ; **** xr is scale for right side ****
           (setq garbage (/ meso 2))
           (setq xl (- 6.5 garbage))
           (setq xr (+ 6.5 garbage))
           (setq boringdepth(getreal "\nEnter first boring depth: "))
           (setq scaled(/ boringdepth scale))
           (setq yl (- 8 scaled))
           (setq yu 8)  
           (setq ul(list xl yu))
           (setq ur(list xr yu));        **** upper  right of inner casing ****
           (setq ll(list xl yl));          **** lower left of inner casing **** 
           (setq lr(list xr yl));         **** lower right of inner casing **** 
           (command "line" ul ur "") 
           (command "line" ll ul "")
           (command "line" lr ur "")
           (setq runl ll)
           (setq runr lr)
;
           ;***** (hatch);                        **** calls hatching sub ****    
           ; **** LABEL FOR BORING ****
           (prompt "\nLabel for Boring: ")
           (setq borelabel(read-line))
           (setq midy (/ scaled 2));      **** these two lines find the middle
           (setq midy (- yu midy));     **** of the casing in the y direction
           (setq midxyr(list xl midy));   **** assigns xy for start of line ****
           (setq midxyl(list linelabel midy)) 
           (command "line" midxyr midxyl ""); draws line to casing label
           (setq try (- midy 0.035)); finds y starting point for text
           (setq trx (- xl 0.9)); finds x starting point for text
           (setq tstart(list trx try))
           (command "text" "j" "r" tstart "0" borelabel) ;adds casing label      
           (setq borings(- borings 1));   **** subtract one -> one is done ****        
;
;     ********   REPEAT loop to handle the rest of the borings   *********
;
(setq runyu yl) ; running depth  -->  scaled
           (repeat borings        ; DEBUG --> this may need a paren
              (setq boringwidth(getreal "\nEnter boring diameter: "))
              (setq garbage (/ boringwidth scalew)) ; **** xr is scale for right side ****
              (setq offset (/ garbage 2))
              (setq xl (- 6.5 offset))
              (setq xr (+ 6.5 offset))
              (setq boringdepth(getreal "\nEnter boring depth: "))
              (setq scaled(/ boringdepth scale))
              (setq yl (- runyu scaled))       
              (setq yu runyu)
              (setq ul(list xl yu))
              (setq ur(list xr yu));        **** upper  right of inner casing ****
              (setq ll(list xl yl));          **** lower left of inner casing **** 
              (setq lr(list xr yl));         **** lower right of inner casing **** 
              (command "line" ll ul "")
              (command "line" lr ur "")
              (command "line" runl ul "")
              (command "line" runr ur "")
              ; **** LABEL FOR BORING ****
              (prompt "\nLabel for Boring: ")
              (setq borelabel(read-line))
              (setq midy (/ scaled 2));      **** these two lines find the middle
              (setq midy (- yu midy));     **** of the casing in the y direction
              (setq midxyr(list xl midy));   **** assigns xy for start of line ****
              (setq midxyl(list linelabel midy)) 
              (command "line" midxyr midxyl ""); draws line to casing label
              (setq try (- midy 0.035)); finds y starting point for text
              (setq trx (- linelabel 0.05)); finds x starting point for text
              (setq tstart(list trx try))
; browneye - borelabel
              (command "text" "j" "r" tstart "0" borelabel) ;adds casing label      
; The following handles line drawing and other running variables      
              (setq runl ll)
              (setq runr lr)
              (setq runyu yl)
            ); **** end paren for repeat ****
          (command "line" ll lr "")
         ); **** end paren for progn ****
      ); **** end paren for if loop
   (setq boringxl xl); **** These two lines carry the value of the
   (setq boringxr xr); **** final boring width to the sand part
;
;******* end of borehole section **********
;
;***********  CASING IF LOOP ****************
;
;
(setq caseno(getint "\nEnter total number of casings: "))
   (if (= caseno 1);      **** IF test statement **** 
;
;   **** FIRST PROGN IS FOR A SINGLE CASING WELL ONLY ****
;
     (progn     
      (setq casewidth(getreal "\nEnter casing diameter: "))
      (setq garbage (/ casewidth scalew))
      (setq offset (/ garbage 2))
      (setq xl (- 6.5 offset)); xl = x left
      (setq xr (+ 6.5 offset)); xr = x right
;   
;       <------**** Set xl & xr for screen ****------->
;
     (setq screenxl xl)
     (setq screenxr xr)
;
;
      (setq casedepth(getreal "\nEnter casing depth: "))
      (setq scaled(/ casedepth scale)) ;
      (setq yl (- 8 scaled));   **** yl is scaled variable for bottom of casing ****
      (setq yu 8);            **** constant for top left of well ****
      (setq ul(list xl yu));  **** upper left of inner casing ****
      (setq ur(list xr yu));  **** upper  right of inner casing ****
      (setq ll(list xl yl));  **** lower left of inner casing **** 
      (setq lr(list xr yl));  **** lower right of inner casing **** 
      (command "pline" ul ur lr ll "c");                 **** draws inner casing ****
      ; **** LABEL FOR CASING ****
      (prompt "\nLabel for Casing: ")
      (setq caselabel(read-line))
      (setq midy (/ scaled 2));      **** these two lines find the middle
      (setq midy (- yu midy));     **** of the casing in the y direction
      (setq midxyr(list xl midy));   **** assigns xy for start of line ****
      (setq midxyl(list linelabel midy)) 
      (command "line" midxyr midxyl ""); draws line to casing label
      (setq try (- midy 0.035)); finds y starting point for text
      (setq tstart(list trx try))
      (command "text" "j" "r" tstart "0" caselabel) ;adds casing label      
;
  (setq casingxl xl); **** These variable carry the value of the final
  (setq casingxr xr); **** casing width to the sand part
;
;<------------------------------------------------------------->
;****------------------>   Well stick up  <-----------------****
;<------------------------------------------------------------->
;
   (setq stickll ul);  These two lines transfer the value from
   (setq sticklr ur); the above fragment to establish the bottom of
;                       the stick-up
;
   (setq stickup(getreal "\nEnter well stick up: ")); Gets stick-up height
   (setq scaled(/ stickup scale)) ;
   (setq stickup(+ scaled yu))
   (setq stickul(list xl stickup));      **** upper left of stick up ****
   (setq stickur(list xr stickup));     **** upper  right of stick up ****
   (command "line" stickll stickul "")
   (command "line" stickul stickur "")
   (command "line" stickur sticklr "")
;
;<------------------------------------------------------------->
;****--------------->   Protective casing <-----------------****
;<------------------------------------------------------------->
;
   (setq protabove (getreal "\nHow far above the ground does the protctive casing go "))
   (setq protbelow (getreal "\nHow far below the ground does the protctive casing go "))
   (setq protwid (getreal "\nHow wide is the protective casing: "))
   (setq garbage (/ protwid scalew))
   (setq offset (/ garbage 2))
;
;       <------**** Establish Knowns ****------->
;
   (setq xl (- 6.5 offset)); xl = x left
   (setq xr (+ 6.5 offset)); xr = x right
   (setq ground 8);       **** constant for ground ****
; **** find scaled lower limits of prot. casing and draw it ****
;
   (setq scaled(/ protbelow scale)) ;
   (setq protbelow (- 8 scaled));   **** yl is scaled variable for bottom of casing ****
;     ***** DRAW IT ****
   (setq protll (list xl protbelow))
   (setq protlr (list xr protbelow)) 
   (setq protur (list xr ground))
   (setq protul (list xl ground))
   (command "line" protll protul "")
   (command "line" protlr protur "")
;
;**** find scaled upper limits of prot. casing and draw it ****
;
   (setq scaled(/ protabove scale)) ;
   (setq protabove (+ 8 scaled));   **** yl is scaled variable for bottom of casing ****
   (setq protll (list xl ground))
   (setq protlr (list xr ground))
   (setq protur (list xr protabove))
   (setq protul (list xl protabove))
   (command "line" protll protul "")
   (command "line" protur protul "")
   (command "line" protlr protur "")
;
     ); ends progn 
;
;   **** This progn handles the first casing  and has an imbedded ****
;   **** repeat loop to handle subsequent casings.                ****
;
    (progn
      (prompt "\nThe first casing is the outermost (widest) casing"); DEBUG parens in text
      (setq casewidth(getreal "\nEnter first casing diameter: "))
      (setq garbage (/ casewidth scalew))
      (setq offset (/ garbage 2))
      (setq xl (- 6.5 offset))
      (setq xr (+ 6.5 offset))
      (setq casedepth(getreal "\nEnter first casing depth: "))
      (setq scaled(/ casedepth scale)) ;
      (setq yl (- 8 scaled));         **** yl is scaled variable for bottom of casing ****
      (setq yu 8);                            **** constant for top left of well ****
      (setq ul(list xl yu));                     **** upper left of inner casing ****
      (setq ur(list xr yu));                   **** upper  right of inner casing ****
      (setq ll(list xl yl));                     **** lower left of inner casing **** 
      (setq lr(list xr yl));                    **** lower right of inner casing **** 
      (command "line" ul ur "") 
      (command "line" ll ul "")
      (command "line" lr ur "")
      (setq runl ll)
      (setq runr lr)
      ; **** LABEL FOR CASING ****
      (prompt "\nLabel for Casing: ")
      (setq caselabel(read-line))
      (setq midy (/ scaled 2));      **** these two lines find the middle
      (setq midy (- yu midy));     **** of the casing in the y direction
      (setq midxyr(list xl midy));   **** assigns xy for start of line ****
      (setq midxyl(list linelabel midy)) 
      (command "line" midxyr midxyl ""); draws line to casing label
      (setq try (- midy 0.035)); finds y starting point for text
      (setq tstart(list trx try))
      (command "text" "j" "r" tstart "0" caselabel) ;adds casing label      
      (setq caseno(- caseno 1));   **** subtract one -> one is done ****        
;
;<---------**** REPEAT loop for the rest of casings ****------------>
;
           (setq runyu yl) ; running depth  -->  scaled
;
;
           (repeat caseno
           (setq runyu yl)
           (setq casewidth(getreal "\nEnter casing diameter: "))
           (setq garbage (/ casewidth scalew))
           (setq offset (/ garbage 2))
           (setq xl (- 6.5 offset))
           (setq xr (+ 6.5 offset))
           (setq casedepth(getreal "\nEnter casing depth: "))
           (setq scaled(/ casedepth scale)) ;
           (setq yl (- runyu scaled))       
           (setq yu runyu)
           (setq ul(list xl yu));          **** upper left of inner casing ****
           (setq ur(list xr yu));        **** upper  right of inner casing ****
           (setq ll(list xl yl));          **** lower left of inner casing **** 
           (setq lr(list xr yl));         **** lower right of inner casing **** 
           (command "line" ul ll "")
           (command "line" lr ur "")
           (command "line" runl ul "")
           (command "line" runr ur "")
           ; **** LABEL FOR CASING ****
           (prompt "\nLabel for Casing: ")
           (setq caselabel(read-line))
           (setq midy (/ scaled 2));      **** these two lines find the middle
           (setq midy (- yu midy));     **** of the casing in the y direction
           (setq midxyr(list xl midy));   **** assigns xy for start of line ****
           (setq midxyl(list linelabel midy)) 
           (command "line" midxyr midxyl ""); draws line to casing label
           (setq try (- midy 0.035)); finds y starting point for text
           (setq tstart(list trx try))
           (command "text" "j" "r" tstart "0" caselabel) ;adds casing label      
           (setq runyu yl)
           (setq runl ll)
           (setq runr lr)
;
           ); ENDS REPEAT
        (setq ytop 8)        
        (setq topl (list xl ytop));  **** this group of code will extend
        (setq topr (list xr ytop));  **** the innermost casing to the surface
        (setq botl (list xl yu))
        (setq botr (list xr yu));  **** yu takes the y upper from loop
        (command "line" topl botl "")
        (command "line" topr botr "")
        (command "line" ll lr "")
;   
;       <------**** Set xl & xr for screen ****------->
;
  (setq casingxl xl); **** These variable carry the value of the final
  (setq casingxr xr); **** casing width to the sand part
;
     (setq xl screenxl)
     (setq xr screenxr)
;
;
;
;
;<------------------------------------------------------------->
;****------------------>   Well stick up  <-----------------****
;<------------------------------------------------------------->
;
   (setq stickll topl);  These two lines transfer the value from
   (setq sticklr topr); the above fragment to establish the bottom of
;                       the stick-up
;
   (setq stickup(getreal "\nEnter well stick up: ")); Gets stick-up height
   (setq scaled(/ stickup scale)) ;
   (setq stickup(+ scaled ytop))
   (setq stickul(list xl stickup));      **** upper left of stick up ****
   (setq stickur(list xr stickup));     **** upper  right of stick up ****
   (command "line" stickll stickul "")
   (command "line" stickul stickur "")
   (command "line" stickur sticklr "")
;
;<------------------------------------------------------------->
;****--------------->   Protective casing <-----------------****
;<------------------------------------------------------------->
;
   (setq protabove (getreal "\nHow far above the ground does the protctive casing go "))
   (setq protbelow (getreal "\nHow far below the ground does the protctive casing go "))
   (setq protwid (getreal "\nHow wide is the protective casing: "))
   (setq garbage (/ protwid scalew))
   (setq offset (/ garbage 2))
;
;       <------**** Establish Knowns ****------->
;
   (setq xl (- 6.5 offset)); xl = x left
   (setq xr (+ 6.5 offset)); xr = x right
   (setq ground 8);       **** constant for ground ****
;
; **** find scaled lower limits of prot. casing and draw it ****
;
   (setq scaled(/ protbelow scale)) ;
   (setq protbelow (- 8 scaled));   **** yl is scaled variable for bottom of casing ****
;     ***** DRAW IT ****
   (setq protll (list xl protbelow))
   (setq protlr (list xr protbelow)) 
   (setq protur (list xr ground))
   (setq protul (list xl ground))
   (command "line" protll protul "")
   (command "line" protlr protur "")
;
;**** find scaled upper limits of prot. casing and draw it ****
;
   (setq scaled(/ protabove scale)) ;
   (setq protabove (+ 8 scaled));   **** yl is scaled variable for bottom of casing ****
   (setq protll (list xl ground))
   (setq protlr (list xr ground))
   (setq protur (list xr protabove))
   (setq protul (list xl protabove))
   (command "line" protll protul "")
   (command "line" protur protul "")
   (command "line" protlr protur "")
;
;
      ); ENDS PROGN
   ); ENDS IF
;
; **** This section adds things like the screen, the sand pack and the
; **** bentonite seal so that the well is fairly complete here
;
;
;<------------------------------------------------------------->
;****--------------->     Well screen     <-----------------****
;<------------------------------------------------------------->
;
;
;
(setq screendep(getreal "\nEnter the depth to the top of the screen: "))
(setq screenint(getreal "\nEnter the height of the screen: "))
(setq totop(/ screendep scale)) ; scaled distance to screen top!!!
(setq scrwid(/ screenint scale)); scaled screen height!!!
(setq screentop(- 8 totop)); top of screen
(setq screenbot(- screentop scrwid)); bottom of screen
(setq ul(list screenxl screentop))
(setq ur(list screenxr screentop))
(setq ll(list screenxl screenbot))
(setq lr(list screenxr screenbot))
(command "pline" ul ll lr ur "c"); Draws screen
(hatch); calls hatching sub
(setq halfdep(/ scrwid 2))
(setq screenmid(- screentop halfdep))
(setq midxyr(list screenxl screenmid)) 
(setq midxyl(list linelabel screenmid)) 
(command "line" midxyr midxyl ""); draws line to casing label
(prompt "\nLabel for Screen: ")
(setq scrlabel(read-line))
(setq try (- screenmid 0.035)); finds y starting point for text
;(setq trx (- screenxl 0.9)); finds x starting point for text 
(setq tstart(list trx try))
(command "text" "j" "r" tstart "0" scrlabel) ;adds screen label      
;
; **** End of screen section
;
;
;<--------------------------------------------------------->
;****------>  This section is for the Sandpack <-------****
;<--------------------------------------------------------->;
;
(setq ans (getstring "\nIs there any sand in the well? (y or n) "))
(if (= ans "y");      **** IF test statement **** 
(progn
(setq sanddep(getreal "\nEnter the depth to the top of the sand: "))
(setq deptotop(/ sanddep scale)) ; scaled distance to sand top!!!
(setq sandtop(- 8 deptotop)); top of sand in page units.!!!!
; **** Next line finds interval
(setq sandint(getreal "\nEnter the thickness of the sand: "))
(setq sandwid(/ sandint scale)); scaled sand height!!!
(setq sandbot(- sandtop sandwid)); bottom of sand
;
 (setq xl boringxl)
 (setq xr casingxl)
;
; **** First do left side of well ****
;
(setq ul(list xl sandtop))
(setq ur(list xr sandtop))
(setq ll(list xl sandbot))
(setq lr(list xr sandbot))
(command "pline" ul ll lr ur "c"); Draws extents of sand
;(hatch); calls hatching sub
(command "hatch" pat "" pscala (entlast) "")        
(setq halfdep(/ sandwid 2))
(setq sandmid(- sandtop halfdep))
(setq midxyr(list xl sandmid)) 
(setq midxyl(list linelabel sandmid)) 
(command "line" midxyr midxyl ""); draws line to casing label
(prompt "\nLabel for Sand: ")
(setq sandlabel(read-line))
(setq try (- sandmid 0.035)); finds y starting point for text
(setq trx (- xl 0.9)); finds x starting point for text
(setq tstart(list trx try))
(command "text" "j" "r" tstart "0" sandlabel) ;adds sand label      
;
;
; **** Now the right side ****
;
(setq xr boringxr); these two lines set up the x coords.
(setq xl casingxr)
;
(setq ul(list xl sandtop))
(setq ur(list xr sandtop))
(setq ll(list xl sandbot))
(setq lr(list xr sandbot))
(command "pline" ul ll lr ur "c"); Draws extents of sand
(command "hatch" pat "" pscala (entlast) "")        
;
); progn
); ends if
; <--------------------------------------------------------->
; ****---->  This section is for the Bentonite seal <----****
; <--------------------------------------------------------->
;
(setq ans (getstring "\nIs there a bentonite seal (y or n): "))
(if (= ans "y");      **** IF test statement **** 
(progn
  (setq benthick(getreal "\nEnter Thickness of bentonite seal: "))
  (setq benthicks(/ benthick scale)) ; **** scaled bentonite thickness ****
;
;      **** Assign bentonite x and y values **** 
;     **** Using sandtop as bentonite bottom ****
;    **** Using previous widths for bentonite. ****
;
(setq bentop (+ benthicks sandtop)); **** top of bentonite ****
(setq benbot sandtop); **** bottom of bentonite ****
;
;
; **** First do left side of bentonite ****
(setq xl boringxl); transfer values
(setq xr casingxl)
(setq ll(list xl benbot))
(setq lr(list xr benbot))
(setq ur(list xr bentop))
(setq ul(list xl bentop))
(command "pline" ul ll lr ur "c"); Draws extents of bentonite
(hatch)
;
;**** Draw label and tick for bentonite ****
;
(setq halfthick(/ benthicks 2))
(setq benmid(- bentop halfthick))
(setq midxyr(list xl benmid)) 
(setq midxyl(list linelabel benmid)) 
(command "line" midxyr midxyl ""); draws line to casing label
(prompt "\nLabel for Bentonite: ")
(setq benlabel(read-line))
(setq try (- benmid 0.035)); finds y starting point for text
(setq trx (- xl 0.9)); finds x starting point for text
(setq tstart(list trx try))
(command "text" "j" "r" tstart "0" benlabel) ;adds bentonite label      
;
; **** Now do right side of bentonite ****
;
(setq xl boringxr); transfer values
(setq xr casingxr)
(setq ll(list xl benbot))
(setq lr(list xr benbot))
(setq ur(list xr bentop))
(setq ul(list xl bentop))
(command "pline" ul ll lr ur "c"); Draws extents of bentonite
(command "hatch" pat "" pscala (entlast) "")
;
;
);progn
); closes if
;<----------------------------------------------->
; ****------------->LITHOLOGY<----------------**** 
;<----------------------------------------------->
;
(prompt "\nTHIS SECTION IS FOR GEOLOGIC LOG")
(setq garbage(getstring "\nHit any key to continue..."))
(command "move" "w" "0,0" "20,20" "" "1,1" "0,0")
(setq a(getreal "\nThickness of layer: ")) 
(setq thick(/ a scale))
(setq x 0)
(setq xr 1)
(setq ul(list x thick))
(setq ur(list xr thick)) 
(command "pline" "0,0" ul ur "1,0" "c");draws first formation
(hatch)
(command "pline" ul ur "")
(command "pedit" (entlast) "w" ".01" "")
(command "style" "b" "romans" ".07" "" "" "" "" "" "");sets style for well material label
(command "line" ul "@.105<180" "");draws tick at top of layer
(setq try (- thick 0.05))
(setq trx -0.15)
(setq tstart(list trx try))
;**** (prompt "\nDepth to formation:")
;**** (setq fdepth(read-line))
(setq runda (- totald a))
(setq text(rtos runda 2 1))
(command "text" "j" "r" tstart "0" text) ;adds depth label
(setq lry(- try 0.11))
(setq lstart(list trx lry))
(prompt "\nLabel for formation: ")
(prompt "\nMaximum of 14 characters  ")
(setq flabel(read-line))
(command "text" "j" "r" lstart "0" flabel) ;adds formation label
(setq fans(getstring "\nAnother line of text? (Y or N) "))
     (while (or(= fans "y") (= fans "Y"));while loop
     (prompt "\nNext label for formation: ")
     (prompt "\nMaximum of 14 characters  ")
     (setq flabel(read-line))
     (setq lry(- lry 0.11))
     (setq lstart(list trx lry))
     (command "text" "j" "r" lstart "0" flabel) ;adds formation label
     (setq fans(getstring "\nAnother line of text? (Y or N) "))
     );ends while loop
;
(setq ydis thick)
;(setq answer "y")
      (setq answer (getstring "\nAnother Layer? (Y or N)"))
      (while (or (= answer "y") (= answer "Y"))    ;while loop
      (setq a(getreal "\nThickness of layer: ")) 
      ;(setq testcond runda)
      ;(setq runda (- runda a))
      (setq temp(/ a scale))
      (setq thick (+ temp ydis))
      (setq eight 8)
           (if (> thick eight)
             (progn
                   (prompt "\nTHICKNESS EXCEEDS GROUND SURFACE!!")
               (prompt "\n AutoLog can Perform rounding to top of surface")
     (setq answer (getstring "\nTry Again or Autoround? (T or A): "))
      (if (or (= answer "t") (= answer "T"))
              (progn
                   (setq answer "y")
                  ; (setq runda testcond)
              );closes progn
              (progn
                   (setq thick 8)
                (setq ll(list x ydis))
                (setq ul(list x thick))
                (setq ur(list xr thick)) 
                (setq lr(list xr ydis))
                (command "pline" ll ul ur lr "c")
                (setq ydis (+ ydis temp))
                (hatch)
                (command "pline" ul ur "")
                (command "pedit" (entlast) "w" ".01" "")
                (command "line" ul "@.105<180" "");draws tick at top of layer
                (setq try (- thick 0.05))
                (setq trx -0.15)
                (setq tstart(list trx try))
                ;(prompt "\nDepth to formation:")
                ;(setq fdepth(read-line))
               ; (command "text" "j" "r" tstart "0" fdepth) ;adds depth label
                (setq lry(- try 0.11))
                (setq lstart(list trx lry))
                (prompt "\nLabel for formation: ")
                (prompt "\nMaximum of 14 characters  ")
                (setq flabel(read-line))
                (command "text" "j" "r" lstart "0" flabel) ;adds formation label
                (setq fans(getstring "\nAnother line of text? (Y or N) "))
                     (while (or(= fans "y") (= fans "Y"));while loop
                     (prompt "\nNext label for formation: ")
                     (prompt "\nMaximum of 14 characters  ")
                     (setq flabel(read-line))
                     (setq lry(- lry 0.11))
                     (setq lstart(list trx lry))
                     (command "text" "j" "r" lstart "0" flabel) ;adds formation label
                     (setq fans(getstring "\nAnother line of text? (Y or N) "))
                     );ends while loop
                );closes progn
               );closes if
             );ends progn
             (progn
                (setq ll(list x ydis))
                (setq ul(list x thick))
                (setq ur(list xr thick)) 
                (setq lr(list xr ydis))
                (command "pline" ll ul ur lr "c")
                (setq ydis (+ ydis temp))
                (hatch)
                (command "pline" ul ur "")
                (command "pedit" (entlast) "w" ".01" "")
                (command "line" ul "@.105<180" "");draws tick at top of layer
                (setq try (- thick 0.05))
                (setq trx -0.15)
                (setq tstart(list trx try))
                ;(prompt "\nDepth to formation:")
                ;(setq fdepth(read-line))
                (setq runda (- runda a))
                (setq text(rtos runda 2 1))
                (command "text" "j" "r" tstart "0" text) ;adds depth label
                (setq lry(- try 0.11))
                (setq lstart(list trx lry))
                (prompt "\nLabel for formation: ")
                (prompt "\nMaximum of 14 characters  ")
                (setq flabel(read-line))
                (command "text" "j" "r" lstart "0" flabel) ;adds formation label
                (setq fans(getstring "\nAnother line of text? (Y or N) "))
                     (while (or(= fans "y") (= fans "Y")) ;while loop
                     (prompt "\nNext label for formation: ")
                     (prompt "\nMaximum of 14 characters  ")
                     (setq flabel(read-line))
                     (setq lry(- lry 0.11))
                     (setq lstart(list trx lry))
                     (command "text" "j" "r" lstart "0" flabel) ;adds formation label
                     (setq fans(getstring "\nAnother line of text? (Y or N) "))
                     );ends while loop
                (setq answer (getstring "\nAnother Layer? (Y or N)"))
            );ends progn
         );ends if
      );ends while loop
;(command "move" "w" "-3,-3" "20,20" "" "1.5,3.99" "1.89,4.95")
;(command "move" "w" "-3,-3" "20,20" "" ".3878,.95" "1.65,.5")
; (command "pline" "0,0" "0,11" "8.5,11" "8.5,0" "0,0" "");draws box
; (command "pedit" (entlast) "w" ".02" "")
;
(command "insert" "header" "-1,10" "" "" "")
;  ****  END OF PROGRAM  ****   !!!HURRAY!!!
);ends program
