unit EDOrders;

{ See the comments in MAIN.PAS for information about this project }

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Dialogs, Forms, StdCtrls, DBGrids, DBCtrls, DBTables, DB,
  Buttons, Grids, DBLookup, ExtCtrls, Mask, Refer, afilter,
  aDatedit, adbgrid;

type
  TEdOrderForm = class(TForm)
    HeaderPanel: TPanel;
    ShipToAdd1Edit: TDBEdit;
    ShipToAdd2Edit: TDBEdit;
    CustAdd1Edit: TDBEdit;
    CustAdd2Edit: TDBEdit;
    ShipToCompanyEdit: TDBEdit;
    CustCityEdit: TDBEdit;
    CustStateEdit: TDBEdit;
    CustZipEdit: TDBEdit;
    ShipToCityEdit: TDBEdit;
    ShipToStateEdit: TDBEdit;
    ShipToZipEdit: TDBEdit;
    ModeIndicator: TLabel;
    POEdit: TDBEdit;
    TermsCombo: TDBComboBox;
    PaymentCombo: TDBComboBox;
    ShipViaCombo: TDBComboBox;
    Speedbar: TPanel;
    DBNavBtns: TDBNavigator;
    DBEditBtns: TDBNavigator;
    ActiveSource: TDataSource;
    AmountPaidEdit: TDBEdit;
    TotalEdit: TDBEdit;
    TaxTotalEdit: TDBEdit;
    FreightEdit: TDBEdit;
    AmountDueEdit: TDBEdit;
    TaxRateEdit: TDBEdit;
    CloseBtn: TButton;
    CancelBtn: TButton;
    PostBtn: TButton;
    Image1: TImage;
    Bevel1: TBevel;
    DBText1: TDBText;
    CustNoEdit: TDBEdit;
    DBReference1: TDBReference;
    ReferencePanel1: TReferencePanel;
    Button1: TButton;
    FilterLink1: TFilterLink;
    DBReference2: TDBReference;
    SaleDateEdit: TAutoDBDateEdit;
    DBGridRefBtn1: TDBGridRefBtn;
    ItemsGrid: TAutoDBGrid;
    DataSource1: TDataSource;
    ReferencePanel2: TReferencePanel;
    Label1: TLabel;
    procedure ItemsGridEnter(Sender: TObject);
    procedure ActiveSourceStateChange(Sender: TObject);
    procedure ItemsGridExit(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure PostBtnClick(Sender: TObject);
    procedure OrdersSourceStateChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SoldByComboKeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
  public
    procedure Enter;
    procedure Edit(OrderNo: Double);
  end;

var
  EdOrderForm: TEdOrderForm;

implementation

uses DataMod, Edcust;

{$R *.DFM}

const
  DatasetStates: array[TDataSetState] of string =
    ('Not active', 'Browsing', 'Editing', 'Inserting', '', '', '', '', '');
  HelpTopicEdit = 2;
  HelpTopicBrowse = 3;


{ ======================= Public Methods ======================= }

procedure TEdOrderForm.Enter;
begin
  MastData.OrdersSource.OnStateChange := OrdersSourceStateChange;
  try
    MastData.Orders.Open;
    MastData.Orders.Insert;
    ShowModal;
  finally
    MastData.OrdersSource.OnStateChange := nil;
  end;
end;

procedure TEdOrderForm.Edit(OrderNo: Double);
begin
  MastData.OrdersSource.OnStateChange := OrdersSourceStateChange;
  try
    MastData.Orders.Open;
    MastData.Orders.Locate('OrderNo', OrderNo, []);
    ShowModal;
  finally
    MastData.OrdersSource.OnStateChange := nil;
  end;
end;

{ ======================  Event Handlers  ====================== }

{ These two methods enable the navigators to service both the Orders
  and Items tables by switching the ActiveSource between them. }

procedure TEdOrderForm.ItemsGridEnter(Sender: TObject);
begin
  ActiveSource.Dataset := MastData.Items;
end;

procedure TEdOrderForm.ItemsGridExit(Sender: TObject);
begin
  ActiveSource.Dataset := MastData.Orders;
end;

{ Update the mode indicator when the state of the "Active" datasource
  (Orders or Items) changes }

procedure TEdOrderForm.ActiveSourceStateChange(Sender: TObject);
begin
  with ActiveSource do
  begin
    if Dataset <> nil then ModeIndicator.Caption :=
      Format('[%S: %S]', [Dataset.Name, DatasetStates[State]]);
    if State in [dsEdit, dsInsert] then
    begin
      HelpContext := HelpTopicEdit;
      ModeIndicator.Font.Color := clRed;
    end
    else
    begin
      HelpContext := HelpTopicBrowse;
      ModeIndicator.Font.Color := clBlue;
    end;
  end;
end;

{ Enable or disable buttons as needed when the state of the orders table changes}

procedure TEdOrderForm.OrdersSourceStateChange(Sender: TObject);
begin
  PostBtn.Enabled := MastData.Orders.State in dsEditModes;
  CancelBtn.Enabled := PostBtn.Enabled;
  CloseBtn.Enabled := MastData.Orders.State = dsBrowse;
end;


{ Begins a series of cascading Before and After post events }

procedure TEdOrderForm.PostBtnClick(Sender: TObject);
begin
  MastData.Orders.Post;
end;

{ Cancels insert or edit on the Orders table }

procedure TEdOrderForm.CancelBtnClick(Sender: TObject);
begin
  MastData.OrdersAfterCancel(MastData.Orders);
end;

{ Prints snapshot of the form. An invoice report is available via the Main window }

procedure TEdOrderForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  MsgResult: Integer;
begin
  CanClose := MastData.DataSetApplyUpdates(MastData.Orders, ModalResult = mrOK);
end;

procedure TEdOrderForm.SoldByComboKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#13, #27]) then
    Key := #0;
end;

procedure TEdOrderForm.Button1Click(Sender: TObject);
begin
  EdCustForm.Edit(MastData.CustByCompSrc.DataSet.Fields[0].Value);
  MastData.CustByCompSrc.Dataset.Refresh;
end;

end.
