unit Brparts;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB, DBCtrls, StdCtrls, ExtCtrls, Grids, DBGrids, Buttons,
  adbgrid, afilter;

type
  TBrPartsForm = class(TForm)
    Panel1: TPanel;
    Navigator: TDBNavigator;
    ActivateBtn: TSpeedButton;
    EditBtn: TButton;
    Panel3: TPanel;
    CloseBtn: TButton;
    Bevel1: TBevel;
    PartsGrid: TAutoDBGrid;
    FilterLink1: TFilterLink;
    Label1: TLabel;
    procedure ActivateQuery(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FPartNo: Double;
    function GetPartNo: Double;
    procedure SetPartNo(NewPartNo: Double);
  public
    property PartNo: Double read GetPartNo write SetPartNo;
  end;

var
  BrPartsForm: TBrPartsForm;

implementation

uses EdParts, DataMod;

{$R *.DFM}

function TBrPartsForm.GetPartNo: Double;
begin
  Result := MastData.PartsSource.Dataset.Fields[0].AsFloat;
end;

procedure TBrPartsForm.SetPartNo(NewPartNo: Double);
begin
  MastData.PartsSource.Dataset := MastData.Parts;
  MastData.Parts.Locate('PartNo', NewPartNo, []);
end;

procedure TBrPartsForm.ActivateQuery(Sender: TObject);
begin
  if not ActivateBtn.Down then begin
    MastData.PartsSource.Dataset := MastData.Parts;
    PartsGrid.SetSortedOrder(0, gsAsc);
    PartsGrid.SetSortedOrder(1, gsAsc);
  end else
    try
      MastData.PartsQuery.Close;
      MastData.PartsQuery.Open;
      MastData.PartsSource.Dataset := MastData.PartsQuery;
    except
      MastData.PartsSource.Dataset := MastData.Parts;
      raise;
    end;
end;

procedure TBrPartsForm.EditBtnClick(Sender: TObject);
begin
  if ActivateBtn.Down then
  begin
    EdPartsForm.Edit(MastData.PartsQueryPartNo.Value);
    MastData.PartsQuery.Close;
    MastData.PartsQuery.Open;
  end else
    EdPartsForm.Edit(MastData.PartsPartNo.Value);
end;

procedure TBrPartsForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TBrPartsForm.FormShow(Sender: TObject);
begin
  MastData.Parts.Open;
end;

end.
