Global TZ$()
Global TZs%

Global gLongitude As String
Global gLatitude As String
Global gLocation As String
Global gTimezone As String
Global gDSTAuto As String
Global gDST As String
Global DSTStart, DSTStop


'You think the sun rise, set for you
'but the same sun rise and set and shine for other folks too


' 70    Print Tab(27); " An Astronomy Program"
' 80    Print
' 90    Print Tab(20); " adapted by Chris Spratt - June, 1985"
'100    Print Tab(18); " and modified by David Birley - May, 1988"
'110    Print
'120    Print Tab(21); " from a program by William C. Bell"
'130    Print Tab(17); "Published in Astronomy Magazine - April, 1984"

'Thanks, all!!!

Sub CalcDSTStartStop (tNow)
Dim I%
For I% = 1 To 7
   If Weekday(DateSerial(Year(tNow), 4, I%)) = 1 Then
      DSTStart = DateSerial(Year(tNow), 4, I%)
      Exit For
   End If
Next I%

For I% = 31 To 24 Step -1
   If Weekday(DateSerial(Year(tNow), 10, I%)) = 1 Then
      DSTStop = DateSerial(Year(tNow), 10, I%)
      Exit For
   End If
Next I%

End Sub

Sub CalcSunRiseSet (tLONJ$, tLAT$, Zone#, DST%, ltNow, SunRise$, SunSet$)
Dim A#, B#, C#, D#, E#, F#, G#, H#, LAT#, LONJ#
Dim P#, Q#, R#

Dim Hrs%, Mns%
Dim TStr$
Dim PPos%

Zone# = SexagesimalToDecimal#(Zone#)

Zone# = -(Zone# - DST%)

970    Let A = 1.5708
980    Let B = 3.14159
990    Let C = 4.71239
1000    Let D = 6.28319
1010    Let LAT = Val(tLAT$)
1020    Let LONJ = Val(tLONJ$)

1040    Let tYEAR$ = Right$(Date$, 4)
1050    Let tMONTH$ = Left$(Date$, 2)
1060    Let tDAY$ = Mid$(Date$, 4, 2)

LAT# = SexagesimalToDecimal#(LAT#)

1150    Let E = LAT * .0174533

LONJ# = SexagesimalToDecimal#(LONJ#)

1210    Let F# = LONJ# * .0174533

1270    Let G# = (Zone#) * .261799

1310    H# = Year(ltNow)

1350    I = Month(ltNow)

1380    J = Day(ltNow)

1410  Rem - DAY OF YEAR
H# = Val(Format$(ltNow, "y"))

1560    Let I = 0
1570    Let J = A
1580    GoSub 2180

1590  Rem
1600    Let R = -.309017
1610    GoSub 2710
1620    'Debug.Print "A dawn "; V

1630  Rem
1640    Let R = -.207912
1650    GoSub 2710
1660    'Debug.Print "N dawn "; V

1670  Rem
1680    Let R = -.104528
1690    GoSub 2710
1700    'Debug.Print "C dawn "; V

1710  Rem
1720    Let R = -.0145439
1730    GoSub 2710
'TStr$ = Format$(V, "0.00")
Hrs% = Int(V)
Mns% = 100 * (V - Hrs%)
SunRise$ = LCase$(Format$(TimeSerial(Hrs%, Mns%, 0), "h:mma/p"))
'If Left$(SunRise$, 1) = "0" Then SunRise$ = Mid$(SunRise$, 2, 255)
1740    'Debug.Print "Sunris "; V, SUnRis$
1750  Rem

1760  Rem - SETTING PHENOMENA
1770  Rem
1780    Let I = 1
1790    Let J = C
1800    GoSub 2180

1810  Rem
1820    Let R = -.0145439
1830    GoSub 2710
Hrs% = Int(V)
Mns% = 100 * (V - Hrs%)
SunSet$ = LCase$(Format$(TimeSerial(Hrs%, Mns%, 0), "h:mma/p"))
'If Left$(SunSet$, 1) = "0" Then SunSet$ = Mid$(SunSet$, 2, 255)
'SunSet$ = Format$(TimeValue(Format$(V, "0.00")), "h:mma/p")
1840    'Debug.Print "Sunset "; V

1850  Rem
1860    Let R = -.104528
1870    GoSub 2710
1880    'Debug.Print "C dusk "; V

1890  Rem
1900    Let R = -.207912
1910    GoSub 2710
1920    'Debug.Print "N dusk "; V

1930  Rem
1940    Let R = -.309017
1950    GoSub 2710
1960    'Debug.Print "A dusk "; V
1970  Rem
Exit Sub

2150  Rem
2160  Rem - APPROXIMATE TIME
2170  Rem
2180    Let K = H + ((J + F) / D)
2190  Rem
2200  Rem - SOLAR MEAN ANOMALY
2210  Rem
2220    Let L = K * .017202
2230    Let L = L - .0574039
2240  Rem
2250  Rem - SOLAR TRUE LONGITUDE
2260  Rem
2270    Let Z = Sin(L)
2280    Let M = L + .0334405 * Z
2290    Let Z = Sin(2 * L)
2300    Let M = M + .000349066 * Z
2310    Let M = M + 4.93289
2320  Rem
2330  Rem - QUADRANT DETERMINATION
2340  Rem
2350    Let Z = M
2360    GoSub 3200
2370    Let M = Z
2380    Let X = M / A
2390    Let Y = Int(X)
2400    Let Z = X - Y
2410    If Z <> 0 Then 2430
2420    Let M = M + .00000484814
2430    Let N = 2
2440    If M > C Then 2510
2450    Let N = 1
2460    If M > A Then 2510
2470    Let N = 0
2480  Rem
2490  Rem - SOLAR RIGHT ASCENSION
2500  Rem
2510    Let P = Sin(M) / Cos(M)
2520    Let P = Atn(.91746 * P)
2530  Rem
2540  Rem - QUADRANT ADJUSTMENT
2550  Rem
2560    If N = 0 Then 2640
2570    If N = 2 Then 2600
2580    Let P = P + B
2590    GoTo 2640
2600    Let P = P + D
2610  Rem
2620  Rem - SOLAR DECLINATION
2630  Rem
2640    Let Q = .39782 * Sin(M)
2650    Let Q = Q / Sqr(-Q * Q + 1)
2660    Let Q = Atn(Q)
2670    Return
2680  Rem
2690  Rem - COORDINATE CONVERSION
2700  Rem
2710    Let S = R - (Sin(Q) * Sin(E))
2720    Let S = S / (Cos(Q) * Cos(E))
2730  Rem
2740  Rem - NULL PHENOMENON
2750  Rem
2760    Let Z = Abs(S)
2770    If Z <= 1 Then 2830
2780    Let V = 0
2790    Return



2800  Rem
2810  Rem - ADJUSTMENT
2820  Rem
2830    Let S = S / Sqr(-S * S + 1)
2840    Let S = -Atn(S) + A
2850    If I = 1 Then 2900
2860    Let S = D - S
2870  Rem
2880  Rem - LOCAL APPARENT TIME
2890  Rem
2900    Let Z = .0172028 * K
2910    Let T = S + P - Z - 1.73364
2920  Rem
2930  Rem - UNIVERSAL TIME
2940  Rem
2950    Let U = T + F
2960  Rem
2970  Rem - WALL CLOCK TIME
2980  Rem
2990    Let V = U - G
3000  Rem
3010  Rem - DECIMAL TO SEXAGESIMAL
3020  Rem
3030    Let Z = V
3040    GoSub 3200
3050    Let Z = Z * 3.81972
3060    Let V = Int(Z)
3070    Let W = (Z - V) * 60
3080    Let X = Int(W)
3090    Let Y = W - X
3100    If Y < .5 Then 3120
3110    Let X = X + 1
3120    If X < 60 Then 3150
3130    Let V = V + 1
3140    Let X = 0
3150    Let V = V + X / 100
3160    Return
3170  Rem
3180  Rem - NORMALIZATION
3190  Rem
3200    If Z >= 0 Then 3230
3210    Let Z = Z + D
3220    GoTo 3200
3230    If Z < D Then 3260
3240    Let Z = Z - D
3250    GoTo 3230
3260    Return
End Sub

Sub InitTimeZoneStuff ()
TZs% = 41
ReDim TZ$(TZs%)

TZ$(1) = "Bering Time (BST)  -11:00"
TZ$(2) = "Cook Islands Time (CIT)  -10:30"
TZ$(3) = "Hawaii/Alaska Time (HST)  -10:00"
TZ$(4) = "Marquesas Island Time (MIT)  -9:30"
TZ$(5) = "Yukon Time (YST)  -9:00"
TZ$(6) = "Pitcairn Island Time (PIT)  -8:30"
TZ$(7) = "Pacific Time (PST)  -8:00"
'TZ$(8) = "Pacific Daylight Time (PDT)  -7:00"
TZ$(8) = "Mountain Time (MST)  -7:00"
'TZ$(10) = "Mountain Daylight Time (MDT)  -6:00"
TZ$(9) = "Central Time (CST)  -6:00"
'TZ$(12) = "Central Daylight Time (CDT)  -5:00"
TZ$(10) = "Eastern Time (EST)  -5:00"
'TZ$(14) = "Eastern Daylight Time (EDT)  -4:00"
TZ$(11) = "Atlantic Time (AST)  -4:00"
'TZ$(12) = "Atlantic Daylight Time (AST)  -3:00"
TZ$(12) = "Guyana Time (GUY)  -3:45"
TZ$(13) = "Surinam Time (SNM)  -3:30"
TZ$(14) = "Newfoundland Time (NFT)  -3:30"
TZ$(15) = "Zone 3 West (W03)  -3:00"
TZ$(16) = "Zone 2 West (W02)  -2:00"
TZ$(17) = "Zone 1 West (W01)  -1:00"
TZ$(18) = "Greenwich Mean Time (GMT)   +0:00"
TZ$(19) = "Liberia Time (LIB)  +0:44"
TZ$(20) = "West European Time (WUT)  +1:00"
'TZ$(26) = "W. Europe Daylight Tm (WDT)  +2:00"
TZ$(21) = "East European Time (EUT)  +2:00"
TZ$(22) = "Zone 3 East (E03)  +3:00"
TZ$(23) = "Iran Time (IRA)  +3:30"
TZ$(24) = "Zone 4 East (E04)  +4:00"
TZ$(25) = "Afganistan Time (AFT)  +4:30"
TZ$(26) = "Zone 5 East (E05)  +5:00"
TZ$(27) = "India Time (IND)  +5:30"
TZ$(28) = "Zone 6 East (E06)  +6:00"
TZ$(29) = "Burma Time (BUR)  +6:30"
TZ$(30) = "Zone 7 East (E07)  +7:00"
TZ$(31) = "Malaysia Time (MAT)  +7:30"
TZ$(32) = "Zone 8 East (E08)  +8:00"
TZ$(33) = "West Australia Time (WAT)  +8:00"
TZ$(34) = "Zone 9 East (E09)  +9:00"
TZ$(35) = "Central Australia (CAT)  +9:30"
TZ$(36) = "Zone 10 East (E10)  +10:00"
TZ$(37) = "East Australia Time (EAT)  +10:00"
TZ$(38) = "Zone 11 East (E11)  +11:00"
TZ$(39) = "Eastern Ocean Time (EOT)  +11:30"
TZ$(40) = "Zone 12 East (E12)  +12:00"
TZ$(41) = "USSR Far East Zone (E13)  +13:00"

gLongitude = "073.60W"
gLatitude = "40.45N"
gLocation = "New York City, New York"
gTimezone = "EST"
gDSTAuto = "-1"
gDST = "0"


End Sub

Function SexagesimalToDecimal# (Z#)
Dim W#, X#, Y#
2010  Rem
2020  Rem - SEXAGESIMAL TO DECIMAL
2030  Rem
2040    Let W = 1
2050    If Z >= 0 Then 2080
2060    Let W = -1
2070    Let Z = Abs(Z)
2080    Let X = Z + .00005
2090    Let X = Int(Z)
2100    Let Z = (Z - X) * 100
2110    Let Y = Int(Z)
2120    Let Z = (Z - Y) * 100
2130    Let Z = (X + Y / 60 + Z / 3600) * W
SexagesimalToDecimal# = Z#
End Function

