
/*
     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* 
readlib.h
*/
   
#define DONE  -12 
#define TLLEN 20            /* tag-line-length */

#ifdef LOOSE
extern const char *FidoTag ;
extern const char *TagLine ;
#else
extern const char *const FidoTag ;
extern const char *const TagLine ;
#endif

extern  char  UserTag[] ;
extern  char  CurTag[] ;
extern  int   fido ;
extern  int   FirstDone;
extern  int   ScrnLines ;
extern  int   ScrnCols ;
extern  long  TruncNum ;
extern  char  qwklist[100];
extern  char  bltlist[100];
extern  char  speller[100];
extern  char  OrigTag[256]  ; 

struct fentry {
		char *findpt ;
		struct fentry *fnext ;
} ;

/* readlib.c */
void  MakeHomePath(void);
int   ReadConfig(void);
void  Clean(void);
char *fget(char *s, int n, FILE *fp);
int   GetConf(const int num);
void  QuoteMsg(const char *tmpname);
void  StripTag(const char *tmpname);
int   more(const int def);
int   YesNo(const int def, const char *prmt);
int   Chk4Rep(void);
void  PackReply(void);
void  Chk4Cnf(const char *tpath);
void  UpdateConf(int mode);
void  nprint(const byte *str, int len);
void  nfprint(FILE *fp, const byte *str, int len);
void  str2mem(char *mem, const char *str);
void  scpy(char *dest, const char *src, const int len);
void  view(const char *Path, const char *File);
void  tagview(const char *Path, const char *File);
void  merde(void);
int   Numeric(const char *str);
int   IsQuoted(const unsigned char c, const unsigned char *str);
void  Date(void);
void  EmptyMsg(void);
void  ShiftLeft(char *p1, const int n);
void  StripDel(char *tp);
void  Qlist(const char *cmdlist);
void  Blist(const char *cmdlist);
int findtxt(const char *fndargs, const int mode) ;
struct fentry *findstr( unsigned char *s1, unsigned char *s2, struct fentry **sptr) ;
struct fentry *hprint( byte *p,unsigned offst, unsigned len, struct fentry **bptr, int blen ) ;
int iso2dosup( byte *p);
/*------------------------ end of readlib.h --------------------------------*/
