/*

     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
   
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include "ansi.h"
#if defined(DJD) || defined(__TURBOC__)
#include "system.h"
#endif

extern int ansi ;            /* Will just return on ansi=0 */

#define ESC 27


void cls()               /* Clear screen & home cursor */
{
    if( ansi )
	printf("%c[2J%c[H",ESC,ESC);
#ifdef DJD
    else
	{ gotoxy(1,1); clrscr();}
#endif
#ifdef __TURBOC__
    else
        clrscr() ;
#endif

}
void clear()             /* Reset Attributes          */
{
    if( ansi )
	printf("%c[0m",ESC );
}
void high()              /* HigLitht  (or BoldFace )  */
{
    if( ansi )
	printf("%c[1m",ESC);
}
void blink()             /* blink mode                */
{
    if( ansi )
	printf("%c[5m",ESC);
}
#ifdef ATPUNUSED 
void deleol()            /* del to end of line        */
{
    if( ansi )
	printf("%c[K",ESC);
}
void reverse()           /* Revers video mode         */
{
    if( ansi )
	printf("%c[7m",ESC);
}

/*------------- Foreground colors ---------------------*/
void black()
{
    if( color && ansi )
	printf("%c[30m",ESC);
}
#endif
void red()
{
    if( color && ansi )
	printf("%c[31m",ESC);
}
void green()
{
    if( color && ansi )
	printf("%c[32m",ESC);
}
void yellow()
{
    if( color && ansi )
	printf("%c[33m",ESC);
}
void blue()
{
    if( color && ansi )
	printf("%c[34m",ESC);
}
void magenta()
{
    if( color && ansi )
	printf("%c[35m",ESC);
}
void cyan()
{
    if( color && ansi )
	printf("%c[36m",ESC);
}
void white()
{
    if( color && ansi )
	printf("%c[37m",ESC);
}

/*------------- BackGround colors ---------------------*/
void bblack()
{
    if( color && ansi )
	printf("%c[40m",ESC);
}
#ifdef ATPUNUSED 
void bred()
{
    if( color && ansi )
	printf("%c[41m",ESC);
}
void bgreen()
{
    if( color && ansi )
	printf("%c[42m",ESC);
}
void byellow()
{
    if( color && ansi )
	printf("%c[43m",ESC);
}
void bblue()
{
    if( color && ansi )
	printf("%c[44m",ESC);
}
void bmagenta()
{
    if( color && ansi )
	printf("%c[45m",ESC);
}
void bcyan()
{
    if( color && ansi )
	printf("%c[46m",ESC);
}
void bwhite()
{
    if( color && ansi )
	printf("%c[47m",ESC);
}
#endif

#ifdef ATPUNUSED 
/*----------- Cursor position ---------------------------*/

void locate( x , y )
int x, y;
{
    if(ansi)
	printf("%c[%d;%dH",ESC,y,x);
}

void up(nb)          /* Cursor Up default 1 */
int nb;
{
    if ( ansi )
    {
        if( ! nb ) nb = 1 ; 
        printf("%c[%dA",ESC,nb);
    }
}

void dn(nb)        /* Cursor down default 1 */
int nb;
{
    if ( ansi )
    {
        if( ! nb ) nb = 1 ;
        printf("%c[%dB",ESC,nb);
    }
}

void right(nb)        /* Cursor right default 1 */
int nb;
{
    if ( ansi )
    {
        if( ! nb ) nb = 1 ;
        printf("%c[%dC",ESC,nb);
    }
}

void left(nb)        /* Cursor left default 1 */
int nb;
{
    if ( ansi )
    {
        if( ! nb ) nb = 1 ;
        printf("%c[%dD",ESC,nb);
    }
}
#endif
/*-----------------------------------------------------------------------*/
