@echo off
@rem
@rem  IBM7855A.CMD by Rob Hamerling (see AT2.DOC file).
@echo Customise IBM 7855-010 modem for ASYNC (but leave it in SYNC mode)
@echo Modem must have been set in AT-commandset mode from the frontpanel!
@rem
@rem Change below AT2 into AT3 if you are using the OS/2 2.0 version of AT2
@rem and change portnumber into the appropriate value (2 for COM2 etc).
@rem Change phone number as desired.

@setlocal
set ATX=AT2
set port=1
set speed=19200
set phone=030-331888

@echo Modem is supposed to be on COM%port%:

@rem First see if the modem responds:
%ATX%  %port%  %speed%  Z
if errorlevel   1 @goto problem

@rem Then reset the modem to the factory settings:
%ATX%  %port%  ^&F1

@rem Now transmit the customisation commands:
%ATX% %port% B0 E0 L1 M0 Q0 V1 X4 S0=0
%ATX% %port% ^&AP8 ^&AL8 ^&B8N1 ^&C1 ^&D2 ^&I0 ^&L0 ^&M2 ^&R0 ^&S2 ^&X0 ^&Y0
%ATX% %port% \A3 \C0 \G0 \K2 \M14 \N3 \Q2 \R2 \T0 \V1 \X0
%ATX% %port% %%B0 %%C1 %%D0 %%E1 %%F1 %%G1 %%H1 %%I1 %%O1 %%R1 %%V0

@rem Time to store current configuration to both(!) NVM profiles
%ATX%  %port%  ^&W0 ^&W1

@rem Finally set the phone number to be auto-dialed in SYNC-mode.
%ATX%  %port%  ^&Z%phone%

goto exit

:problem
if errorlevel 255 @echo [rc=255] Is IBM 7855 modem connected to COM%port%?
if errorlevel 255 @goto exit
if errorlevel   1 @echo %ATX% has prematurely ended,
if errorlevel   1 @echo . . functionname and returncode indicate type of error.
if errorlevel   1 @goto exit

:exit
@endlocal
