#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "async.h"

extern  struct async_portS async_port[4];

int     main()
{
    char    ch;
    int     done = 0;
    char    block[1024];
    char    inblock[1024];
    int     ready, i, ii;

    window(1,2,80,25);
    clrscr();

    switch (async_detect_uart(COM1)) {
        case UART_NONE:
            printf("UART: None\n");
            break;
        case UART_8250:
            printf("UART: 8250\n");
            break;
        case UART_16460:
            printf("UART: 16460\n");
            break;
        case UART_16550:
            printf("UART: 16550\n");
            break;
        case UART_16550A:
            printf("UART: 16550A\n");
            break;
    }

    printf("IRQ: %d\n", async_detect_irq(COM1));

    open_port(COM1, 38400L, LCR_PNONE, 1, 8);

    while (!done) {
        if (async_ready(COM1)) {
            ii = 0;
            ready = async_getblock(COM1, inblock, 1024);
            while (ready--) {
                cprintf("%c", inblock[ii++]);
            }
        }

        if (kbhit()) {
            ch = getch();
            switch (ch) {
                case 0:
                    switch (getch()) {
                        case 59: //F1
                            set_parity(COM1, LCR_PEVEN);
                            set_wordlength(COM1, 7);
                            break;
                        case 60: //F2
                            set_parity(COM1, LCR_PNONE);
                            set_wordlength(COM1, 8);
                            break;
                        case 61: //F3
                            break;
                        case 62: //F4
                            break;
                        case 63: //F5
                            printf("Baud: 1200\n");
                            set_baudrate(COM1, 1200L);
                            break;
                        case 64: //F6
                            printf("Baud: 2400\n");
                            set_baudrate(COM1, 2400L);
                            break;
                        case 65: //F7
                            printf("Baud: 9600\n");
                            set_baudrate(COM1, 9600L);
                            break;
                        case 66: //F8
                            printf("Baud: 38400\n");
                            set_baudrate(COM1, 38400L);
                            break;
                        case 67: //F9
                            for (i=0; i<1024; i++) {
                                block[i] = 13;
                            }
                            async_putblock(COM1, block, 1024);
                            break;
                        case 68: //F10
                            done = 1;
                            break;
                    }
                    break;
                default:
                    async_putch(COM1, ch);
                    break;
            }
        }
    }

    close_port(COM1, 0, 0);

    return (0);
}

