unit Sugdialg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TSugDialog = class(TForm)
    NotWord: TEdit;
    SuggestList: TListBox;
    BtnReplace: TButton;
    BtnIgnore: TButton;
    BtnAdd: TButton;
    BtnSuggest: TButton;
    BtnCancel: TButton;
    WordEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    BtnIgnoreAll: TButton;
    BtnChangeAll: TButton;
    BtnPhoneme: TButton;
    procedure BtnSuggestClick(Sender: TObject);
    procedure BtnPhonemeClick(Sender: TObject);
    procedure BtnReplaceClick(Sender: TObject);
    procedure BtnIgnoreClick(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure SuggestListClick(Sender: TObject);
    procedure SuggestListDblClick(Sender: TObject);
    procedure BtnIgnoreAllClick(Sender: TObject);
    procedure BtnChangeAllClick(Sender: TObject);
    procedure WordEditKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    DictDataPtr : pointer;    { Pointer to internal dictionary data }
    MaxSuggest : byte;        { Maximum number of suggestions }
  end;

var
  SugDialog: TSugDialog;

implementation

{$R *.DFM}

uses BaseASpl;

procedure TSugDialog.BtnSuggestClick(Sender: TObject);
begin
  { Build a new list of suggestions using the CloseMatch routine }
  SuggestList.Items := BaseASpl.SuggestCloseMatch(DictDataPtr, WordEdit.Text, MaxSuggest);
end;

procedure TSugDialog.BtnPhonemeClick(Sender: TObject);
begin
  { Build a new list of suggestions using the Phoneme routine }
  SuggestList.Items := BaseASpl.SuggestPhoneme(DictDataPtr, WordEdit.Text, MaxSuggest);
end;


procedure TSugDialog.BtnReplaceClick(Sender: TObject);
begin
  ModalResult := 101;  { Close dialog and return value }
end;

procedure TSugDialog.BtnIgnoreClick(Sender: TObject);
begin
  ModalResult := 103;  { Close dialog and return value }
end;

procedure TSugDialog.BtnAddClick(Sender: TObject);
begin
  ModalResult := 102;  { Close dialog and return value }
end;

procedure TSugDialog.BtnCancelClick(Sender: TObject);
begin
  ModalResult := 100;   { Close dialog and return value }
end;

procedure TSugDialog.SuggestListClick(Sender: TObject);
begin
  { Make the word clicked in the listbox the selected word }
  WordEdit.Text := SuggestList.Items.Strings[SuggestList.ItemIndex];
end;

procedure TSugDialog.SuggestListDblClick(Sender: TObject);
begin
  { Get the double clicked word }
  WordEdit.Text := SuggestList.Items.Strings[SuggestList.ItemIndex];
  ModalResult := 101;   { Close dialog and return Replace's code }
end;

procedure TSugDialog.BtnIgnoreAllClick(Sender: TObject);
begin
  ModalResult := 104;  { Close dialog and return value }
end;

procedure TSugDialog.BtnChangeAllClick(Sender: TObject);
begin
  ModalResult := 105;  { Close dialog and return value }
end;

procedure TSugDialog.WordEditKeyPress(Sender: TObject; var Key: Char);
begin
  if key = #13 then
    ModalResult := 101;  { Treat ENTER in WordEdit as pressing the Change button }
end;

end.
