/* In.aspd Address Search Protocol Server (inetd version)                  */
/* Copyright (C) 1996 Stenio Brunetta                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of the GNU General Public License as published by   */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */  
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/*  Author's addresses:                                                    */
/*  email: brunetta@mbox.vol.it, stebrune@dsi.unive.it                     */
/*  smail: Stenio Brunetta                                                 */
/*         Via Bassini #17                                                 */
/*         Pordenone 33170                                                 */
/*         Italy                                                           */

static char rcsid[] = \
        "$Id: in.aspd.c,v 1.2.1 1996/06/27 21:45:41 ste Exp $";

#include <sys/types.h>	/* size_t				*/
#include <unistd.h>	/* gethostname				*/
#include <arpa/inet.h>	/* inet_ntoa				*/
#include <syslog.h>	/* openlog, syslog, closelog		*/
#include <sys/socket.h>	/* recvfrom, sendto			*/
#include <string.h>	/* strcmp, strcat, memset, strlen	*/
#include <stdio.h>	/* fprintf...				*/
#include <stdlib.h>	/* EXIT_FAILURE				*/
#include <errno.h>	/* errno stuff...			*/

#define MSGSIZE		64

extern int errno;

int main(int argc, char* argv[]){
  int in_stat;
  void parseCmdLine(int, char*[]);
  char rmesg[MSGSIZE], hname[MSGSIZE];
  char* GetAddress(struct sockaddr*);
  struct sockaddr from;
  size_t size;

  parseCmdLine(argc, argv);

  size = sizeof(from);
  
  memset(rmesg, 0, MSGSIZE);
  memset(hname, 0, MSGSIZE);

  openlog(argv[0], LOG_PID, LOG_NOTICE);

  /* MSGSIZE-1 force zero termination for syslog call */
  if((in_stat = recvfrom(0, rmesg, MSGSIZE-1, 0, &from, &size)) > 0){
    gethostname(hname, MSGSIZE);
    if(strcmp(hname, rmesg) == 0)
      sendto(1, hname, strlen(hname), 0, &from, size);
    
    syslog(LOG_PID | LOG_NOTICE, "%s searching for %s",
	   GetAddress(&from), rmesg);
  }

  if(in_stat == 0)
    syslog(LOG_PID | LOG_NOTICE, "%s checking connection",
           GetAddress(&from));

  if(in_stat == -1)
    syslog(LOG_PID | LOG_NOTICE, "recvfrom: %s",
           strerror(errno));

  closelog();  
  return 0;	
}

void About(){
  fprintf(stderr, "Copyright (C) 1996 Stenio Brunetta (aka xpanic)\n");
}

void parseCmdLine(int argc, char* argv[]){
  int c;
  while((c = getopt(argc, argv, "v")) != -1){
    switch(c){
    case 'v':
      if(argc > 2 || strcmp(argv[argc-1], "-v")){
	fprintf(stderr, "Use: %s\n"
		"     %s -v\n", argv[0], argv[0]);
	exit(EXIT_FAILURE);
      }
      else{
	About();
	printf("%s\n", rcsid);
	exit(EXIT_SUCCESS);
      }
      break;
    }
  }

  if(argc != 1){
    fprintf(stderr, "Use: %s\n"
	    "     %s -v\n", argv[0], argv[0]);
    exit(EXIT_FAILURE);
  } 
}

char* GetAddress(struct sockaddr* s){
  struct sockaddr_in* psAddress;

  psAddress = (struct sockaddr_in *) s;

  return inet_ntoa(*((struct in_addr *) &(psAddress->sin_addr)));
}
