/* Aspd Address Search Protocol Server                                     */
/* Copyright (C) 1996 Stenio Brunetta                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of the GNU General Public License as published by   */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */  
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/*  Author's addresses:                                                    */
/*  email: brunetta@mbox.vol.it, stebrune@dsi.unive.it                     */
/*  smail: Stenio Brunetta                                                 */
/*         Via Bassini #17                                                 */
/*         Pordenone 33170                                                 */
/*         Italy                                                           */

static char rcsid[] = \
           "$Id: aspd.c,v 1.2.1 1996/06/29 13:26:33 ste Exp $";

#include <sys/types.h>	/* size_t				*/
#include <unistd.h>	/* gethostname,	fork			*/
#include <syslog.h>	/* openlog, syslog			*/
#include <arpa/inet.h>	/* inet_ntoa				*/
#include <netdb.h>	/* getservbyname			*/
#include <netinet/in.h>	/* ntohs, htonl				*/
#include <sys/socket.h>	/* socket, bind, recvfrom, sendto	*/
#include <stdio.h>	/* perror				*/
#include <stdlib.h>	/* exit					*/
#include <string.h>	/* strcat, strcmp, memset		*/
#include <signal.h>	/* signal, raise			*/

#define MSGSIZE		64

int main (int argc, char *argv[]){ 
  int sock, make_dsocket(int), in_stat;
  void parseCmdLine(int, char*[]), handler(int);
  char* GetAddress(struct sockaddr*);
  struct sockaddr from;
  struct servent* psServent;
  char rmesg[MSGSIZE], hname[MSGSIZE];
  size_t size;
  pid_t cpid;

  parseCmdLine(argc, argv);

  size = sizeof(from);

  if((psServent = getservbyname("asp", "udp")) == NULL){
    fprintf(stderr, "getservbyname: Protocol not found\n");
    exit(EXIT_FAILURE);
  }
  
  sock = make_dsocket(ntohs(psServent->s_port));

  if((cpid = fork()) != 0) /* parent */
    if(cpid == -1){
      perror("fork");
      exit(EXIT_FAILURE);
    }else exit(EXIT_SUCCESS);

  signal(SIGTERM, handler);
  signal(SIGHUP, handler);
  signal(SIGINT, handler);

  memset(hname, 0, MSGSIZE);
  gethostname(hname, MSGSIZE);

  openlog(argv[0], LOG_PID, LOG_NOTICE);
  syslog(LOG_PID | LOG_NOTICE, "Started");

  while(1){
    /* pulisce il buffer prima di ogni messaggio */
    memset(rmesg, 0, MSGSIZE);
    /* force zero-termination for syslog call */
    if((in_stat = recvfrom(sock, rmesg, MSGSIZE-1, 0, &from, &size)) == -1)
      syslog(LOG_PID | LOG_ERR, "recvfrom: %s",
	     strerror(errno));
    
    if(in_stat == 0){
      syslog(LOG_PID | LOG_NOTICE, "%s checking connection",
	     GetAddress(&from));
      continue;
    }else syslog(LOG_PID | LOG_NOTICE, "%s searching for %s",
		 GetAddress(&from), rmesg);

    if(strcmp(hname, rmesg) == 0)
      if(sendto(sock, hname, strlen(hname), 0, &from, size) == -1)
	syslog(LOG_PID | LOG_ERR, "sendto: %s", strerror(errno));

  }
}

void handler(int sig){
  syslog(LOG_PID | LOG_NOTICE, "%s", strsignal(sig));
  raise(sig);
}

int make_dsocket(int port){
  int sock ;
  struct sockaddr_in name;

  /* Crea il socket */
  sock = socket(PF_INET, SOCK_DGRAM, 0);
  if (sock < 0){
    perror("socket");
    exit(EXIT_FAILURE);
  }

  /* Assegna il nome al socket */
  name.sin_family = AF_INET;
  name.sin_port = htons(port);
  name.sin_addr.s_addr = htonl(INADDR_ANY);
  if(bind(sock, (struct sockaddr *)&name, sizeof(name)) < 0){
    perror("bind");
    exit(EXIT_FAILURE);
  }

  return sock;
}

void About(){
  fprintf(stderr, "Copyright (C) 1996 Stenio Brunetta (aka xpanic)\n");
}

void parseCmdLine(int argc, char* argv[]){
  int c;
  while((c = getopt(argc, argv, "v")) != -1){
    switch(c){
    case 'v':
      if(argc > 2 || strcmp(argv[argc-1], "-v")){
	fprintf(stderr, "Use: %s\n"
		"     %s -v\n", argv[0], argv[0]);
	exit(EXIT_FAILURE);
      }
      else{
	About();
	printf("%s\n", rcsid);
	exit(EXIT_SUCCESS);
      }
      break;
    }
  }

  if(argc != 1){
    fprintf(stderr, "Use: %s\n"
	    "     %s -v\n", argv[0], argv[0]);
    exit(EXIT_FAILURE);
  } 
}

char* GetAddress(struct sockaddr* s){
  struct sockaddr_in* psAddress;

  psAddress = (struct sockaddr_in *) s;

  return inet_ntoa(*((struct in_addr *) &(psAddress->sin_addr)));
}
