/* Asp Address Search Protocol Client                                      */
/* Copyright (C) 1996 Stenio Brunetta                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of the GNU General Public License as published by   */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */  
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/*  Author's addresses:                                                    */
/*  email: brunetta@mbox.vol.it, stebrune@dsi.unive.it                     */
/*  smail: Stenio Brunetta                                                 */
/*         Via Bassini #17                                                 */
/*         Pordenone 33170                                                 */
/*         Italy                                                           */

static char rcsid[] = \
   "$Id: asp.c,v 1.2.1 1996/07/08 07:02:34 ste Exp $";

#include <sys/types.h>	/* socket			*/
#include <sys/time.h>	/* input_timeout stuff...	*/
#include <unistd.h>	/* getopt stuff...		*/
#include <sys/socket.h>	/* socket			*/
#include <netinet/in.h>	/* htons			*/
#include <arpa/inet.h>	/* inet_aton			*/
#include <stdio.h>	/* file operations...		*/
#include <stdlib.h>	/* exit, atoi			*/
#include <string.h>	/* strncmp			*/
#include <ctype.h>	/* isgrap, ispace, isdigit	*/
#include <limits.h>	/* INT_MAX			*/
#include <errno.h>	/* errno stuff...		*/

#define MSGSIZE	64

#ifndef TEMP_FAILURE_RETRY
#define TEMP_FAILURE_RETRY(EXPR) (EXPR)
#endif

extern int errno;
int tWait = 10;
int port = 27374;
char host2find[MSGSIZE];

int main(int argc, char *argv[]){ 
  int sock, in_stat, out_stat, in = 0, sent = 0, bad = 0, len;
  int input_timeout(int, unsigned int);
  int NextIp(char[16]);
  void parseCmdLine(int, char*[]);
  char host2try[16], *GetAddress(struct sockaddr*);
  struct sockaddr_in nomesocket;
  struct sockaddr from;
  struct in_addr indirizzo_p;
  char buf[MSGSIZE];
  size_t size, size_errno;

  parseCmdLine(argc, argv);

  size = sizeof(from);
  size_errno = sizeof(errno);
  len = strlen(host2find);

  /* Crea la socket */
  if((sock = socket(PF_INET, SOCK_DGRAM, 0)) == -1){
    perror("socket");
    exit(EXIT_FAILURE);
  }
      
  /* Setta i dettagli della socket remota */
  nomesocket.sin_family=AF_INET;    /* Tipo della socket remota      */
  nomesocket.sin_port=htons(port);  /* Porta della socket remota     */
  
  while((in_stat = NextIp(host2try)) > 0){
    in = 1;
    sent++;
    
    if(!inet_aton(host2try, &indirizzo_p)){
      perror("address");
      exit(EXIT_FAILURE);
    }
    
    /* Indirizzo della socket remota */
    nomesocket.sin_addr = indirizzo_p; 

    /* Spedisce il nome dell'host da cercare */
    out_stat = sendto(sock, host2find, len, 0,
		      (struct sockaddr *)&nomesocket, sizeof(nomesocket));
    if(out_stat == -1)
      if(errno == ECONNREFUSED){ /* Connection refused */

	/* resetta eventuali errori sulla socket */
        getsockopt(sock, SOL_SOCKET, SO_ERROR, &errno, &size_errno);

        /* riinvia il messaggio */
        out_stat = sendto(sock, host2find, len, 0,
			  (struct sockaddr *)&nomesocket, sizeof(nomesocket));

	bad++;
      }else{
	perror("sendto");
	exit(EXIT_FAILURE);
      }
  }

  /* esce se tutti i messaggi inviati hanno
     otteneuto un Connection refused */
  out_stat = sendto(sock, "", 0, 0,
		    (struct sockaddr *)&nomesocket, sizeof(nomesocket));
  if(out_stat == -1 && errno == ECONNREFUSED){
    if(bad == sent-1 || sent == 1){
      perror("sendto");
      exit(EXIT_FAILURE);
    }
  }
  
  /* input errato */
  if(in_stat == -1){
    fprintf(stderr, "NextIp: malformed address\n");
    exit(EXIT_FAILURE);
  }
  
  /* nel caso non sia stato passato nessun indirizzo */
  if(!in) exit(EXIT_FAILURE);
  
  /* Aspetta finche` non arriva la risposta o finche` scadono */
  /* i tWait secondi                                          */
  while((in_stat = input_timeout(sock, tWait)) == 1){
    /* e' arrivato qualcosa... */
    if(recvfrom(sock, buf, len, 0, &from, &size) != len)
      continue; /* probabile indisponibilita` della porta */

    /* arrivano risposte che non seguono il protocollo */
    if(strncmp(host2find, buf, len) != 0)
       continue;

    printf("Host %s found at address %s\n",
	   host2find, GetAddress(&from));

    close(sock);
    return EXIT_SUCCESS;
  }
  
  if(in_stat == 0)
    fprintf(stderr, "Host not found\n");
  else perror("Transmission");
  
  return EXIT_FAILURE;
}

int input_timeout(int filedes, unsigned int seconds){
  fd_set set;
  struct timeval timeout;
  
  /* Initialize the file descriptor set. */
  FD_ZERO (&set);
  FD_SET (filedes, &set);
  
  /* Initialize the timeout data structure. */
  timeout.tv_sec = seconds;
  timeout.tv_usec = 0;
  
  /* `select' returns 0 if timeout, 1 if input available, -1 if error. */
  return  TEMP_FAILURE_RETRY(select (FD_SETSIZE,
				     &set, NULL, NULL,
				     &timeout));
}

void About(){
  fprintf(stderr, "Copyright (C) 1996 Stenio Brunetta (aka xpanic)\n");
}

void parseCmdLine(int argc, char* argv[]){
  int c, Check(char*, int, int, int*);
  while((c = getopt(argc, argv, "vw:p:")) != -1){
    switch(c){
    case 'v':
      if(argc > 2 || strcmp(argv[argc-1], "-v")){
	fprintf(stderr, "Use: %s [-w wait_time] [-p port] hostname\n"
		"     %s -v\n", argv[0], argv[0]);
	exit(EXIT_FAILURE);
      }
      else{
	About();
	printf("%s\n", rcsid);
	exit(EXIT_SUCCESS);
      }
      break;
    case 'w':
      if(Check(optarg, 0, INT_MAX, &tWait) != 0){
	fprintf(stderr, "bad wait_time number\n");
	exit(EXIT_FAILURE);
      };
      break;
    case 'p':
      if(Check(optarg, 0, 65535, &port) != 0){
	fprintf(stderr, "bad port number\n");
	exit(EXIT_FAILURE);
      }
      break;
    default:
      fprintf(stderr, "Use: %s [-w wait_time] [-p port] hostname\n"
	      "     %s -v\n", argv[0], argv[0]);
      exit(EXIT_FAILURE);
      break;
    }
  }
  
  if(optind == argc-1){
    memset(host2find, 0, MSGSIZE);
    memcpy(host2find, argv[optind], MSGSIZE);
  }
  else{
    fprintf(stderr, "Use: %s [-w wait_time] [-p port] hostname\n"
	    "     %s -v\n", argv[0], argv[0]);
    exit(EXIT_FAILURE);
  } 
}

int Check(char* sz, int min, int max, int* dest){
  char* endp;
  long l;
  
  errno = 0;
  l = strtol(sz, &endp, 10);
  
  if(errno == ERANGE ||
     strcmp(endp, "") != 0 ||
     l < min || l > max) return -1;
  
  *dest = l;
  
  return 0;
}

char* GetAddress(struct sockaddr* s){
  struct sockaddr_in* psAddress;

  psAddress = (struct sockaddr_in *) s;

  return inet_ntoa(*((struct in_addr *) &(psAddress->sin_addr)));
}

int NextIp(char buffer[16]){
  int c, i = 0, i1 = 0, index = 0, cPoint = 0, cDigit = 0;
  char buffer1[16];
  static end = 0;

  if(end != 0) return 0;

  /* salta gli spazi bianchi */
  while(!isgraph(c = getchar()))
    if(c == EOF){
      end = 1;
      return 0;
    }
  ungetc(c, stdin);

  memset(buffer, 0, 16);

  while((c = getchar()) != EOF && index < 15)
    if(isdigit(c))
      if(cDigit < 3 ){
	buffer[index++] = c;
	cDigit++;
      }
      else return -1;
    else
      if(c == '.' && cDigit != 0)
	if(cPoint < 3){
	  buffer[index++] = c;
	  cDigit = 0;
	  cPoint++;
	}else return -1;
      else
	if(cDigit != 0 && cPoint == 3) 
	  break;
	else return -1;

  if(!isspace(c))
    if(c == EOF) end = 1;
    else return -1;

  if(cPoint != 3 || cDigit == 0) return -1;

  strcpy(buffer1, buffer);
  
  if((i = atoi(strtok(buffer1, "."))) < 0 || i > 255)
    return -1;

  for(i1=0; i1<3; i1++)
    if((i = atoi(strtok(NULL, "."))) < 0 || i > 255)
      return -1;
  
  return 1;
}
