page ,132 ;
title RAMADE - Initialize DOS memory to use segments A,D and E
comment *
Ŀ
           Name: ramade                                                       
                                                                              
       Function: This program enables the utilization of 192 k of RAM in      
                 addition to the 640 k normal maximum for a PC.  The          
                 additional RAM must be installed at segment addresses A000,  
                 D000 and E000.  The 64k of RAM in segment A is contiguous    
                 with the normal 640k and is used simply by extending the     
                 memory size above 640.  The 128k in segments D and E is not  
                 contiguous with the rest of RAM.  It is used for loading     
                 various resident extensions, thus freeing up RAM in the main 
                 area (0-704k).                                               
                                                                              
    Description: The memory size is set to the end of segment E by resetting  
                 the bios memory size and rebooting.  Storage in segments A,  
                 D and E is tested and cleared.  Miscompares are detected,    
                 but no attempt is made to handle the more common case of     
                 parity checks during the test.                               
                                                                              
                 Resident extensions are loaded in segments D and E by a      
                 secondary command processor which is invoded by RAMADE.      
                 After issuing a SETBLOCK function call to free the 128 K     
                 bytes in segments D and E, RAMADE invokes the secondary      
                 command processor with a command of 'AUTOLOAD'.  This should 
                 be a bat file which contains the commands to load the        
                 resident extensions.                                         
                                                                              
                 After loading the resident extensions, RAMADE issues other   
                 memory management function calls which leave segments B and  
                 C allocated and free up unused memory below segment B.       
                                                                              
                 In addition, the warm boot flag in low storage is reset.     
                 The system bios sets this flag when doing a ctl-alt-del      
                 reset, but never clears it, apparently relying on power      
                 dropping to clear the area.  (I've recently installed 256k   
                 chips on my system board, and after this installation,       
                 sometimes my system was warm booting when it should have     
                 been cold booting after turning the power off briefly.)      

*
page
comment *
Ŀ
         Inputs: Memory size word in low storage                              
                                                                              
        Outputs: Memory size word in low storage                              
                 Reset flag word in low storage                               
                                                                              
   Return Codes: First entry - none, exit via reboot.                         
                 Second entry - always 0.                                     
                                                                              
   Dependancies: Low storage areas - see lowstg segment.                      
                 GWASMC macros.                                               
                 Assumes 832 k installed as described above.                  
                 AUTOLOAD bat file invoked.                                   
                                                                              
  Entry Linkage: Standard COM module invocation                               
                                                                              
   Exit Linkage: Int 21 function 31 (terminate and remain resident)           
                 or reboot via int 19.                                        
                                                                              
 Change History: Ver  0.00   10/26/85   Under development                     
                      1.00   11/03/85   First release                         
                      1.10   11/05/85   Changed address equates to table      
                      1.20   06/25/86   Save/restore regs around exec cmd     
                                        processor for DOS 2.1 bug             
                      1.21   12/05/86   Zap mem alloc table from "M" to "Z"   
                                        This make DOS forget about discontig. 

*
page
;
; Get Macros and other standard setups
;Ŀ
if1                                    ;
include gwasmc.mac                     ;
endif                                  ;
.radix   16                            ;
                                       ;
;
; Map low storage
;Ŀ
lowstg   segment  at 0                 ;
         org      413                  ;
mem_size dw                            ; Memory size in K, set by bios and us
         org      472                  ;
rst_flag dw                            ; Reset flag - set to 1234 by bios to
                                       ; indicate warm boot in process.
lowstg   ends                          ;
                                       ;
page
;
; Global data segment entries and equates
;Ŀ
cgroup   group    codeseg,dataseg      ;
dataseg  segment  'data'               ;
                                       ;
         db       'RAMADE  1.21 - IBM Internal Use Only ',0dh,0a
         db       'Cornell Wright - WRIGHT at PKEDVM8 ',0dh,0a
                                       ;
                                       ;
if ($-dataseg) mod 10h                 ; align to paragraph boundry
         org      ($-dataseg)+10h-(($-dataseg) mod 10h)
endif                                  ;
                                       ;
         db       'ADDR TAB'           ;
mconend  dw       0b000          ; +00   End of contiguous memory (para addr)
mdissta  dw       0d000          ; +02   Start of discontiguous memory
mdisend  dw       0f000          ; +04   End of discontiguous memory
                                 ;
mseg1    dw       0a000          ; +06   First segment to clear and test
mseg1l   dw       08000          ; +08   First segment length in words
                                 ;
mseg2    dw       0d000          ; +0a   Second  "           "
mseg2l   dw       08000          ; +0c     "     "           "
                                 ;
mseg3    dw       0e000          ; +0e   Third   "           "
mseg3l   dw       08000          ; +10     "     "           "
                                       ;
dataseg  ends                          ;
;
; PSP
;Ŀ
codeseg  segment  'code'               ;
psp      label    byte                 ; Program Segment Prefix
pspint   dw       ?                    ; Int 20H for return
         org      2c                   ;
pspenv   dw       ?                    ; Segment address of the Environment
         org      80                   ;
pspparm  db       80 dup(?)            ; Input parameters
         ORG      80                   ;
pspparmn db       ?                    ; Number of Characters
pspparmt db       7f dup(?)            ; Text of input parameters
                                       ;
page
;
; Entry - clear reset flag & check for pass a or b.
;Ŀ
         assume   cs:cgroup,ds:cgroup,es:cgroup,ss:cgroup
entry:                                 ;
         dosentry COMPGM               ;
         xor      ax,ax                ; get addressability to lowstg
         mov      ds,ax                ;
         assume   ds:lowstg            ;
                                       ;
         mov      rst_flag,0000        ; clear reset flag
                                       ;
         mov      ax,mdisend           ; compare memory size to end
         mov      cl,6                 ; convert from seg addr to number of k
         shr      ax,cl                ;
         cmp      ax,mem_size          ;
         ljmp     e,pass_b             ; it's equal - this is the second pass
                                       ;
                                       ;
;
; Pass A - adjust memory size, test and clear extra ram, reboot
;Ŀ
pass_a:                                ;
         mov      mem_size,ax          ; set memory size to end
                                       ;
         mov      ax,cs                ; reestablish ds
         mov      ds,ax                ;
         assume   ds:cgroup            ;
                                       ;
         mov      ax,mseg1             ; test and clear segments a,d & e
         mov      bx,mseg1l            ;
         call     testmem              ;
         mov      ax,mseg2             ;
         mov      bx,mseg2l            ;
         call     testmem              ;
         mov      ax,mseg3             ;
         mov      bx,mseg3l            ;
         call     testmem              ;
                                       ;
         int      19                   ; reboot
                                       ;
page
;
; Testmem - checkout memory area pointed to by ax, word len in bx
;Ŀ
testmem  proc                          ;
                                       ;
dataseg  segment                       ;
testmsg  db       'RAMADE00 - Testing RAM in segment '
segchar  db                            ;
         db       '000.',0dh,0ah,'$'   ;
dataseg  ends                          ;
                                       ;
         cmp      bx,0                 ; if count 0, get out
         jne      continue             ;
         ret                           ;
                                       ;
continue:push     es                   ; save es
         mov      es,ax                ;
                                       ;
         mov      cl,0c                ; Convert seg addr to ascii
         shr      ax,cl                ;   and write message.
         cmp      al,09                ;
         jle      noadj                ;
         add      al,7                 ;
noadj:   add      al,30                ;
         mov      segchar,al           ;
         wto      testmsg              ;
                                       ;
         cld                           ; test and clear memory segment
                                       ;
         mov      ax,05a6dh            ; pattern = 5A6D
         mov      di,0                 ;
         mov      cx,bx                ;
         rep      stosw                ;
         mov      di,0                 ;
         mov      cx,bx                ;
         repe     scasw                ;
         jne      miscomp              ;
                                       ;
         mov      ax,0a55ah            ; pattern = A55A
         mov      di,0                 ;
         mov      cx,bx                ;
         rep      stosw                ;
         mov      di,0                 ;
         mov      cx,bx                ;
         repe     scasw                ;
         jne      miscomp              ;
                                       ;
         mov      ax,06da5h            ; pattern = 6DA5
         mov      di,0                 ;
         mov      cx,bx                ;
         rep      stosw                ;
         mov      di,0                 ;
         mov      cx,bx                ;
         repe     scasw                ;
         jne      miscomp              ;
                                       ;
         mov      ax,0000              ; clear to 0000
         mov      di,0                 ;
         mov      cx,bx                ;
         rep      stosw                ;
                                       ;
         pop      es                   ;
         ret                           ;
                                       ;
miscomp: pop      es                   ;
         jmp      errmc                ;
                                       ;
testmem  endp                          ;
                                       ;
page
;
; Pass B - free discontiguous memory, load resident pgms and free remaining ram.
;Ŀ
pass_b:                                ;
         push     es                   ; reestblish local data segment
         pop      ds                   ;
         assume   ds:cgroup            ;
         mov      bx,mdissta           ; Issue SETBLOCK to free memory in
         mov      ax,es                ; discontiguous area
         sub      bx,ax                ;
         setblock ,,errsb1             ;
;
; Find COMSPEC= in environment
;Ŀ
dataseg  segment                       ;
scanfor  db       'COMSPEC='           ; environment string to scan for
scanfore equ      $                    ;
scanlen  equ      scanfore-scanfor     ; length of scanfor
dataseg  ends                          ;
                                       ;
         cld                           ;
         mov      al,0                 ;
         mov      di,0                 ;
         mov      es,pspenv            ; es:di points to environment
         assume   es:nothing           ;
envloop: mov      si,offset cgroup:scanfor; ds:si points to string to match
         mov      cx,scanlen           ;
         repe     cmpsb                ; scan for a match
         je       found                ; if equal, we found it
         sub      di,1                 ; no - look for end of string (00)
         mov      cx,0ffff             ;
         repne    scasb                ; find 1st 0 at or after miscompare
         cmp      es:byte ptr[di],0    ; if followed by another 0 then at end
         jne      envloop              ; not 0 - go check next string
         jmp      errnocs              ; err msg & get out
                                       ;
found:   push     es                   ; swap es & ds so es:di points to string
         push     ds                   ;
         pop      es                   ;
         pop      ds                   ;
         assume   ds:nothing,es:cgroup ;
         mov      dx,di                ;
page
;
; Invoke command.com to run autoload.bat
;Ŀ
dataseg  segment                       ;
loadcmd  db       loadcmde-loadcmd-1   ; cmd string for 2ndary cmd processor
         db       '/c autoload',0dh;   ;
loadcmde equ      $                    ;
                                       ;
lcb      label    byte                 ; load control block
lcbenv   dw       0                    ; address of passed environment
lcbcmd   dd                            ; address of command string
lcbfcb1  dd       0                    ; address of fcb1
lcbfcb2  dd       0                    ; address of fcb2
dataseg  ends                          ;
                                       ;
         mov      bx,offset cgroup:lcb ;
         mov      lcbcmd,offset cgroup:loadcmd
         mov      lcbcmd+2,es          ;
         mov      al,0                 ;
         doscall  4bh                  ;
                                       ;
         mov      ax,cs                ; restore seg regs for dos 2.1 bug
         mov      ss,ax                ;
         mov      ds,ax                ;
         mov      es,ax                ;
         assume   cs:cgroup,ds:cgroup,es:cgroup,ss:cgroup
                                       ;
         ljmp     c,errexec            ; check for error
;
; Free and reallocate 'missing' ram
;Ŀ
                                       ;
         mov      bx,mconend           ; Issue SETBLOCK to free memory in
         mov      ax,es                ; missing area
         sub      bx,ax                ;
         dec      bx                   ;
         setblock ,,errsb2             ;
                                       ;
         mov      bx,mdissta           ; Issue GETBLOCK to reallocate
         sub      bx,mconend           ; missing area
         getmain  ,,errgm              ;
         cmp      ax,mconend           ;
         ljmp     ne,errwrad           ;
                                       ;
         freemain pspenv               ; free environment
                                       ;
         push     es                   ;
         mov      ax,ds                ; set es to segment of mem alloc block
         sub      ax,1                 ;
         mov      es,ax                ;
         cmp      byte ptr es:[0],byte ptr "M"
         ljmp     ne,errnotm           ; if the first char is a "M", set to
         mov      es:byte ptr[0],"Z"   ; the discontiguous memory.
         pop      es                   ;
                                       ;
         dosexit  ,0                   ; terminate & remain resident, but free
                                       ; entire pgm area.
                                       ;
page
;
; Error messages and exit
;Ŀ
errmc:                                 ;
         wto      'RAMADE01: Error - storage miscompare.'
         jmp      exit                 ;
errsb1:                                ;
         wto      'RAMADE02: Error - from 1st SETBLOCK.'
         jmp      exit                 ;
errnocs:                               ;
         wto      'RAMADE03: Error - COMSPEC= not found.'
         jmp      exit                 ;
errexec:                               ;
         wto      'RAMADE04: Error - from EXEC.'
         jmp      exit                 ;
errsb2:                                ;
         wto      'RAMADE05: Error - from 2nd SETBLOCK.'
         jmp      exit                 ;
errgm:                                 ;
         wto      'RAMADE06: Error - from GETMAIN.'
         jmp      exit                 ;
errwrad:                               ;
         wto      'RAMADE07: Error - wrong address returned by GETMAIN.'
         jmp      exit                 ;
errnotm:                               ;
         wto      'RAMADE08: Error - memory alloc block not found.'
         jmp      exit                 ;
page
;
; Exit
;Ŀ
         dosexit  exit                 ;
codeseg  ends                          ;
         end      entry                ;
                                       ;
