         NAME      PMODE
         PAGE      58,132
         TITLE     '        P M O D E   ---  SET LPT1: print options'





COMMENT  /*

   UTILITY TO SET PRINTER (LPT1: PRN) MODES ON IBM PERSONAL COMPUTER

  PMODE is a DOS command (P.COM) which will set frequently used printer
  options on the EPSON MX-80 or MX-100 printer. Only those options that
  I frequently desire are set in order to keep the size of the command
  within 256 bytes, which allows it to fit within one cluster on my RAM
  drive. For the same reason, only one single character keyword option
  may be specified with each execution. You can however issue the
  command multiple times to achieve complimentary results, if they are
  allowed by the printer.

  Only the default printer may be set with this version. Other printers
  may be selected by changing the value in the DH reg just prior to the
  INT 17 in the PRTIO subroutine.

  Other options can be easily added if you keep the keyword to a single
  unique letter of a thru z.

  Due to size no ERROR RECOVERY is performed. If the printer is turned
  off or not ready nothing will happen. The bell is rung with each
  successful execution, (except top of form) to let you know the IO was
  performed.

  I renamed the command to P.COM for easy of execution but you can call
  it whatever you like.






         */
         PAGE


COMMENT  /*


  FORMAT:

    P option

  OPTION:

          T - Eject to next top of form

          B - Ring the bell. Helpful to detect if the printer is ready.

          C - Turn on COMPRESSED print (not valid with EMPHASIZED).

          D - Turn on DOUBLE STRIKE mode.

          E - Turn on EMPHASIZED mode (not valid with COMPRESSED mode).

          N - Turn off automatic skip over perforation.

          S - Set automatic skip over perforation to 6 lines.

          R - RESET printer to power up specifications.

          6 - Set printer spacing to 6 lines per inch.

          8 - Set printer spacing to 8 lines per inch.


  EXAMPLE:

   p n      - Turn off automatic skip over perforation.

   p d      - Turn on double strike.



   (C)Copyright September 1983:

   Timothy M. Hanes               (713) 350-1438

   ASYST Inc.                     (713) 776-9091
   7502 Corporate Dr. Suite 237
   Houston, Tx. 77036

                                                                     */
         PAGE



;**********************
;*       EQUATES      *
;**********************


INPUT    EQU       080H           ;address of command tail
                                  ;buffer (set up by DOS)
BELL     EQU       07H            ;EPSON buzzer
BLANK    EQU       20H            ;ASCII blank code
COMP     EQU       0FH            ;EPSON compressed
CR       EQU       0DH            ;ASCII carriage return
DBLSTK   EQU       47H            ;EPSON double strike
EMPHSIZ  EQU       45H            ;EPSON emphasize
ESC      EQU       1BH            ;ASCII escape code
LF       EQU       0AH            ;ASCII line feed
LPI_6    EQU       32H            ;EPSON 6 lines per inch
LPI_8    EQU       30H            ;EPSON 8 lines per inch
NSOP     EQU       4FH            ;EPSON no skip over perf
RESET    EQU       40H            ;EPSON reset to power up state
SOP      EQU       4EH            ;EPSON skip over perf
TOF      EQU       0CH            ;EPSON advance to top of form

MASK_DF  EQU       11011111B      ;mask to AND lower case to upper case
         PAGE



CSEG     SEGMENT   BYTE
         ASSUME    CS:CSEG,DS:CSEG
         ORG       100H



PMODE:                            ;
         MOV       DI,OFFSET INPUT ;initialize DI to the
                                  ;address of the input buffer
         MOV       AL,[DI]        ;check if any command tail
         OR        AL,AL          ;and if not
         JZ        NODATA         ;go set no input msg
         MOV       AL,BLANK       ;load ASCII blank for scan
         INC       DI             ;increment address in DI
                                  ;past the input count byte
         MOV       CX,80          ;scan max of 80 chars.
         CLD                      ;clear direction flag
         REPZ SCASB               ;look for first non-blank
                                  ;character in input buffer
         JZ        NODATA         ;if none found set no input msg
         XOR       AX,AX          ;zero  AX
         XOR       DX,DX          ;zero  DX
                                  ;load the non-blank char.,
         MOV       DL,-1[DI]      ;use offset 0f -1 since DI
                                  ;will be pointing past it
         CMP       DL,CR          ;if first non-blank char was CR
         JE        NODATA         ;set no input msg

         CMP       DL,'a'         ;compare for lower case a
         JB        SELECT         ;go select if < a
         CMP       DL,'z'         ;compare for lower case z
         JA        SELECT         ;go select if > z
         AND       DL,MASK_DF     ;change lower case to upper case

         PAGE

SELECT:                           ;select the input character
         CMP       DL,'T'         ;was it upper case "T"
         JNE       NOT_T          ;no, go check for next character
SETTOF:  MOV       AL,TOF         ;insert printer code
         JMP       SHORT SENDCODE ;go do printer io

NOT_T:                            ;check input character

         CMP       DL,'C'         ;was it upper case "C"
         JNE       NOT_C          ;no, go check for next character
SETCOMP: MOV       AL,COMP        ;insert printer code
         JMP       SHORT SENDCODE ;go do printer io

NOT_C:                            ;check input character

         CMP       DL,'D'         ;was it upper case "D"
         JNE       NOT_D          ;no, go check for next character
SETDBL:  MOV       AL,DBLSTK      ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_D:                            ;check input character

         CMP       DL,'E'         ;was it upper case "E"
         JNE       NOT_E          ;no, go check for next character
SETEMPH: MOV       AL,EMPHSIZ     ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_E:                            ;check input character

         CMP       DL,'N'         ;was it upper case "N"
         JNE       NOT_N          ;no, go check for next character
SETNSOP: MOV       AL,NSOP        ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_N:                            ;check input character

         CMP       DL,'S'         ;was it upper case "S"
         JNE       NOT_S          ;no, go check for next character
SETSOP:  MOV       AL,SOP         ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_S:                            ;check input character

         CMP       DL,'R'         ;was it upper case "R"
         JNE       NOT_R          ;no, go check for next character
SETRSET: MOV       AL,RESET       ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_R:                            ;check input character

         CMP       DL,'6'         ;was it "6"
         JNE       NOT_6          ;no, go check for next character
SETLPI6: MOV       AL,LPI_6       ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_6:                            ;check input character

         CMP       DL,'8'         ;was it "8"
         JNE       NOT_8          ;no, go check for next character
SETLPI8: MOV       AL,LPI_8       ;insert printer code
         JMP       SHORT ESC1ST   ;go do printer io

NOT_8:                            ;check input character

         CMP       DL,'B'         ;was it upper case "B"
         JE        RINGBELL       ;yes go ring the the bell

;        all other codes come thru here and are invalid

NODATA:                           ;no input data
         MOV       DX,OFFSET MSG1 ;set msg and
                                  ;print the message whose
                                  ;address is in reg DX
PRTMSG:  MOV       AH,9           ;function 9 = print string
         INT       21H            ;call DOS to print
         JMP       SHORT EXIT     ;and exit back to DOS

ESC1ST:                           ;send escape code first
         PUSH      AX             ;save AX
         MOV       AL,ESC         ;move in ASCII 27 escape code
         CALL      PRTIO          ;perform DOS print function
         POP       AX             ;recover AX, contains prt code

SENDCODE:                         ;printer output routine
         CALL      PRTIO          ;perform DOS print function
         CMP       DL,'S'         ;if option  "S"
         JNE       RINGBELL       ;no, ring the bell
         MOV       AL,6           ;set SOP to 6 lines
         CALL      PRTIO          ;perform DOS print function

RINGBELL:                         ;notify user of seccessful IO
         CMP       DL,'T'         ;if option  "T"
         JE        CR_            ;dont ring the bell
         MOV       AL,BELL        ;move in ASCII 7 bell code
         CALL      PRTIO          ;perform DOS print function
CR_:                              ;send carriage return
         CMP       DL,'R'         ;if option  "R"
         JE        EXIT           ;dont send CR
         MOV       AL,CR          ;send CR
         CALL      PRTIO          ;perform DOS print function

EXIT:                             ;
         INT       20H            ;return to DOS
         PAGE



;**********************
;*  CLOSED ROUTINES   *
;**********************



;**********************************************************************


PRTIO:                            ;INT 17 printer I/O routine
         PUSH      DX             ;save DX
         XOR       DX,DX          ;zero DX
         PUSH      AX             ;save AX
         MOV       AH,00H         ;zero AH, AL contains printer code

         INT       17H            ;DOS print function

         POP       AX             ;recover AX
         POP       DX             ;recover DX

         RET                      ;return to caller


;**********************************************************************

         PAGE


;**********************
;*     CONSTANTS      *
;**********************


MSG1     DB        CR,LF
         DB        'Invalid or no input - '
         DB        'options= T B C D E N S R 6 or 8'
         DB        CR,LF,'$'

CSEG     ENDS

         END       PMODE
                                                                                 