.radix	16
		;
cseg	segment
		assume	cs:cseg, ds:cseg
		;
		video	equ	10	; bios video interrupt
		exit	equ	20	; return to ccp routine
		getmode	equ	0f
		setmode	equ	0
		cgual	equ	1110	; char gen routine, user alpha load
		inforeq	equ	1130	; char gen routine, get info
		;
		org	100
		;
		; get pointer to rom character set (rom double dot set)
		;
line35:		mov	bh, 03		; get pointer to char set (double dot)
		mov	ax, inforeq
		int	video		; returns es:bp as pointer
		;
		; set up to copy to here
		;
		mov	ax,  es
		mov	ds,  ax		; set ds to char seg segment
		mov	ax,  cs
		mov	es,  ax		; set es to this segment
		mov	si,  bp		; move from char set ...
		mov	di, offset temp	; to the end of the code
		cld
		xor	ax,  ax
		mov	bx, 0100	; number of characters
		; now move the character set
letterloop:	mov	cx, 0004	; 4 words (8 bytes) /char
		rep	movsw
		stosw			; and zero last word
		dec	bx
		jnz	letterloop	; do next character
		;
		; get the current mode
		mov	ah, getmode
		int	video
		;
		; above returns mode in al, below uses it there
		;
		; set the current mode
		mov	ah, setmode
		int	video
		;
		; tell bios to upload what we just downloaded
		;
		; (do this only  after setting mode ) 
		mov	bp, offset temp	; es still points at us, es:bp is temp
		xor	dx, dx		; offset into table is zero
		mov	cx, 0100	; now load 
		mov	bx, 0a00
		mov	ax, cgual
		int	video
		int	exit
		;
		temp	db	0	; temp storage for char set
		;
cseg	ends
	end	line35
