; PRINT.ASM for E32 - Copyright (C) 1994 - 1996 Douglas Herr
;  all rights reserved

; 01/07/1996 DH: added printer menu

include	model.inc

public	print, ffeed
extrn	mark:near
extrn	working:near
extrn	ljsend:near

include	dataseg.inc
extrn	breakflag:byte
extrn	mark_start:dword, mark_end:dword, mark_mode:byte
extrn	filesiz:dword
extrn	int24h_msg:dword
ff	db 12
print_error	db 'Printer not ready or out of paper:  retry? (Y/N)',0

public	printer_type
printer_type	db 0

setup_proc	dd offset CGROUP:ljsend
		dd offset CGROUP:near_ret
		dd offset CGROUP:near_ret
@curseg	ends

include	codeseg.inc
;
; this subroutine sends a formfeed to the printer
; use DOS handle 4
;
ffeed	proc	near
	push	int24h_msg
	mov	int24h_msg,offset print_error
	call	working

	lea	edx,ff
	mov	bx,4
	mov	ah,40h
	xor	ecx,ecx
	inc	ecx
	int	21h
	jmp	exit			; restore default error message

ffeed	endp

get_offset	equ	[ebp-4]
bytes		equ	[ebp-8]

;
; print the marked text
;

print:
	push	int24h_msg
	mov	int24h_msg,offset print_error

; send setup string to printer
	movzx	ebx,printer_type
	call	setup_proc[ebx*4]

; display 'Working' message
	call	working
	enter	8,0

	xor	eax,eax			; default: print all
	mov	ebx,filesiz

	cmp	mark_mode,0
	je	short print0

	mov	ebx,mark_end
	mov	eax,mark_start
	sub	ebx,eax			; bytes

print0:
	mov	get_offset,eax
	mov	bytes,ebx

	mov	breakflag,0

prn0:	shr	breakflag,1	; check for ^C
	jc	short print_done

	mov	eax,65535
	cmp	eax,bytes
	jbe	short prn1
	mov	eax,bytes	; print all remaining bytes
prn1:	mov	ecx,eax		; save bytes in ECX
	jecxz	print_done	; done if nothing to print

; write to std output
; ECX = bytes to write
	mov	edx,get_offset
	push	ds
	push	fs
	pop	ds		; DS:[EDX] -> working buffer
	mov	bx,4		; handle for 'PRN'
	mov	ah,40h
	int	21h
	pop	ds
	jc	short print_done

	add	get_offset,ecx
	sub	bytes,ecx
	jmp	prn0

print_done:
	leave

	cmp	mark_mode,0
	je	short exit
	call	mark		; turn off the mark state

exit:	pop	int24h_msg
	clc
near_ret:
	ret

@curseg	ends
	end
