; DEL_LINE.ASM for E32 - Copyright (C) 1994 - 1996 Douglas Herr
;  all rights reserved

; 03/22/1996 DH: changed lb to public symbol

include	model.inc

public	del_l, udel_l, del_eol, close_space, line_length

; use MEMCOPY in place of REP  MOVSB
; because MEMCOPY is faster when it counts on huge files
extrn	memcopy:near
extrn	endd:near
extrn	find_start:near
extrn	find_next:near
extrn	locate:near
extrn	insert_string:near
extrn	sub_push:near
extrn	home:near

include	dataseg.inc
public	lb
extrn	dirty_bits:byte, cur_posn:word
extrn	cursor:dword, filesiz:dword
extrn	left_margin:word
line_flag	db 0
line_length	dd 0
lb	db 256 dup (?)
@curseg	ends

include	codeseg.inc
;
; this deletes a line, placing it in the line buffer
;
del_l	proc	near
	mov	line_flag,-1
	call	find_start	; find start of this line
	mov	cursor,esi	; this will be the new cursor position
	push	esi		; save the cursor position
	call	find_next	; find the next line
	mov	ecx,esi		; CX will hold the line length
	pop	esi		; get back the new cursor position
del_end:sub	ecx,esi		; number of bytes on line
	cmp	ecx,100h	; is line too long to fit?
	jb	short not_too_long
	mov	ecx,100h	; only save 256 characters
not_too_long:
	mov	line_length,ecx	; store length of deleted line
	jecxz	no_del_l
	lea	edi,lb
	push	ecx
	push	ds
	pop	es

	push	ds
	push	fs
	pop	ds
	call	memcopy		; put deleted line in buffer
	pop	ds

	pop	eax		; get back line length
	call	close_space

	mov	dx,cur_posn	; get cursor row/col
	mov	esi,cursor	; get new cursor location
	call	locate		; adjust screen position
	clc
	ret
del_l	endp

;
; CLOSE_SPACE closes a hole in the file
; call with EAX = bytes to remove
;
close_space:
	mov	ecx,filesiz	; get the file size
	sub	filesiz,eax	; new file size
	call	sub_push	; adjust saved offset if nessesary
	mov	esi,cursor	; get new cursor location
	mov	edi,esi
	add	esi,eax		; ESI points to end of file
	sub	ecx,esi		; length of remaining file
	or	dirty_bits,11000001b
	jecxz	no_del_l

	push	ds
	mov	ax,fs
	mov	es,ax
	mov	ds,ax
	call	memcopy		; remove end of line from active buffer
	pop	ds
no_del_l:
	clc
	ret

;
; delete from the cursor position to the end of the line
;
del_eol	proc	near
	mov	line_flag,0
	push	cursor		; find start of this line
	push	left_margin
	call	endd		; move to the end of the line
	pop	left_margin
	pop	esi		; get back the starting cursor
	mov	ecx,cursor	; offset of the end of the line
	mov	cursor,esi	; restore starting cursor
	jmp	del_end
del_eol	endp

;
; This undeletes a line by copying it from the line buffer into the file
;
udel_l	proc	near
	push	es
	cmp	line_flag,0		; is this an end-of-line only?
	je	short udel_eol		; if yes, don't home the cursor
	call	home			; move the cursor to home
udel_eol:
	push	fs
	pop	es
	mov	eax,line_length		; length of deleted line
	lea	esi,lb
	call	insert_string
	clc
	pop	es
	ret
udel_l	endp

@curseg	ends
	end
