;   Zbase Door Control file
;--------------------------------
; The semi-colons are comment markers.  Remove them to activate option.
;
;Sysopfirst  Specifies the first name of the sysop as it will be shown to
;            the users.
;
;SysopLast   Specifies the last name of the sysop as it will be shown to
;            the users.
;
;BBSName     Specifies the name of the bbs as it will be shown to users.
;
;Mono        Will disable color on the local side. (Necessary if you are
;            running a monochrome system)
;
;BBSType     Specifies the type of bbs software under which this door program
;            will be run. Valid bbs types include:
;
;                  DOORSYS - The DOOR.SYS format (Wildcat! 3.xx, TAG, etc)
;                     RBBS - Rbbs version 16.1+  (uses DORINFOx.DEF*)
;                    QUICK - Quickbbs,Force,R.A. (uses DORINFOx.DEF**)
;                    PCB12 - Pcboard version 12 (note: see COMPORT note below)
;                    PCB14 - Pcboard version 14
;                    PCB15 - Pcboard version 15
;                  PHOENIX - Phoenix bbs
;                 SPITFIRE - Spitfires drop file (SFDOORS.DAT)
;                     WWIV - WWIV bbs (uses chain.txt)
;                 CALLINFO - Old Wildcat 2.xx
;
;  Notes: There are at least two different types of DORINFOx.DEF
;           *  ANSI graphics is selected when a "2" is passed in the graphics
;              parameter of the DORINFOx.DEF.   RBBS standard.
;          **  ANSI graphics is selected when a "1" is passed in the graphics
;              parameter of the DORINFOx.DEF.   QuickBBS,Remote Access,FORCE,
;              UltraBBS and many shareware BBSes require this type.
;
;ComPort     For bbs types that do not have the com-port contained in their
;            door information files (such as PCBOARD-12), you will have to
;            specify the com-port. Simply put the port number (i.e. 1,2,etc)
;            not the whole word COM1.  If you find that one node locks up
;            another node you may have to use this option.
;            [NOTE: You can also specify the comport using /Cx from the
;            command line]
;
;
;Fossil      Selecting this option will cause doordriver to use a fossil port
;            driver.  Otherwise doordriver will use its own internal comport
;            handlers.  Note - do not use both fossil and Xfossil at the same
;            time. Maximum ANSI standard speed of 38,400.
;
;Xfossil     Selecting this option will cause DDPlus to use the extended fossil
;            driver speeds in both X00 or BNU.   This will support speeds of
;            57,800 or higher baud.  Otherwise DDPlus will use its own internal
;            comport handlers.  This option neither open or closes the fossil
;            but reads and writes to it in whatever state it is when the door
;            is run.
;
;LockBaud    This will specify a locked baud rate. If you specify this
;            parameter, then no matter what the bbs software says, this
;            baud rate will be used. [NOTE: You can also specify the locked
;            baud rate using /Bxxxx from the command line]
;
;Port1       If you must use a non-standard interrupt, doordriver can be
;Port2       configured for IRQs 0-15. The port# indicates the chosen comport
;Port3       Follow this with the port address in hex.  Afterward put the IRQ
;Port4       in decimal.  For an example if comport 3 at irq 15 and address
;            $03E8 was needed use the following:
;            PORT3 03E8 15
;
;Maxtime     The maxtime parameter will allow you to specify a maximum time
;            per session that a user may be in the door. (i.e. if you
;            specified 30 minutes, then if the user had 60 mins left, he could
;            only play for 30 mins)
;
;Status      Specify "ON" if you wish the status line to appear at the bottom
;            of "OFF" if you wish it to be disabled.
;
;Statfore    Statfore foreground color of the status line and the major input
;            fields. (default 7  light-grey)
;
;Statback    The background color of the status line (default 1)
;
;Color1      Tells Zbase to select ANSI graphics when a "1" is passed
;            in the graphics parameter of the DORINFOx.DEF. From what I
;            understand, FORCE and QUICKBBS require this option set Sometimes
;            RBBS Might also.
;
;CUSTOMMENU  If Uncommented then Menu Cursor Control is disabled completely
;            allowing you to make your own screens without having to worry
;            about the Menu selector lining up..
;
;--------------------------- DOWNLOAD PROTOCOL METHOD -----------------------
;                      *NOTE ONLY USED FOR DOWNLOADING*
;SERIAL /U        -  The SERIAL /U parameter tells the FTP which serial
;                  communications method to use during downloads
;                  it can be one of the following:
;
;           SERIAL /UFOS  -  Use the installed FOSSIL for port communications.
;                            This is the default mode.  If you want FOSSIL
;                            communications, you need not specify a /U
;                            parameter. This is the default..
;
;           SERIAL /UDIR  -  Use direct (standard) communications.  Next to
;                            having an installed, working FOSSIL driver, this
;                            method is the most compatible.
;
;           SERIAL /UFAS  -  Use the FAST, interrupt driven communications
;                            routines.  This may not be compatible with all
;                            serial cards and/or BIOS.  The FTP will "take
;                            over" INT 14h, and restore the previous 14h
;                            vector upon termination.  (This should allow you
;                            to use /Ufas, even if you also have a FOSSIL
;                            driver installed.  A FOSSIL "int 14 recapture"
;                            should *not* be necessary upon normal
;                            termination.  If you experience lockups, it is
;                            most likely interference from other TSR
;                            programs or system incompatibilities.  In this
;                            case, use /Udir instead.;
;
;
;
;
;------------------------------ Sample Data ----------------------------------
;::::------- Fossil selected for download protocol CEXYZ
;::::
;\/\/
SERIAL /Ufos
;
;::::------- Used if color output not right
;::::
;\/\/
;COLOR1
STATUS ON
STATBACK 1
STATFORE 15
;
SYSOPFIRST JOE
SYSOPLAST SYSOP
BBSNAME Anytown BBS
;
;       ::::------- Put your bbs type here! Select from those listed above
;       ::::
;       \/\/
BBSTYPE RBBS
;
;                   If you are using a bbs type that doesn't provide the com
;        ::-------- port num in it's door information file (such as pcb-12),
;        \/         then uncomment this line and put your com port here.
;COMPORT 1
;
; Uncomment the next line if you use a fossil device driver with speeds up to
; 38,400 baud.
;FOSSIL
;
; Uncomment the next line if you use a fossil device driver using extended
; speeds above 38,400 baud.
XFOSSIL
;
;           ::------If you are locking ports uncomment this line and set this
;           ::      number to the port speed.
;           \/
LOCKBAUD 115200
;
;       ::------------ If you are going to use a non-standard IRQ place the
;       ::             port address in hex one space after the PORT# option.
;       ::
;       ::  ::-------- If you have a non-standard IRQ position the IRQ number
;       \/  \/         one space after the ports' hex address.
;PORT1 03F8 4
;PORT2 02F8 3
;PORT3 03E8 5
;PORT4 01F8 3
;
;------------------------------ End of File ----------------------------------

