;------ zavt_i.asm ----------------------------------------------
; Zephyr Avatar terminal driver.
;    Copyright (C) 1989-1990, Luns Tee, Toronto ON.
;    Based on original code for ZANSI by Thomas Hanlin III, Alexandria VA.
;    and original code for NANSI by Daniel Kegel, Pasadena CA.
;------------------------------------------------------------------------
; Contains code only needed at initialization time.
	include	zavt_d.asm		; get equates

	; to zavt.asm
	public	dosfn0
	if	fullscreen
	public	linebuf
	public	linebufend
	endif

	; to zavt_p.asm
	public	param_buffer, param_end

	; from zavt.asm
	extrn	break_handler:near
	extrn	int_29:near
	extrn	req_ptr:dword

	if	xlate
	extrn	key_init:near
	public	redef_end
	endif

ZeroSeg	segment at 0h
	org	6Ch
BrInt	dw	?,?

	org	0A4h
Int29	dw	?,?

ZeroSeg	ends

code	segment byte public 'CODE'
	assume	cs:DGroup, ds:DGroup

param_buffer	equ	offset dosfn0
				; address of first byte free for new params
	if	xlate
param_end	dw	dosfn0+511
redef_end	equ	dosfn0+510
	else
param_end	equ	offset dosfn0+511
	endif				; address of end of free area
	if	fullscreen
linebuf		equ	dosfn0+512
linebufend	equ	linebuf+255
endofdriver	equ	linebufend+1
	else
endofdriver	equ	dosfn0+512
	endif

;-------- dos function # 0 : init driver ---------------------
; Initializes device driver interrupts and buffers, then
; passes ending address of the device driver to DOS.
; Since this code is only used once, the buffer can be set up on top
; of it to save RAM.

dosfn0	proc	near
	; Calculate address of end of parameter buffer.
	; The buffer occupies the same area of memory as this code!
	; ANSI parameters are accumulated at the lower end, and
	; param_end is the last byte used by params
	if	xlate
	call	key_init		; clear keyboard translation table
	endif

	; Install BIOS keyboard break handler.
	xor	ax,ax
	mov	ds,ax
	assume	ds:zeroseg
	mov	word ptr [BrInt],offset break_handler
	mov	[BrInt+2],cs

	; Install INT 29 quick putchar.
	mov	word ptr [Int29],offset int_29
	mov	[Int29+2],cs

	mov	bx,ABS40
	mov	ds,bx
	assume	ds:ABS40
	mov	bl,crt_rows		; see if a sub EGA is
	or	bl,bl			; installed and initialize
	jnz	second_call		; BIOS data area's entry
	mov	crt_rows,24		; for rows on screen

second_call:

	; Return ending address of this device driver, with status in AX.
	lds	si,cs:[req_ptr]
	mov	14[si], offset endofdriver
	mov	16[si],cs

	ret				; Return exit status (still 0) in ax.

dosfn0	endp

code	ends
	end				; of zansi_i.asm
