#include "roms.h"

const struct RomModule GalaxianGFXROMs[] =
{
    {"galaxian.1j", 0x0000, 0x0800},
    {"galaxian.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalaxianROMs[] =
{
    {"galaxian.u", 0x0000, 0x0800},
    {"galaxian.v", 0x0800, 0x0800},
    {"galaxian.w", 0x1000, 0x0800},
    {"galaxian.y", 0x1800, 0x0800},
    {"galaxian.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalnamcoGFXROMs[] =
{
    {"galnamco.1j", 0x0000, 0x0800},
    {"galnamco.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalnamcoROMs[] =
{
    {"galnamco.u", 0x0000, 0x0800},
    {"galnamco.v", 0x0800, 0x0800},
    {"galnamco.w", 0x1000, 0x0800},
    {"galnamco.y", 0x1800, 0x0800},
    {"galnamco.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule SupgalaxGFXROMs[] =
{
    {"supgalax.1j", 0x0000, 0x0800},
    {"supgalax.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule SupgalaxROMs[] =
{
    {"supgalax.u", 0x0000, 0x0800},
    {"supgalax.v", 0x0800, 0x0800},
    {"supgalax.w", 0x1000, 0x0800},
    {"supgalax.y", 0x1800, 0x0800},
    {"supgalax.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalapxGFXROMs[] =
{
    {"galapx.1j", 0x0000, 0x0800},
    {"galapx.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalapxROMs[] =
{
    {"galapx.u", 0x0000, 0x0800},
    {"galapx.v", 0x0800, 0x0800},
    {"galapx.w", 0x1000, 0x0800},
    {"galapx.y", 0x1800, 0x0800},
    {"galapx.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalturboGFXROMs[] =
{
    {"galturbo.1j", 0x0000, 0x0800},
    {"galturbo.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule GalturboROMs[] =
{
    {"galturbo.u", 0x0000, 0x0800},
    {"galturbo.v", 0x0800, 0x0800},
    {"galturbo.w", 0x1000, 0x0800},
    {"galturbo.y", 0x1800, 0x0800},
    {"galturbo.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule WarofbugGFXROMs[] =
{
    {"warofbug.1j", 0x0000, 0x0800},
    {"warofbug.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule WarofbugROMs[] =
{
    {"warofbug.u", 0x0000, 0x0800},
    {"warofbug.v", 0x0800, 0x0800},
    {"warofbug.w", 0x1000, 0x0800},
    {"warofbug.y", 0x1800, 0x0800},
    {"warofbug.z", 0x2000, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PiscesGFXROMs[] =
{
    {"pisces.1j", 0x0000, 0x0800},
    {"pisces.1k", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule PiscesROMs[] =
{
    {"pisces.a1", 0x0000, 0x0800},
    {"pisces.a2", 0x0800, 0x0800},
    {"pisces.b2", 0x1000, 0x0800},
    {"pisces.c1", 0x1800, 0x0800},
    {"pisces.d1", 0x2000, 0x0800},
    {"pisces.e2", 0x2800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule MoonCrestaGFXROMs[] =
{
    {"EPR202", 0x0000, 0x0800},
    {"EPR203", 0x0800, 0x0800},
    {"EPR171", 0x1000, 0x0800},
    {"EPR172", 0x1800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule MoonCrestaROMs[] =
{
    {"EPR194", 0x0000, 0x0800},
    {"EPR195", 0x0800, 0x0800},
    {"EPR196", 0x1000, 0x0800},
    {"EPR197", 0x1800, 0x0800},
    {"EPR198", 0x2000, 0x0800},
    {"EPR199", 0x2800, 0x0800},
    {"EPR200", 0x3000, 0x0800},
    {"EPR201", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TheEndGFXROMs[] =
{
    {"IC30", 0x0000, 0x0800},
    {"IC31", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TheEndROMs[] =
{
    {"IC13", 0x0000, 0x0800},
    {"IC14", 0x0800, 0x0800},
    {"IC15", 0x1000, 0x0800},
    {"IC16", 0x1800, 0x0800},
    {"IC17", 0x2000, 0x0800},
    {"IC18", 0x2800, 0x0800},
    {"IC55", 0x3000, 0x0800},
    {"IC56", 0x3800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule AmidarGFXROMs[] =
{
    {"amidar.5f", 0x0000, 0x0800},
    {"amidar.5h", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule AmidarROMs[] =
{
    {"amidar.2c", 0x0000, 0x1000},
    {"amidar.2e", 0x1000, 0x1000},
    {"amidar.2f", 0x2000, 0x1000},
    {"amidar.2h", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule TurtlesGFXROMs[] =
{
    {"turt_vid.5f", 0x0000, 0x0800},
    {"turt_vid.5h", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule TurtlesROMs[] =
{
    {"turt_vid.2c", 0x0000, 0x1000},
    {"turt_vid.2e", 0x1000, 0x1000},
    {"turt_vid.2f", 0x2000, 0x1000},
    {"turt_vid.2h", 0x3000, 0x1000},
    {"turt_vid.2j", 0x4000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct RomModule FroggerGFXROMs[] =
{
    {"frogger.606", 0x0000, 0x0800},
    {"frogger.607", 0x0800, 0x0800},
    {0, 0, 0}                   // end of table
};

const struct RomModule FroggerROMs[] =
{
    {"frogger.ic5", 0x0000, 0x1000},
    {"frogger.ic6", 0x1000, 0x1000},
    {"frogger.ic7", 0x2000, 0x1000},
    {"frogger.ic8", 0x3000, 0x1000},
    {0, 0, 0}                   // end of table
};

const struct GameInfo gameinfo[] =
{
    {"galaxian", GalaxianROMs},
    {"galnamco", GalnamcoROMs},
    {"supgalax", SupgalaxROMs},
    {"galapx", GalapxROMs},
    {"galturbo", GalturboROMs},
    {"warofbug", WarofbugROMs},
    {"pisces", PiscesROMs},
    {"mooncrst", MoonCrestaROMs},
    {"theend", TheEndROMs},
    {"amidar", AmidarROMs},
    {"turtles", TurtlesROMs},
    {"frogger", FroggerROMs}    /* generic entry used for Pac Man and
                                 * variations */
};

/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */

const unsigned char palette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 130, 238,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 100, 0,                  // GREEN
    54, 54, 54                  // WHITE
};

const unsigned char galaxianpalette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 130, 238,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 100, 0,                  // GREEN
    54, 54, 54                  // WHITE
};

const unsigned char amidarpalette[3 * TOTAL_COLORS] =
{
    0, 0, 0,                    // BLACK
    63, 0, 0,                   // RED
    238, 162, 173,              // PURPLE
    0, 63, 63,                  // CYAN,
    63, 63, 0,                  // YELLOW,
    9, 9, 63,                   // BLUE
    0, 63, 0,                   // GREEN
    54, 54, 54                  // WHITE
};

/* The color of each character/sprite is determined by a 5 bit value, which */
/* selects the entry to use in this lookup table, and by the 2 bits of the */
/* chracter/sprite data. Additionally, bit 7 of the byte stored in Color RAM */
/* seems to be set for text characters; the reason is yet unknown. */

const unsigned char colortable[4 * COLOR_CODES] =
{
    black, white, white, white, 
    black, red, blue, yellow,   
    black, blue, red, yellow,  
    black, blue, purple, red,   
    black, blue, green, red,  
    black, red, red, red,       
    black, white, red, cyan,  
    black, yellow, red, purple,
    black, red, blue, green,
    black, red, green, blue,
    black, red, blue, yellow,
    black, blue, red, yellow,
    black, blue, purple, red,
    black, blue, green, red,
    black, white, red, cyan,
    black, yellow, red, purple
};

const unsigned char galaxiancolortable[4 * COLOR_CODES] =
{
    black, white, white, white, /* background, white text */
    black, red, blue, yellow,   /* flag ship */
    black, blue, red, yellow,   /* red bug */
    black, blue, purple, red,   /* purple bug */
    black, blue, green, red,    /* green bug */
    black, red, red, red,       /* red text */
    black, white, red, cyan,    /* player ship, cyan text */
    black, yellow, red, purple, /* explosion, purple text */
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black
};

const unsigned char amidarcolortable[4 * COLOR_CODES] =
{
    black, red, blue, white,       // red lines, blue fill, white dots
    black, green, yellow, purple,  // yellow gorilla
    black, green, red, yellow,     // yellow line on title screen
    black, red, purple, green,   
    black, yellow, green, red,   
    black, red, yellow, green,      
    black, white, red, purple,     // purple pig
    black, cyan, red, white,       // white pig
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black,
    black, black, black, black    
};

const struct GameVidInfo gamevidinfo[] =
{
    {"galaxian", GalaxianGFXROMs, galaxianpalette, galaxiancolortable},
    {"galnamco", GalnamcoGFXROMs, galaxianpalette, galaxiancolortable},
    {"supgalax", SupgalaxGFXROMs, galaxianpalette, galaxiancolortable},
    {"galapx", GalapxGFXROMs, galaxianpalette, galaxiancolortable},
    {"galturbo", GalturboGFXROMs, galaxianpalette, galaxiancolortable},
    {"warofbug", WarofbugGFXROMs, galaxianpalette, galaxiancolortable},
    {"pisces", PiscesGFXROMs, palette, colortable},
    {"mooncrst", MoonCrestaGFXROMs, palette, colortable},
    {"theend", TheEndGFXROMs, galaxianpalette, galaxiancolortable},
    {"amidar", AmidarGFXROMs, amidarpalette, amidarcolortable},
    {"turtles", TurtlesGFXROMs, palette, colortable},
    {"frogger", FroggerGFXROMs, palette, colortable}
};
