/***************************************************************************

  osdepend.c

  OS dependant stuff (display handling, keyboard scan...)
  This is the only file which should me modified in order to port the
  emulator to a different system.

***************************************************************************/

#include <pc.h>
#include <sys/farptr.h>
#include <stdio.h>
#include <go32.h>
#include <allegro.h>
#include "gfxdecode.h"
#include "osdepend.h"
#include "machine.h"
#include "TwkUser.c"


/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int             osd_init(void)
{
    allegro_init();
    install_keyboard();         /* Allegro keyboard handler */
    initialise_joystick();

    return 0;
}

void            osd_create_display(int graphicsmode)
{
    int             count1,
                    count2;

    if (graphicsmode == VESA)
        set_gfx_mode(GFX_VESA1, 640, 480, 0, 0);    // Allegro routine to
    // start video
    else if (graphicsmode == MODEX)
        set_gfx_mode(GFX_MODEX, 256, 256, 0, 0);    // Allegro routine to
    // start video

    piccie = create_bitmap(256, 256);   // Allocate memory for temp screen
    // (in memory)

    for (count1 = 0; count1 < 256; count1++)
        for (count2 = 0; count2 < 256; count2++)
            piccie->line[count1][count2] = 0;   // Clear the temp screen

}

/* shut up the display */
void            osd_close_display(void)
{
    destroy_bitmap(piccie);
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
}

/* Update the display. */
void            osd_update_display(void)
{
    PALETTE         pal;
    char            name[13];
    FILE           *f;
    static int      snapno;

    if (graphicsmode == VESA)
    {
        if ((gameemulated == GALAXIAN) || (gameemulated == GALNAMCO) ||
            (gameemulated == SUPGALAX) || (gameemulated == GALAPX) ||
            (gameemulated == GALTURBO) || (gameemulated == AMIDAR) ||
            (gameemulated == THEEND))
            blit(piccie, screen, 0, 0, 192, 112, 248, 256);
        else
            blit(piccie, screen, 0, 0, 192, 112, 256, 256);
    }
    else if (graphicsmode == MODEX)
    {
        if ((gameemulated == GALAXIAN) || (gameemulated == GALNAMCO) ||
            (gameemulated == SUPGALAX) || (gameemulated == GALAPX) ||
            (gameemulated == GALTURBO) || (gameemulated == AMIDAR) ||
            (gameemulated == THEEND))
            blit(piccie, screen, 0, 0, 0, 0, 248, 256);
        else
            blit(piccie, screen, 0, 0, 0, 0, 256, 256);

    }

    /* if the user pressed F6, save a snapshot of the screen. */
    if (osd_key_pressed(OSD_KEY_F6))
    {

        do
        {
            sprintf(name, "snap%04d.pcx", snapno);
            /* avoid overwriting of existing files */
            if ((f = fopen(name, "rb")) != 0)
            {
                fclose(f);
                snapno++;
            }
        } while (f != 0);

        get_palette(pal);
        save_pcx(name, piccie, pal);
        snapno++;

        /* wait for the user to release F6 */
        while (osd_key_pressed(OSD_KEY_F6));
    }


}

/* put here cleanup routines to be executed when the program is terminated. */
void            osd_exit(void)
{
}

/* Set the graphics palette */
void            osd_set_palette(void)
{
    int count;
    outportb(0x3c8, 0x00);
    for (count = 0; count < 768; count++)
        outportb(0x3c9, pal[count]);
}


/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int             osd_key_pressed(int keycode)
{
    return key[keycode];
}

/* check joystick direction defined in osdepend.h. Return 0 if the joystick is not
   selected, nonzero otherwise. */
int             osd_joystick(int joycode)
{
    if (!Joystick)
        return 0;
    switch (joycode)
    {
    case OSD_JOYSTICK_LEFT:
        if (joy_left)
            return 1;
        else
            return 0;
        break;
    case OSD_JOYSTICK_RIGHT:
        if (joy_right)
            return 1;
        else
            return 0;
        break;
    case OSD_JOYSTICK_UP:
        if (joy_up)
            return 1;
        else
            return 0;
        break;
    case OSD_JOYSTICK_DOWN:
        if (joy_down)
            return 1;
        else
            return 0;
        break;
    case OSD_JOYSTICK_B1:
        if (joy_b1)
            return 1;
        else
            return 0;
        break;
    case OSD_JOYSTICK_B2:
        if (joy_b2)
            return 1;
        else
            return 0;
        break;
    default:
        return 0;
    }
}

/* Play a sound at the desired frequency */
void            osd_sound(int frequency)
{
    if (Sound)
        sound(frequency);
}

/* Poll the joystick */
void            osd_poll_joystick(void)
{
    if (Joystick)
        poll_joystick();
}
