/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Basic Galaxian Memory map

Compiled from information provided by friends and Uncles on RGVAC.

            AAAAAA
            111111AAAAAAAAAA     DDDDDDDD   Schem   function
HEX         5432109876543210 R/W 76543210   name

0000-27FF                                           Game ROM
5000-57FF   01010AAAAAAAAAAA R/W DDDDDDDD   !Vram   Character ram
5800-583F   01011AAAAAAAAAAA R/W DDDDDDDD   !OBJRAM Screen attributes
5840-585F   01011AAAAAAAAAAA R/W DDDDDDDD   !OBJRAM Sprites
5860-5FFF   01011AAAAAAAAAAA R/W DDDDDDDD   !OBJRAM Bullets

6000        0110000000000000 R   -------D   !SW0    coin1
6000        0110000000000000 R   ------D-   !SW0    coin2
6000        0110000000000000 R   -----D--   !SW0    p1 left
6000        0110000000000000 R   ----D---   !SW0    p1 right
6000        0110000000000000 R   ---D----   !SW0    p1shoot
6000        0110000000000000 R   --D-----   !SW0    table ??
6000        0110000000000000 R   -D------   !SW0    test
6000        0110000000000000 R   D-------   !SW0    service

6000        0110000000000001 W   -------D   !DRIVER lamp 1 ??
6001        0110000000000001 W   -------D   !DRIVER lamp 2 ??
6002        0110000000000010 W   -------D   !DRIVER lamp 3 ??
6003        0110000000000011 W   -------D   !DRIVER coin control
6004        0110000000000100 W   -------D   !DRIVER Background lfo freq bit0
6005        0110000000000101 W   -------D   !DRIVER Background lfo freq bit1
6006        0110000000000110 W   -------D   !DRIVER Background lfo freq bit2
6007        0110000000000111 W   -------D   !DRIVER Background lfo freq bit3

6800        0110100000000000 R   -------D   !SW1    1p start
6800        0110100000000000 R   ------D-   !SW1    2p start
6800        0110100000000000 R   -----D--   !SW1    p2 left
6800        0110100000000000 R   ----D---   !SW1    p2 right
6800        0110100000000000 R   ---D----   !SW1    p2 shoot
6800        0110100000000000 R   --D-----   !SW1    no used
6800        0110100000000000 R   -D------   !SW1    dip sw1
6800        0110100000000000 R   D-------   !SW1    dip sw2

6800        0110100000000000 W   -------D   !SOUND  reset background F1
                                                    (1=reset ?)
6801        0110100000000001 W   -------D   !SOUND  reset background F2
6802        0110100000000010 W   -------D   !SOUND  reset background F3
6803        0110100000000011 W   -------D   !SOUND  Noise on/off
6804        0110100000000100 W   -------D   !SOUND  not used
6805        0110100000000101 W   -------D   !SOUND  shoot on/off
6806        0110100000000110 W   -------D   !SOUND  Vol of f1
6807        0110100000000111 W   -------D   !SOUND  Vol of f2

7000        0111000000000000 R   -------D   !DIPSW  dip sw 3
7000        0111000000000000 R   ------D-   !DIPSW  dip sw 4
7000        0111000000000000 R   -----D--   !DIPSW  dip sw 5
7000        0111000000000000 R   ----D---   !DIPSW  dip s2 6

7001        0111000000000001 W   -------D   9Nregen NMIon
7004        0111000000000100 W   -------D   9Nregen stars on
7006        0111000000000110 W   -------D   9Nregen hflip
7007        0111000000000111 W   -------D   9Nregen vflip

Note: 9n reg,other bits  used on moon cresta for extra graphics rom control.

7800        0111100000000000 R   --------   !wdr    watchdog reset
7800        0111100000000000 W   DDDDDDDD   !pitch  Sound Fx base frequency


***************************************************************************/

#define ALL_BITS_0 0
#define ALL_BITS_1 255

/****************************************************/
/*                     Input Ports                  */
/****************************************************/

/* Galaxian */

#define GALAXIAN_IN0_PORT 0x6000
#define GALAXIAN_IN0_SERVICE  (1<<7)
#define GALAXIAN_IN0_TEST     (1<<6)
#define GALAXIAN_IN0_TABLE    (1<<5)
#define GALAXIAN_IN0_P1_SHOOT (1<<4)
#define GALAXIAN_IN0_P1_RIGHT (1<<3)
#define GALAXIAN_IN0_P1_LEFT  (1<<2)
#define GALAXIAN_IN0_COIN2    (1<<1)
#define GALAXIAN_IN0_COIN1    (1<<0)
#define GALAXIAN_IN1_PORT 0x6800
#define GALAXIAN_IN1_SW2 (1<<7)
#define GALAXIAN_IN1_SW1 (1<<6)
#define GALAXIAN_IN1_NOT_USED (1<<5)
#define GALAXIAN_IN1_P2_SHOOT (1<<4)
#define GALAXIAN_IN1_P2_RIGHT (1<<3)
#define GALAXIAN_IN1_P2_LEFT (1<<2)
#define GALAXIAN_IN1_2P_START (1<<1)
#define GALAXIAN_IN1_1P_START (1<<0)
#define GALAXIAN_DSW_PORT 0x7000
#define GALAXIAN_DSW_SW6  (1<<3)
#define GALAXIAN_DSW_SW5  (1<<2)
#define GALAXIAN_DSW_SW4  (1<<1)
#define GALAXIAN_DSW_SW3  (1<<0)

/* War of the Bugs */

#define WAROFBUG_IN0_UP       (1<<7)
#define WAROFBUG_IN0_DOWN     (1<<6)

/* Amidar */

#define AMIDAR_IN0_PORT     0xB000
#define AMIDAR_IN0_COIN1    (1<<6)
#define AMIDAR_IN0_P1_LEFT  (1<<5)
#define AMIDAR_IN0_P1_RIGHT (1<<4)
#define AMIDAR_IN0_P1_JUMP  (1<<3)
#define AMIDAR_IN1_PORT     0xB010
#define AMIDAR_IN1_1P_START (1<<7)
#define AMIDAR_IN2_PORT     0xB020
#define AMIDAR_IN1_P1_DOWN  (1<<6)
#define AMIDAR_IN1_P1_UP    (1<<4)
#define AMIDAR_DSW_PORT     0xB820

/* Turtles */

#define TURTLES_IN0_PORT     0xB000
#define TURTLES_IN0_COIN1    (1<<7)
#define TURTLES_IN0_P1_LEFT  (1<<5)
#define TURTLES_IN0_P1_RIGHT (1<<4)
#define TURTLES_IN0_P1_BOMB  (1<<3)
#define TURTLES_IN1_PORT     0xB010
#define TURTLES_IN1_1P_START (1<<7)
#define TURTLES_IN2_PORT     0xB020
#define TURTLES_IN1_P1_DOWN  (1<<6)
#define TURTLES_IN1_P1_UP    (1<<4)
#define TURTLES_DSW_PORT     0xB820

/* Frogger */

#define FROGGER_IN0_PORT     0xE000
#define FROGGER_IN0_COIN1    (1<<7)
#define FROGGER_IN0_P1_LEFT  (1<<5)
#define FROGGER_IN0_P1_RIGHT (1<<4)
#define FROGGER_IN1_PORT     0xE002
#define FROGGER_IN1_1P_START (1<<7)
#define FROGGER_IN1_2P_START (1<<6)
#define FROGGER_IN2_PORT     0xE004
#define FROGGER_IN1_P1_DOWN  (1<<6)
#define FROGGER_IN1_P1_UP    (1<<4)

/* Moon Cresta */

#define MOONCRST_IN0_PORT 0xA000
#define MOONCRST_IN0_SERVICE  (1<<7)
#define MOONCRST_IN0_TEST     (1<<6)
#define MOONCRST_IN0_TABLE    (1<<5)
#define MOONCRST_IN0_P1_SHOOT (1<<4)
#define MOONCRST_IN0_P1_RIGHT (1<<3)
#define MOONCRST_IN0_P1_LEFT  (1<<2)
#define MOONCRST_IN0_COIN2    (1<<1)
#define MOONCRST_IN0_COIN1    (1<<0)
#define MOONCRST_IN1_PORT 0xA800
#define MOONCRST_IN1_SW2 (1<<7)
#define MOONCRST_IN1_SW1 (1<<6)
#define MOONCRST_IN1_NOT_USED (1<<5)
#define MOONCRST_IN1_P2_SHOOT (1<<4)
#define MOONCRST_IN1_P2_RIGHT (1<<3)
#define MOONCRST_IN1_P2_LEFT (1<<2)
#define MOONCRST_IN1_2P_START (1<<1)
#define MOONCRST_IN1_1P_START (1<<0)
#define MOONCRST_DSW_PORT 0xB000
#define MOONCRST_DSW_SW6  (1<<3)
#define MOONCRST_DSW_SW5  (1<<2)
#define MOONCRST_DSW_SW4  (1<<1)
#define MOONCRST_DSW_SW3  (1<<0)

/* The End */

#define THEEND_IN0_PORT 0x8100
#define THEEND_IN0_P1_RIGHT (1<<5)
#define THEEND_IN0_P1_LEFT  (1<<4)
#define THEEND_IN0_P1_SHOOT (1<<3)
#define THEEND_IN0_COIN1    (1<<2)
#define THEEND_IN1_PORT 0x8101
#define THEEND_IN1_1P_START (1<<0)
#define THEEND_IN1_MASK (1<<7)
#define THEEND_DSW_PORT 0x8102
#define THEEND_DSW_MASK  (1<<0)

/****************************************************/
/*                     Output Ports                 */
/****************************************************/

/* Galaxian */

#define GALAXIAN_END_OF_ROM      0x2800
#define GALAXIAN_LAMP_1          0x6000
#define GALAXIAN_LAMP_2          0x6001
#define GALAXIAN_LAMP_3          0x6002
#define GALAXIAN_SOUND_RESET_F1  0x6800
#define GALAXIAN_SOUND_RESET_F2  0x6801
#define GALAXIAN_SOUND_RESET_F3  0x6802
#define GALAXIAN_SOUND_NOISE     0x6803
#define GALAXIAN_SOUND_NOT_USED  0x6804
#define GALAXIAN_SOUND_SHOOT     0x6805
#define GALAXIAN_SOUND_VOLUME_F1 0x6806
#define GALAXIAN_SOUND_VOLUME_F2 0x6807
#define GALAXIAN_NMI             0x7001
#define GALAXIAN_STARS           0x7004
#define GALAXIAN_HFLIP           0x7006
#define GALAXIAN_VFLIP           0x7007
#define GALAXIAN_SOUND_FREQUENCY 0x7800

/* Moon Cresta */

#define MOONCRST_END_OF_ROM      0x4000
#define MOONCRST_LAMP_1          0xA000
#define MOONCRST_LAMP_2          0xA001
#define MOONCRST_LAMP_3          0xA002
#define MOONCRST_SOUND_RESET_F1  0xA800
#define MOONCRST_SOUND_RESET_F2  0xA801
#define MOONCRST_SOUND_RESET_F3  0xA802
#define MOONCRST_SOUND_NOISE     0xA803
#define MOONCRST_SOUND_NOT_USED  0xA804
#define MOONCRST_SOUND_SHOOT     0xA805
#define MOONCRST_SOUND_VOLUME_F1 0xA806
#define MOONCRST_SOUND_VOLUME_F2 0xA807
#define MOONCRST_NMI             0xB000
#define MOONCRST_STARS           0xB004
#define MOONCRST_HFLIP           0xB006
#define MOONCRST_VFLIP           0xB007
#define MOONCRST_SOUND_FREQUENCY 0xB800


/* Amidar */

#define THEEND_END_OF_ROM 0x4000
