/***************************************************************************

  Arcade Emulator v0.2 by Robert Anschuetz (anschuer@orlando.veda.com)

  Usage:
  arcade <name of the game to run> <graphics mode>

  Valid values for the game parameter are:
  Galaxian - Galaxian (Midway US) *default
  Galnamco - Galaxian (Namco Japan)
  Galturbo - Galaxian (Turbo)
  Supgalax - Super Galaxians
  Galapx   - Galaxian Part X
  Warofbug - War of the Bugs
  Pisces   - Pisces
  Mooncrst - Moon Cresta
  Theend   - The End
  Amidar   - Amidar
  Turtles  - Turtles
  Frogger  - Frogger

  Valid graphics modes are
  0 - VESA  640x480
  1 - MODEX 256x256

  Example:
  arcade galaxian 1 - will run Galaxian in MODEX

  Lots of help from Martin Scragg's Moon Cresta Emulator

  Lots of help from Ville Laitinen's The End Emulator

  Z80 engine by Marat Fayzulin and Marcel de Kogel

  Emulator framework built by Allard van der Bas (avdbas@wi.leidenuniv.nl)
                          and Nicola Salmoria (MC6489@mclink.it)

  Video mode created using Tweak 1.6b by Robert Schmidt, who also wrote
  TwkUser.c.

  If you find out something useful, don't hesitate to submit it to :
  The arcade emultion programming repository.

  So it will be available to everyone at :
  http://valhalla.ph.tn.tudelft.nl/emul8

  Send it by email to :
  avdbas@wi.leidenuniv.nl

  Version History
  ---------------
  Arcade Emulator
  0.2 01/15/97
  - Made code more robust (followed Multipac example)
  - Added screen shot capability
  - Added Frogger support
  - Added Galaxian Turbo support
  - Changed priority of sprites

  0.1 01/09/97
  - Added Moon Cresta support
  - Added The End support
  - Added Amidar support
  - Added Turtles support
  - Added Joystick support
  - Added MODEX (256x256) support
  - Fixed some bugs

  Galaxian Emulator
  0.2 01/08/97
  - Added PC speaker sound support
  - Synchronized interrupt
  - Added Up/Down control for War of the Bugs
  - Added Dipswitch modification mode
  - Vastly improved colors
  - Major sprite problems fixed

  0.1 01/07/97
  - Initial Release

  Known problems:
  - No star field in some games
  - Dip switches do not work in most games (need memory maps!)
  - Sound does not work in most games (ditto!)
  - No two player support in The End, Amidar, or Turtles (ditto!)
  - Bullets are not done correctly in firing games
  - Colors not correct in many games
  - Sound is very primitive
  - Extraneous characters appear in War of the Bugs attract mode
  - Sprite problems in second wave of Pisces
  - Turtles exits upon starting on some computers
  - Frogger runs way too fast, move left and right doesn't work right
  - Speed throttling incorrect in some games
  - Palette not correct in screen snapshot

  Help on any of the above problems would be greatly appreciated!

  File/Directory Structure:
  In the same directory as the program, create directories called
  GALAXIAN, SUPGALAX, GALAPX, WAROFBUG, PISCES, MOONCRST, AMIDAR,
  TURTLES, FROGGER, and GALTURBO and copy the ROM images there.
  The ROM naming convention is as follows:

  Galaxian (Midway US)
  --------------------
  galaxian.1j
  galaxian.1k
  galaxian.u
  galaxian.v
  galaxian.w
  galaxian.y
  galaxian.z

  Galaxian (Namco Japan)
  ----------------------
  galnamco.1j
  galnamco.1k
  galnamco.u
  galnamco.v
  galnamco.w
  galnamco.y
  galnamco.z

  Super Galaxians
  ---------------
  supgalax.1j
  supgalax.1k
  supgalax.u
  supgalax.v
  supgalax.w
  supgalax.y
  supgalax.z

  Galaxian Part X
  ---------------
  galapx.1j
  galapx.1k
  galapx.u
  galapx.v
  galapx.w
  galapx.y
  galapx.z

  Galaxian (Turbo)
  ----------------
  galturbo.1j
  galturbo.1k
  galturbo.u
  galturbo.v
  galturbo.w
  galturbo.y
  galturbo.z

  War of the Bugs
  ---------------
  warofbug.1j
  warofbug.1k
  warofbug.u
  warofbug.v
  warofbug.w
  warofbug.y
  warofbug.z

  Pisces
  ------
  pisces.1j
  pisces.1k
  pisces.a1
  pisces.a2
  pisces.b2
  pisces.c1
  pisces.d1
  pisces.e2

  Moon Cresta
  -----------
  EPR194
  EPR195
  EPR196
  EPR197
  EPR198
  EPR199
  EPR200
  EPR201
  EPR202
  EPR203
  EPR171
  EPR172

  The End
  -------
  IC13
  IC14
  IC15
  IC16
  IC17
  IC18
  IC55
  IC56
  IC30
  IC31

  Amidar
  ------
  amidar.2c
  amidar.2e
  amidar.2f
  amidar.2h
  amidar.5f
  amidar.5h

  Turtles
  -------
  turt_vid.2c
  turt_vid.2e
  turt_vid.2f
  turt_vid.2h
  turt_vid.2j
  turt_vid.5f
  turt_vid.5h

  Frogger
  -------
  frogger.ic5
  frogger.ic6
  frogger.ic7
  frogger.ic8
  frogger.606
  frogger.607

  Run-time Keys:

  1     Start 1 player game
  2     Start 2 player game (Most Games)
  3     Insert Coin
  Left  Move Left
  Right Move Right
  Up    Move Up (Some Games)
  Down  Move Down (Some Games)
  Ctrl  Fire,Jump,Bomb (Some Games)
  F6    Screen Snapshot
  F7    Joystick Toggle
  F8    Sound Toggle
  F9    Modify Dipswitches (Some Games)
        (Hold F9 and Press F1-F6 to Toggle Dipswitches 1-6)
  F10   Pause/Resume Game
  ESC   Exit

***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "gfxdecod.h"
#include "machine.h"
#include "osdepend.h"


int             main(int argc, char **argv)
{
    if (argc > 2)
    {
        if (argv[2][0] == '0')
            graphicsmode = VESA;
        else if (argv[2][0] == '1')
            graphicsmode = MODEX;
    }
    if (init_machine(argc > 1 ? argv[1] : "galaxian") == 0)
    {
        printf("\nPLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
               "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
               "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
               "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n"
               "\n\n"
               "  1     Start 1 player game\n"
               "  2     Start 2 player game\n"
               "  3     Insert Coin\n"
               "  Left  Move Left\n"
               "  Right Move Right\n"
               "  Up    Move Up (Some Games)\n"
               "  Down  Move Down (Some Games)\n"
               "  Ctrl  Fire,Jump,Bomb (Some Games)\n"
               "  F6    Screen Snapshot\n"
               "  F7    Joystick Toggle\n"
               "  F8    Sound Toggle (Some games)\n"
               "  F9    Modify Dipswitches (Some Games)\n"
             "        (Hold F9 and Press F1-F6 to Toggle Dipswitches 1-6)\n"
               "  F10   Pause/Resume Game\n"
               "  ESC   Exit\n"
               "\n\nPress any key to continue\n");

        getch();

        if (osd_init() == 0)
        {
            if (run_machine() != 0)
                printf("Unable to start emulation\n");

            osd_exit();
        }
        else
            printf("Unable to initialize system\n");
    }
    else
        printf("Unable to initialize machine emulation\n");

    exit(0);
}
