// Copyright 1993, 1995 by Jon Dart. All Rights Reserved.

#include "stdafx.h"
#include "pinfo.h"

Pool Position_Info::allocator;

Position_Info::Position_Info()
{
}

Position_Info::Position_Info( const Board &board, int rep_count )
{
    my_hashcode = board.HashCode();
    int16 x = (int16)(board.CastleStatus(Black));
    int16 y = (int16)(board.CastleStatus(White));
    int16 z = (int16)(board.EnPassantSq(board.OppositeSide())) & 0x3f;
    my_xhashcode = x | (y << 3) | (z << 8) | (rep_count << 6);
    if (board.Side() == Black)
      my_xhashcode |= 0x8000;
}

Position_Info::Position_Info( const Board &board, const int depth,
                              const int iter,
	           	      const ValueType hashflags,
			      const BOOL forced,
			      const int rep_count,
			      const int value,
			      const Move &best_move)
:  my_depth((signed char)depth),
   my_iteration((unsigned char)iter),
   my_hashcode(board.HashCode()),
   my_value(value),start(best_move.StartSquare()),
   dest(best_move.DestSquare()),
   promotion(best_move.PromoteTo())
{
    my_flags = (byte)hashflags;
    if (forced)
        my_flags |= 0x80;
    ASSERT(rep_count <= 3);
    // The "xhashcode" byte holds info on castling and en passant
    // status.
    int16 x = (int16)(board.CastleStatus(Black));
    int16 y = (int16)(board.CastleStatus(White));
    int16 z = (int16)(board.EnPassantSq(board.OppositeSide())) & 0x3f;
    my_xhashcode = x | (y << 3) | (z << 8) | (rep_count << 6);
    if (board.Side() == Black)
      my_xhashcode |= 0x8000;
}

Move Position_Info::best_move() const
{
        return Move(start,dest,promotion);
}




