// Copyright 1994 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "piece.h"
#include "constant.h"
#include <string.h>
#include <ctype.h>

static const unsigned PieceValues[] = 
{
   0,
   64,
   192,
   212,
   320,
   576,
   2000,
   0
};

static const char Images[] = "?PNBRQK?";

Piece::Piece( PieceType type )
{
   my_piece = type;
}

const Piece &Piece::EmptyPiece()
{
   static Piece p(Piece::Empty);
   return p;
}

const BOOL Piece::sliding() const
{
   PieceType t = Type();
   return t == Rook || t == Bishop || t == Queen;
}

const Piece &Piece::InvalidPiece()
{
   static Piece p(Piece::Invalid);
   return p;
}

unsigned Piece::Value() const
{
    return PieceValues[Type()];
}

unsigned Piece::Value( PieceType type)
{
    return PieceValues[type];
}

Piece::PieceType Piece::Value( const char c )
{
    const char *p = Images;
    p = strchr(p,c);
    if (p)
       return (PieceType)(p-Images);
    else
       return Piece::Invalid;
}

char Piece::Image(const Piece::PieceType p)
{
    return Images[p];
}
