// Copyright 1993, 1995, 1996 by Jon Dart.  All Rights Reserved.

#ifndef _OPTIONS_H
#define _OPTIONS_H

#include "search.h"
#include "timectrl.h"
#include "bookdefs.h"
#include "types.h"
#include <string.h>

#define Max_Time_Controls 2

struct GeneralPreferences
{
   BOOL beep_after_move;
   BOOL beep_on_error;
   BOOL can_resign;
   BOOL think_when_idle;
};

struct OpeningPreferences
{
   BOOL use_book;
   enum styles style;
};

struct SearchOps
{
   int null_depth; // 0, 1, or 2
   int killers; // 0, 1, or 2
   BOOL check_extensions;
   BOOL pawn_push_extensions;
   BOOL forced_extensions;
   BOOL history;
   BOOL auto_size_hash_table;
   int hash_table_size;
};

class Options
{
public:	
   
#ifdef _WINDOWS
   Options(CWinApp *app);
#else
   Options();
#endif
   
   virtual ~Options();
   
   const Time_Control &get_time_control( 
	Control c = First ) const
   {
      return tc[c];	   
   }
 
   void set_time_control( const Time_Control &t,
	   Control c = First )
   {
      tc[c] = t;
   }
   
   BOOL beep_after_move() const
   {
      return gprefs.beep_after_move;	   
   }
	
   BOOL beep_on_error() const
   {
      return gprefs.beep_on_error;
   }
	
   BOOL can_resign() const
   {
      return gprefs.can_resign;
   }
	
   BOOL think_when_idle() const
   {
      return gprefs.think_when_idle;
   }
   
   BOOL use_book() const
   {
      return oprefs.use_book;
   }
   
   enum styles book_style() const
   {
      return oprefs.style;
   }
   
   void update_general_preferences( const GeneralPreferences &p );
   
   void get_general_preferences( GeneralPreferences &p );
   
   void update_opening_preferences( const OpeningPreferences &p);
   
   void get_opening_preferences( OpeningPreferences &p);
   
   void update_search_ops( const SearchOps &s);
   
   void get_search_ops( SearchOps &ops) const;
   
   BOOL use_history() const
   {
      return src_opts.history;
   }
   
   BOOL num_killers() const
   {
      return src_opts.killers;
   }
   
#ifdef _WINDOWS
   void set_app_geometry(int x, int y, int w, int h);
   
   void get_app_geometry(int *x, int *y, int *w, int *h);
   
   void get_colors(COLORREF *light, COLORREF *dark);
   
   void set_colors(COLORREF light, COLORREF dark);
	
   void save();
#endif   
   
private:	
    Time_Control tc[2];
    GeneralPreferences gprefs;
    OpeningPreferences oprefs;
    SearchOps src_opts;
#ifdef _WINDOWS    
    int appX, appY, appW, appH;
    COLORREF lightColor, darkColor;
    CWinApp *myApp;
    void get_src_opts( CWinApp *app, const Control c,
       Search_Type &my_search_type, Search_Limit &my_search_limit);
    void set_src_opts( CWinApp *app, const Control c,
       const Search_Type my_search_type,
       const Search_Limit &my_search_limit);
#endif    
};

#endif


