// Copyright 1992 by Jon Dart.  All Rights Reserved.

#ifndef _MOVE_GENERATOR_H
#define _MOVE_GENERATOR_H

#include "board.h"
#include "constant.h"
#include "move.h"

class Move_Generator
{
	public:
		
        enum {MaxMoves = 200};		
		
	Move_Generator( const Board &ABoard, const unsigned ply,
	   const Move &last_move );
	~Move_Generator();
	
	int Generate_Moves( Move *moves, 
		const BOOL repeatable = FALSE );
	// fills array "moves" with moves, returns # of moves (0 if
        // no more).  If repeatable = True, generate moves in a predictable
        // order.  If captures_only = True, generate capture moves only
        // (ignored if the side to move is in check).
        // 		
        // The moves returned are generally "pseudo-legal", i.e. they may
        // involve moves into check.  However, if the side to move is in
        // check, all moves returned are strictly legal.		
		
	int Generate_Captures( Move *moves);
	// Like Generate_Moves, but only generates captures, promotions,
        // and check evasions.  Moves are ordered by "goodness".
		
	unsigned Check_Evasions( Move *moves, BOOL captures_only );
	// returns a list of the moves that may be used to escape
        // check.  Unlike the regular move generation routine, all
        // moves are checked for legality.
		
	private:
		
	int my_ply;
	Move my_last_move;
	const Board &board;

	inline void SetMove( const Square source, const Square dest,
		const Piece::PieceType promotion,
		Move *moves, unsigned &NumMoves);

};

#endif
