// Copyright 1993 by Jon Dart.  All Rights Reserved

// This module handles the display of the board.

#include "board.h"
#include "search.h"
#include <time.h>

#ifndef __AFXWIN_H__
#include <afxwin.h>
#endif

class Display
{
public:

     Display( CWnd *win, const CRect &initial_size );
     
     ~Display();
     
     const CRect set_size( const CRect &size);

     const CRect & get_size() const
     {
        return display_area;
     }

     void square_rect( const Square &, CRect & );
     // update CRect with the boundary of the given square.

     void draw_board( CDC *, const Board &, 
                      const CRect *draw_Area,
                      BOOL show_text = TRUE);
     void draw_piece( CDC *, const Square&, const Piece & );
     void draw_square( CDC *, const Square & );
     void highlight_square( CDC *, const Square & );
     void unhighlight_square( CDC *, const Square & );
     
     void set_turned( BOOL turnit );
     BOOL is_turned() const
     {
             return turned;
     }

     Square mouse_loc( CPoint &);
     // given where the mouse is, tell us what square it's on.
     
     void show_side( CDC *, const ColorType side );
     // show side to move
             
     void show_move( CDC *, const char *move_image,
             int number );
     // show last move made. 
             
     void show_status( CDC *, const Search::Statistics stats);
     // show status afer last move.
     
     void show_status( CDC *, const char *message);
     
     static void show_time( HWND handle, const time_t time, 
             const ColorType side );
     // show elapsed time for 'side'.  This takes a handle rather than
     // a WPDevContext and is static so that it can be called from within
     // a callback fn.       
             
     void clear_search_counts(  CDC *dc );
     // clear the "ply" and "nodes" display region.

     void clear_move_area( CDC *dc );
     // clear the region that displays the last move.

     void clear_status_line( CDC *dc );
     // erase the area for search messages (e.g. "Check")

     void show_eco( CDC *dc, LPCSTR code, LPCSTR opening_name);

     void show_players( CDC *dc, LPCSTR str);
     
     static void show_search_counts( HWND handle, const int ply,
             const long nodes);
     // show status during a search.

     // Return true if running on a monochrome system.
     static BOOL is_mono()
     {
        return mono;
     }
     
private:
     void draw_piece(CDC *dc, const Square &loc,
                       const CRect &square,CBitmap *bitmap,
                       const ColorType color, CBitmap *outline = NULL);
     void draw_piece( CDC *dc, const Square &loc, const CRect &square, const Piece &piece);
     // Get an appropriate brush for drawing the square's background
     CBrush *get_brush(CDC *dc, const Square &sq);

     CRect display_area;
     int square_width;
     int square_height;
     int yDir;
     BOOL turned;
     int width, height; // size of display area
     int vertical_border_width, horiz_border_height;
     int max_char_width, char_width, char_height;
     static int spacing;
     static BOOL mono;
};
