// Copyright 1995 by Jon Dart.  All Rights Reserved.
// colorpag.cpp : implementation file
//

#include "stdafx.h"
#include "colorpag.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorPage property page

IMPLEMENT_DYNCREATE(CColorPage, CPropertyPage)

CColorPage::CColorPage() : CPropertyPage(CColorPage::IDD)
{
	//{{AFX_DATA_INIT(CColorPage)
	//}}AFX_DATA_INIT
}

CColorPage::~CColorPage()
{
}

void CColorPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorPage)
	DDX_Control(pDX, IDC_LIGHTCOLOR, m_lightColor);
	DDX_Control(pDX, IDC_DARKCOLOR, m_darkColor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CColorPage, CPropertyPage)
	//{{AFX_MSG_MAP(CColorPage)
	ON_BN_CLICKED(IDC_CHOOSEDARK, OnChoosedark)
	ON_BN_CLICKED(IDC_CHOOSELIGHT, OnChooselight)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CColorPage message handlers

int CColorPage::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CPropertyPage::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// select the appropriate button based on colors

        m_darkColor.setColor(darkColor);
        m_lightColor.setColor(lightColor);
	return 0;
}


void CColorPage::OnChoosedark() 
{
    CColorDialog clrDlg(darkColor,0,this);
    if (clrDlg.DoModal() == IDOK)
    {
       darkColor = clrDlg.GetColor();
       m_darkColor.setColor(darkColor);
    }	
}

void CColorPage::OnChooselight() 
{
    CColorDialog clrDlg(lightColor,0,this);
    if (clrDlg.DoModal() == IDOK)
    {
       lightColor = clrDlg.GetColor();
       m_lightColor.setColor(lightColor);
    }	
}


