DECLARE SUB GetTemp (Rt!, T!)
  R25 = 3000        'Thermister Value at 25 deg C
  DC = .0025        'Dissipation Constant
  Ts = 32           'Starting Temperature
  Rc = 2543         'Initial values of voltage divider
  Rb = 5572
  DR = 2            'Number of series diode voltage drops
GOSUB Help: Flag = -1
  SCREEN 9
  WIDTH 80, 43
DO UNTIL a$ = "Q"
  CLS
  LOCATE 1, 15: PRINT "Plot of Temperature curves for the APRS MicEncoder"
  LOCATE 3, 20: PRINT "for determining the values of Rc and Rb"
  LOCATE 5, 20: PRINT "Rc ="; INT(Rc)
  LOCATE 7, 20: PRINT "Rb ="; INT(Rb)
  LOCATE 9, 20: PRINT "Diodes="; DR
  LINE (150, 30)-(240, 72), 12, B
 
  LOCATE 5, 38: PRINT "Yellow = True  Temp"
  LOCATE 7, 38: PRINT "Green  = Mic-E Temp"
  LOCATE 9, 38: PRINT "R@25C ="; R25
  LINE (294, 30)-(448, 40), 14, B
  LINE (294, 46)-(448, 56), 10, B
  LINE (294, 62)-(448, 72), 9, B
 
  LOCATE 15, 35: PRINT "Error Plot F"
  LINE (266, 110)-(376, 120), 13, B
  LOCATE 17, 40: PRINT "+2"
  LOCATE 19, 40: PRINT " 0"
  LOCATE 21, 40: PRINT "-2"
  LINE (16, 132)-(640, 132), 7
  LINE (16, 148)-(640, 148), 15
  LINE (16, 164)-(640, 164), 7
 
  LINE (16, 284)-(630, 284), 15 'Zero Axis
  LOCATE 40, 45: PRINT "Equivalent Source Impedance to Mic"
  LINE (352, 312)-(624, 320), 11, B
  GOSUB ChooseC
  FOR i = 36 TO 6 STEP -2
      LOCATE i, 1: PRINT (36 - i) * .5      '(1k every 2 lines)
      LOCATE i, 76: PRINT 32 + (36 - i) * 5 '(10every 2 lines)
  NEXT i
 
  LOCATE 6, 1: PRINT "RESISTANCE": LOCATE 6, 70: PRINT "TEMPERATURE";
  LOCATE 8, 5: PRINT "K Ohms": LOCATE 8, 70: PRINT "F"
  LOCATE 36, 36: PRINT "TEMPERATURE"
  
  FOR Tf = Ts TO Ts + 100 STEP 5
      GOSUB GetRes
      Re = Rb * Rt / (Rb + Rt)     'Re = Rb in parallel with Rt
      Vt = (5 * Rc / (Rc + Re))    'Voltage divider eqution
      Pd = ((5 - Vt) ^ 2) / Rt     'Power dissipated in Thermister
      dT = Pd / DC                 'Delta Temp in C due to dissipation
      dF = dT * 9 / 5              'Delta Temp in F due to dissipation
      Tp = Tf + dF                 'Presumed temperature adjusted
      Count = CINT((Vt - DR * .65) * 255 / 5)'A/D count
      Xtf = 32 + (Tp - Ts) * 6'Horizontal axis
      Yrt = 284 - .001 * 16 * Rt   'Res curve  16 lines= 1K
      Yre = 284 - .001 * 16 * Re   'Res curve  16 lines= 1K
      Ytt = 284 - .1 * 16 * (Tp - Ts)'Temp curve   16 lines= 10 deg
      Yct = 284 - .1 * 16 * (Count - Ts)'A/D curve
      Ydl = 148 - 8 * (Tp - Count) 'Error curve
      X = Xtf * 80 / 640
      IF X > 1 AND X < 77 THEN LOCATE 38, X: PRINT MID$(STR$(CINT(Tf)), 2)
      IF Re > 9000 THEN LINE (Xtf0, Yrt)-(Xtf, 124), 4, BF
      LINE (Xtf, 90)-(Xtf, 296), 1
      LINE (Xtf0, Yrt0)-(Xtf, Yrt), 9: CIRCLE (Xtf, Yre), 2, 11
      LINE (Xtf0, Ytt0)-(Xtf, Ytt), 14
      LINE (Xtf0, Yct0)-(Xtf, Yct), 10
      LINE (Xtf0, Ydl0)-(Xtf, Ydl), 13
      Xtf0 = Xtf: Ytf0 = Ytf: Yct0 = Yct: Ydl0 = Ydl: Ytt0 = Ytt: Yrt0 = Yrt
  NEXT Tf
  LOCATE 43, 4: PRINT "Adjust Rc/Rb with ARROW keys.  H=Help,  M=Modify,  Q=Quit";
  a$ = ""
  DO WHILE a$ = ""
     a$ = UCASE$(INKEY$)
     IF a$ <> "" THEN
        IF TIMER - LastKey < .2 THEN Factr = 1.1 ELSE Factr = 1.01
        LastKey = TIMER
        IF UCASE$(a$) = "Q" THEN
        ELSEIF a$ = CHR$(0) + CHR$(72) THEN Rc = Rc * Factr
        ELSEIF a$ = CHR$(0) + CHR$(80) THEN Rc = Rc / Factr
        ELSEIF a$ = CHR$(0) + CHR$(75) THEN Rb = Rb / Factr
        ELSEIF a$ = CHR$(0) + CHR$(77) THEN Rb = Rb * Factr
        ELSEIF a$ = "M" THEN GOSUB Modify
        ELSEIF a$ = "H" THEN GOSUB Help: a$ = "H"
        END IF
     END IF
  LOOP
LOOP
END  'End of main program

GetRes: 'This calculates the RESISTANCE from the Thermister given Temp
        Tk = 5 * (Tf - 32) / 9 + 273
        Rt = R25 * EXP((LnA - C * LOG(Tk) + D / Tk))
        RETURN

Help: CLS
PRINT "Mic-Temp.exe"
PRINT
PRINT "The purpose of this program is to permit the selection of the best bias"
PRINT "resistors for the Thermister so that the resulting 0 to 255 telemetry "
PRINT "value equals the actual temperature.   Although this is not necessary,"
PRINT "because APRS can accept the telemetry equations for conversion of the"
PRINT "values on receive, it is desirable in most simple applications so that"
PRINT "                                     the unique telemetry equations do"
PRINT " 5 volts *-----*-----*               not have to be transmitted to APRS"
PRINT "               |     |               over the air."
PRINT "               \     \"
PRINT "           Rb  /     / Thermister"
PRINT "               \     \"
PRINT "               |     |     .65"
PRINT "               *-----*------>|-------> to Mic-E AD-2 input"
PRINT "                     |     volt"
PRINT "                     \     drop"
PRINT "                 Rc  /"
PRINT "                     \"
PRINT "                     |"
PRINT "         *-----------*-------------> Ground"
IF Flag = 0 THEN
   LOCATE 23, 1: INPUT "Hit ENTER key to continue"; a$
   LOCATE 23, 1:
END IF
PRINT "Notice that you cannot get the curve to match at all temps at once.  The initial";
PRINT "values of 2543 and 5572 are perfect between about 62 and 122F with 2 diode"
PRINT "voltage drops.  That is the best I could do.  You may adjust all of these values"
PRINT "and modify the program as needed to suit your requirements."
PRINT
PRINT "The +/- 2 degree Error scale only applies to the purple error curve..."
PRINT "Rapidly pressing the ARROW keys within .3 seconds speeds Resistance changes."
PRINT : PRINT

LOCATE 1, 38: PRINT SPACE$(27); "Mic-TEMP.EXE"
LOCATE 2, 38: PRINT SPACE$(39)
IF Flag THEN P = 41 ELSE P = 23
LOCATE P, 1: INPUT "Hit ENTER key to continue"; a$
LOCATE 3, 1
RETURN

ChooseC:
  IF Ts >= 32 THEN
     LnA = 9.92949      'Rt Equation Coeffs 0-50C
     C = 3.48346
     D = 2957.01
  ELSE LnA = 27.80891   'Rt Equation Coeffs -50-0C
       C = 6.18843
       D = 2218.28
  END IF
  Xtf0 = Ts
  Ytf0 = 284
  Yct0 = 284
  Ytt0 = 284
  Yrt0 = 284
  Ydl0 = 150
  RETURN

Modify: CLS
 PRINT "This program is written for Keystone thermister RL2007-1723-103-SA available"
 PRINT "from DIGIkey as part number KC004E-ND for about $2.  There are other models"
 PRINT "with the same equations but with different initial values at 25C as follows:"
 PRINT
 PRINT " R@25C  Disip Const  Part No    Price"
 PRINT " ------  -----------  ---------  -----"
 PRINT
 PRINT " 1000      .0035       KC001E-ND  $2.17"
 PRINT " 2000      .0025       KC002E-ND  $2.09"
 PRINT " 2786      .0025       KC003E-ND  $2.09"
 PRINT " 3000      .0025       KC004E-ND  $2.09"
 PRINT " 5000      .0010       KC005E-ND  $2.62"
 PRINT "10000      .0010       KC006E-ND  $2.62"
 PRINT
 PRINT "Remember that the Mic-E input drive impedance should be below 10K to minimize"
 PRINT "interaction between A/D inputs.   For this reason, a red line is drawn on the"
 PRINT "chart showing areas where the parallel value of Rb & Rt are greater than 10k."
 PRINT
 PRINT : PRINT "Enter Resistance at 25C ("; R25; ")";
       INPUT X$: IF X$ <> "" THEN R25 = VAL(X$)
       IF R25 < 1800 THEN DC = .0035
       IF R25 > 3500 THEN DC = .001
 PRINT : PRINT "Enter Number of 0.65 series diode voltage drops("; DR; ")";
       INPUT X$: IF X$ <> "" THEN DR = VAL(X$)
 PRINT : PRINT "Enter a different starting Temperature ("; Ts; ")";
       INPUT X$: IF X$ <> "" THEN Ts = VAL(X$)
       IF Ts < 0 THEN Ts = 0
       IF Ts > 100 THEN Ts = 100
 RETURN

