


	TITLE	EXAMPLE AMX SYSTEM CONFIGURATION
;
;AN AMX86 CONFIGURATION MODULE DEFINING ALL
;TASKS, TIMERS, QUEUES, STACKS, ETC. REQUIRED
;BY AMX86 FOR PROPER OPERATION
;(BUILT BY THE KADAK AMX86 CONFIGURATION BUILDER)
;
;TASK ADDRESSES
;
	EXTRN	AMTMRT:FAR	;TASK # 0 AMX86 TIMER TASK
	EXTRN	CONSIN:FAR	;TASK # 1
	EXTRN	PRTOUT:FAR	;TASK # 2
	EXTRN	SENSOR:FAR	;TASK # 3
	EXTRN	APLTSK:FAR	;TASK # 4
;
;RESTART PROCEDURE ADDRESSES
;
	EXTRN	AMTDRR:FAR	;TIME/DATE RESTART PROCEDURE
;or	EXTRN	AMTDPC:FAR	;TIME/DATE FOR IBM PC DOS
	EXTRN	AMRMRR:FAR	;RESOURCE MANAGER
	EXTRN	AABIA:FAR		;BUFFER MANAGER
	EXTRN	CONRST:FAR	;USER RESTART PROCEDURES
	EXTRN	PRTRST:FAR
	EXTRN	CLKRST:FAR
	EXTRN	SENRST:FAR
	EXTRN	GLORST:FAR
;
;APPLICATION TIMER PROCEDURES
;
	EXTRN	AMTDTR:FAR	;TIME/DATE TIMER PROCEDURE
	EXTRN	TMHRLY:FAR
	EXTRN	TMNOON:FAR
	EXTRN	TMSEC:FAR
;
;TIME/DATE USER SCHEDULER PROCEDURE
;
	EXTRN	TDSCHD:FAR
;
	PAGE
;THE AMX86 PARAMETER SEGMENT
AMXPAR	SEGMENT WORD 'CODE'
;
;ENTRY POINTS REQUIRED BY AMX86
;
	PUBLIC	AMTDT		;TASK DEFINITION TABLE
	PUBLIC	AMRPL		;RESTART PROCEDURE LIST
	PUBLIC	AMNUMQ		;NUMBER OF QUEUE BLOCKS
	PUBLIC	AMCLKP		;CLOCK PERIOD = # OF CLOCK
INTERRUPTS
	PUBLIC	AMTMRR		;TIMER PROCEDURE LIST
	PUBLIC	AMISTP		;AMX86 INTERRUPT STACK POINTER
;
;TIME/DATE PARAMETER TABLE ENTRY POINTS
;
	PUBLIC	AMTDFQ		;TIMER FREQUENCY
	PUBLIC	AMTDTM		;WORD DISPLACEMENT OF TIME/DATE
TIMER
	PUBLIC	AMTDRA		;A(TIME/DATE RAM BLOCK)
	PUBLIC	AMTDSH		;A(USER TIME/DATE SCHEDULER)
;
;TABLE OF APPLICATION TIMER DISPLACEMENTS ENTRY POINTS
;
	PUBLIC	TMTD		;TIME/DATE TIMER
	PUBLIC	HOURLY
	PUBLIC	MIDDAY
	PUBLIC	PERSEC
;
;TABLE OF INTEGER TASK NUMBERS ENTRY POINTS
;
	PUBLIC	TNTMR		;TASK # 0 AMX86 TIMER TASK
	PUBLIC	TNCONI		;TASK # 1
	PUBLIC	TNPRTO		;TASK # 2
	PUBLIC	TNSENS		;TASK # 3
	PUBLIC	TNAPPL		;TASK # 4
;
;RESOURCE MANAGER ENTRY POINTS
;
	PUBLIC	AMRDT		;RESOURCE DEFINITION TABLE
	PUBLIC	PRINTR		;RESOURCE NUMBER TABLE
	PUBLIC	MEMIO1
	PUBLIC	MEMIO2
	PUBLIC	ERRWIN
;
;BUFFER MANAGER ENTRY POINTS
;
	PUBLIC	AAPDT		;POOL DESCRIPTION TABLE
;
	PAGE
;AMX86 TASK DEFINITION TABLE
AMTDT	LABEL	DWORD
;
;AMX86 TIMER TASK (#0) IS THE HIGHEST PRIORITY
;TASK # 0
	DD	AMTMRT		;A(AMX86 TIMER TASK)
	DD	SPTMR		;A(TIMER TASK STACK)
	DW	0		;TASK ATTRIBUTES
	DW	0		;LEVEL 0 (UNUSED)
	DW	0		;LEVEL 1 (UNUSED)
	DW	0		;LEVEL 2 (UNUSED)
	DW	0		;LEVEL 3 (UNUSED)
;
;TASK # 1
	DD	CONSIN		;START ADDRESS
	DD	SPCONI		;STACK ADDRESS
	DW	0		;TASK ATTRIBUTES
	DW	0		;LEVEL 0 (UNUSED)
	DW	0		;LEVEL 1 (UNUSED)
	DW	0		;LEVEL 2 (UNUSED)
	DW	0		;LEVEL 3 (UNUSED)
;
;TASK # 2
	DD	PRTOUT		;START ADDRESS
	DD	SPPRTO		;STACK ADDRESS
	DW	0		;TASK ATTRIBUTES
	DW	8		;LEVEL 0
	DW	8		;LEVEL 1
	DW	8		;LEVEL 2
	DW	8		;LEVEL 3
;
;TASK # 3
	DD	SENSOR		;START ADDRESS
	DD	SPSENS		;STACK ADDRESS
	DW	0		;TASK ATTRIBUTES
	DW	8		;LEVEL 0
	DW	4		;LEVEL 1
	DW	4		;LEVEL 2
	DW	2		;LEVEL 3
;
;TASK # 4
	DD	APLTSK		;START ADDRESS
	DD	SPAPPL		;STACK ADDRESS
	DW	0		;TASK ATTRIBUTES
	DW	8		;LEVEL 0
	DW	8		;LEVEL 1
	DW	8		;LEVEL 2
	DW	8		;LEVEL 3
;
	DW	2 DUP(0FFFFH)	;END OF TASKS
;
;TABLE OF INTEGER TASK NUMBERS
;
TNTMR	DW	0
TNCONI	DW	1
TNPRTO	DW	2
TNSENS	DW	3
TNAPPL	DW	4
;
;AMX86 RESTART PROCEDURE LIST IN ORDER OF EXECUTION
;
	EVEN
AMRPL	LABEL	DWORD
	DD	AMTDRR		;TIME/DATE RESTART PROCEDURE
;or	DD	AMTDPC		;TIME/DATE FOR IBM PC DOS
	DD	AMRMRR		;RESOURCE MANAGER
	DD	AABIA		;BUFFER MANAGER
	DD	CONRST		;USER RESTART PROCEDURES
	DD	PRTRST
	DD	CLKRST
	DD	SENRST
	DD	GLORST
;
	DW	2 DUP(0FFFFH)	;END OF LIST
;
AMNUMQ	DW	300		;# OF SYSTEM QUEUE PARAMETER BLOCKS
AMCLKP	DW	1		;CLOCK PERIOD = # OF CLOCK INTERRUPTS
AMISTP	DD	AMISTK		;AMX86 INTERRUPT STACK POINTER
;
;AMX86 APPLICATION TIMER PROCEDURE LIST
;
AMTMRR	LABEL	DWORD
	DD	AMTDTR		;TIME/DATE TIMER PROCEDURE
	DD	TMHRLY
	DD	TMNOON
	DD	TMSEC
;
	DW	2 DUP(0FFFFH)	;END OF LIST
;
;TABLE OF APPLICATION TIMER DISPLACEMENTS
;
TMTD	DW	0		;TIME/DATE TIMER
HOURLY	DW	2
MIDDAY	DW	4
PERSEC	DW	6
;
;TIME/DATE USER PARAMETER TABLE
	EVEN
;
AMTDFQ	DW	18		;TIMER FREQUENCY
AMTDTM	DW	0		;WORD DISPLACEMENT OF TIME/DATE TIMER
AMTDRA	DD	TDRAM		;A(TIME/DATE RAM BLOCK)
AMTDSH	DD	TDSCHD		;A(USER TIME/DATE SCHEDULER)
;
;AMX86 RESOURCE DEFINITION TABLE
;
	EVEN
AMRDT	LABEL	WORD
	DW	4		;NUMBER OF RESOURCES
	DW	5		;QUEUEING DEPTH - RESOURCE # 1
	DW	3		;QUEUEING DEPTH - RESOURCE # 2
	DW	3		;QUEUEING DEPTH - RESOURCE # 3
	DW	8		;QUEUEING DEPTH - RESOURCE # 4
;
;RESOURCE IDENTIFICATION NUMBER TABLE
;
PRINTR	DW	1
MEMIO1	DW	2
MEMIO2	DW	3
ERRWIN	DW	4
;
;BUFFER POOL DESCRIPTION TABLE
;
	EVEN
AAPDT	LABEL	WORD
	DW	2		;NUMBER OF POOLS
	DD	RAM0		;POINTER TO RAM AREA FOR POOL # 0
	DW	16		;NUMBER OF BUFFERS IN POOL # 0
	DW	64		;SIZE OF BUFFERS IN POOL # 0
	DD	RAM1		;POINTER TO RAM AREA FOR POOL # 1
	DW	1024		;NUMBER OF BUFFERS IN POOL # 1
	DW	4		;SIZE OF BUFFERS IN POOL # 1
;
AMXPAR	ENDS			;END OF AMX86 PARAMETER SEGMENT
;
	PAGE
;THE AMX86 DATA SEGMENT
;
AMXDATA	SEGMENT WORD 'DATA'
;
	PUBLIC	AMDATA		;ENTRY POINT FOR AMX86 USE
;
AMDATA	LABEL	WORD
NT	EQU	5		;# OF TASKS IN SYSTEM
QB	EQU	300		;# OF QUEUE BLOCKS IN SYSTEM QUEUE
TQ	EQU	130		;# OF WORDS REQUIRED FOR TASK QUEUES
NTM	EQU	4		;# OF APPLICATION INTERVAL TIMERS
;
	DW	32 DUP(?)	;AMX86 PRIVATE STORAGE
	DW	(NT*32)+2 DUP(?) ;TASK CONTROL BLOCKS
	DW	(QB*9)+4 DUP(?)	;AMX86 SYSTEM QUEUE
	DW	TQ DUP(?)	;TASK QUEUE STORAGE
	DW	NTM DUP(?)	;TIMER LIST
;
;TIME/DATE RAM BLOCK
;
TDRAM	DB	9 DUP(?)
;
AMXDATA	ENDS			;END OF AMX86 DATA SEGMENT
;
	PAGE
;AMX86 STACK SEGMENTS
;
AMXESTK	SEGMENT WORD 'TSTACK'
	PUBLIC	AMESTK
	DW	512 DUP(?)
AMESTK	LABEL	WORD		;AMX86 EXECUTIVE STACK
AMXESTK	ENDS
;
AMXISTK	SEGMENT WORD 'MSTACK'
	DW	768 DUP(?)
AMISTK	LABEL	WORD		;AMX86 INTERRUPT STACK
AMXISTK	ENDS
;
AMXTSTK	SEGMENT WORD 'MSTACK'
	DW	128 DUP(?)
SPTMR	LABEL	WORD		;AMX86 TIMER TASK STACK
AMXTSTK	ENDS
;
;AMX86 LARGE TASK STACK SEGMENTS
;
CONITSTACK SEGMENT WORD 'TSTACK'
	DW	1024 DUP(?)
SPCONI	LABEL	WORD		;STACK FOR TASK # 1
CONITSTACK ENDS
;
PRTOTSTACK SEGMENT WORD 'TSTACK'
	DW	512 DUP(?)
SPPRTO	LABEL	WORD		;STACK FOR TASK # 2
PRTOTSTACK ENDS
;
SENSTSTACK SEGMENT WORD 'TSTACK'
	DW	1024 DUP(?)
SPSENS	LABEL	WORD		;STACK FOR TASK # 3
SENSTSTACK ENDS
;
APPLTSTACK SEGMENT WORD 'TSTACK'
	DW	1024 DUP(?)
SPAPPL	LABEL	WORD		;STACK FOR TASK # 4
APPLTSTACK ENDS
;
	PAGE
;AMX86 RESOURCE CONTROL TABLE
;
AMRMDATA SEGMENT WORD 'DATA'
;
	PUBLIC	AMRCT
;
	EVEN
AMRCT	DW	48 DUP(?)	;ALLOCATE STORAGE
;
AMRMDATA ENDS
;
	PAGE
;BUFFER POOL STORAGE AREAS
;
AABMDATA SEGMENT WORD 'DATA'
;
RAM0	DB	1094 DUP(?)	;RAM FOR POOL # 0
RAM1	DB	8198 DUP(?)	;RAM FOR POOL # 1
;
AABMDATA ENDS
;
	END
                                                                                                                     