program Launch;

uses
  Forms,
  SysUtils,
  Main in 'MAIN.PAS' {MainForm},
  Info in 'INFO.PAS' {InfoForm},
  Splash in 'SPLASH.PAS' {SplashForm},
  PrevInst in 'PREVINST.PAS',
  About in 'ABOUT.PAS' {AboutForm},
  Resource in 'RESOURCE.PAS' {ResourceForm};

{$R *.RES}

procedure CreateForms;
begin
  { This makes Delphi's automagic code editing features work a little better }
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TResourceForm, ResourceForm);
  Application.CreateForm(TInfoForm, InfoForm);
  Application.CreateForm(TAboutForm, AboutForm);
end;

var
  StartTime  : TDateTime;
  ShowSplash : Boolean;

begin
  ShowSplash := not ((ParamCount = 1) and (LowerCase(ParamStr(1)) = '/nosplash'));

  { If there's another instance already running, activate that one and
    terminate this one }
  if HPrevInst <> 0 then begin
    ActivatePreviousInstance;
    Exit;
  end;

  try
    if ShowSplash then begin
      { Create the splash screen }
      SplashForm := TSplashForm.Create(Application);

      { Show (and force updating of) the splash screen }
      SplashForm.Show;
      SplashForm.Update;
    end;

    { Create the forms }
    CreateForms;

    if ShowSplash then begin
      { Wait for a few seconds }
      StartTime := Now;
      repeat until Now-StartTime > 2.0/24.0/3600.0;

      { Hide the splash screen }
      SplashForm.Hide;
    end;

    { Position the resource form }
    ResourceForm.Top := 0;
    ResourceForm.Left := MainForm.Left+(MaxNrOfApps-3)*AppWidth;

    { Adjust the main form's size if the resources should be visible }
    if MainForm.Toggle1.Checked then begin
      MainForm.Width := MainForm.Width-3*AppWidth;
      ResourceForm.Show;
    end;

    { Run the application }
    Application.Run;
  finally
    if ShowSplash then
      { Free the splash screen }
      SplashForm.Free;
  end;
end.

