unit Info;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TInfoForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    IconNrStr: TEdit;
    IconFileStr: TEdit;
    InfoStr: TEdit;
    CmdStr: TEdit;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    Bevel1: TBevel;
    BitBtn2: TBitBtn;
    Label5: TLabel;
    DirStr: TEdit;
    procedure CmdStrDblClick(Sender: TObject);
    procedure IconFileStrDblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InfoForm: TInfoForm;

implementation

{$R *.DFM}

procedure TInfoForm.CmdStrDblClick(Sender: TObject);
begin
  with OpenDialog1 do begin
    { Set filters, initial directory and filename in the OpenDialog }
    Filter := 'Executable files|*.EXE;*.PIF|All files|*.*';
    InitialDir := ExtractFilePath(CmdStr.Text);
    FileName := CmdStr.Text;

    { If OK then get the filename from the OpenDialog }
    if Execute then
      CmdStr.Text := FileName;
  end;
end;

procedure TInfoForm.IconFileStrDblClick(Sender: TObject);
begin
  with OpenDialog1 do begin
    { Set filters in the OpenDialog }
    Filter := 'Executable files|*.EXE|Library files|*.DLL|Icon files |*.ICO|All files|*.*';
    if IconFileStr.Text = '' then begin
      { If there isn't any iconfile then the program file is the default }
      InitialDir := ExtractFilePath(CmdStr.Text);
      FileName := CmdStr.Text;
    end
    else begin
      { Set initial directory and filename in the OpenDialog }
      InitialDir := ExtractFilePath(IconFileStr.Text);
      FileName := IconFileStr.Text;
    end;
    { If OK then get the filename from the OpenDialog }
    if Execute then
      IconFileStr.Text := FileName;
  end;
end;

procedure TInfoForm.FormShow(Sender: TObject);
begin
  { Give the first edit box focus when the form is shown }
  CmdStr.SetFocus;
end;

end.
