                *** ANSIPLUS VERSION 4.01 RELEASE NOTES ***
                             Shareware Package

Thank you for evaluating ANSIPLUS.  This file briefly describes ANSIPLUS, lists
the files included in the ANSIPLUS Shareware package, gives quick installation
instructions, and describes recent changes made to ANSIPLUS.


What is ANSIPLUS?
---- -- ---------

The ANSIPLUS console device driver integrates major console elements missing
from DOS and the personal computer BIOS into a single compact device driver
that can easily be controlled and personalized.  With ANSIPLUS installed:

 * User interaction with the DOS command shell and many applications will be
   significantly improved.

 * Screen output will be faster than with DOS's ANSI and non-ANSI drivers.

 * The user will have complete control over colors and VGA/EGA capabilities.

 * Users of MS-DOS, Windows, OS/2, DESQview or Novell DOS will have access to
   ANSIPLUS features in all windowed and full screen DOS sessions.

 * The user will also benefit from all the other display and keyboard features
   provided by ANSIPLUS.


The ANSIPLUS enhanced DOS console device driver is tailored to take advantage
of VGA and EGA display capabilities:

 * It automatically adapts to VGA or EGA screen modes, both text and graphics,
   including extended modes with large numbers of lines and/or columns.  The
   driver also automatically compensates for older video controllers with very
   limited numbers of colors or shades (eg., CGA or monochrome boards).

 * In text and in 16-color VGA/EGA graphics display modes, the driver bypasses
   the BIOS and writes directly to the video RAM, so it can operate much faster
   than either the original DOS console driver or the DOS ANSI driver.

 * ANSIPLUS gives the user control over VGA/EGA palette registers and VGA DAC
   registers to select and maintain colors using the video controller's full
   capabilities.

 * Text character height can be selected in any VGA/EGA display mode, extending
   user control to the number of lines per display page.

 * Smooth scrolling is provided as an option (requires a faster computer, eg.,
   80386 with 16-bit VGA).



The ANSIPLUS driver efficiently integrates several useful console functions
that in the past had to be provided by separate TSR programs or device drivers:

 * A screen saver monitors display, keyboard and mouse activity.

 * Scroll-back lets the user examine lines that have scrolled off the top of
   the screen.

 * The mouse can be used to select text from the screen or from scroll-back and
   then paste it to keyboard input or copy it to the Windows clipboard.

 * Fast screen output can be frozen and released with the Scroll Lock key.

 * Keyboard buffer size is increased and configurable.

 * Undesired repeat keys are suppressed and several other key processing
   options are provided.

 * Keys can be added to the keyboard buffer under program control for later
   consumption by programs.

 * A timer-controlled beep tone generator allows user customizable tones.

Other ANSIPLUS features include:

 * Menu driven, mouse controllable utilities that give the user full control
   over selected colors, color palettes, border colors, video modes, text
   height, key reassignment, beep tone definition, driver table sizes, and all
   other configurable features.

 * Special loading options for XMS upper memory blocks, high memory area and
   expanded memory reduce low memory requirements to 6K or less.

 * Automatic recognition of and special support for Windows, OS/2, DESQview and
   other task switchers.

 * Highlighting of user-typed keys when they are displayed by DOS on the screen
   to give a clear visual separation of typed entries from computer output.

 * Support for all DOS ANSI.sys escape sequences, plus additional ANSI/VT-100
   escape sequences for clearing the screen, erasing lines, inserting and
   deleting lines, inserting and deleting characters, screen scrolling and
   tab control.

 * Free BBS updates.  Registered ANSIPLUS users can obtain free updates by
   installing future Shareware versions of ANSIPLUS over their registered
   copies.  The ANSIPLUS installation program will automatically register a
   Shareware copy when it is installed on a disk that boots a registered copy.

 * And much, much more.

See "Features Summary" in the ANSIPLUS documentation for more information about
ANSIPLUS features.


ANSIPLUS Packing List
-------- ------- ----

     File                Description
     ----                -----------

     ANSIPLUS.sys        ANSIPLUS console device driver
     ANSIPLSR.sys        ANSIPLUS reduced size device driver
     ANSIPLUS.doc        ANSIPLUS Shareware documentation
     SETCOLOR.exe        Color control utility program
     SETAPLUS.exe        Driver features control utility program
     ANSICOM.exe         ANSI escape sequence editor
     NEWAPLUS.exe        ANSIPLUS bootup configuration program
     APLUSLIB.exe        Execution library for the utility programs
     SETCOLOR.sch        Color schemes file for SETCOLOR.exe
     CONSETUP.com        Sample escape sequence program
     PUSHVID.com         Save current video mode, video page and colors
     POPVID.com          Restore saved video mode, page and colors
     PUSHKEYS.com        Save current key reassignments
     POPKEYS.com         Restore saved key reassignments
     LOCKPAL.com         Lock the 16-color palette
     UNLOKPAL.com        Unlock the 16-color palette
     WINVGA16.com        MS Windows 16-color VGA driver palette change
     VWFD.386            Windowed vs. full screen test Windows VxD
     APLUS.pif           Sample Windows PIF file
     CPCH.bat            Change code page
     INSTALL.exe         Installation program
     INSTALL.inf         Installation control file
     INSTALL.cve         Installation data file
     REGISTER.pls        ANSIPLUS registration form
     README.pls          Release notes, this file


The documentation file, ANSIPLUS.doc, is a complete and up to date copy of the
ANSIPLUS Shareware manual, except for the section on ANSIPLUS Escape Sequences,
which are covered in detail only in the printed version.  The file is formatted
for 80 characters per line and 60 lines per page, and uses no special
characters or other printer control other than form feeds.


Quick Installation Instructions
----- ------------ ------------

Before installing ANSIPLUS, or any other new device driver, be sure you have a
bootable floppy disk as insurance against trouble getting your system to run
after the device driver is installed.

The ANSIPLUS package includes an installation and configuration program called
INSTALL.exe, which should properly handle most installations.  Context
sensitive help (via the F1 key) is provided for all entries.  The following
three examples illustrate using INSTALL to install ANSIPLUS:

 * If you received ANSIPLUS on a floppy disk and want to install it on your
   hard disk, use the following installation procedure:

    (1) Set the default directory to the hard disk (ie., get a C> prompt).
    (2) Insert the ANSIPLUS diskette in drive A: (or other floppy drive).
    (3) Enter the following command:

            A:INSTALL

 * If you received ANSIPLUS as a ZIP file, use the following procedure:

    (1) Create a temporary sub-directory  on the hard disk to contain the
        unzipped ANSIPLUS files. Move ANSIPLUS.zip to this directory and make
        it be the default directory. This directory must be different from the
        directory that will receive the installed ANSIPLUS files.
    (2) Unzip the files into the directory with the command:

            PKUNZIP ANSIPLUS

    (3) Then enter the command:

            INSTALL

 * To install ANSIPLUS on bootable disk B:, from hard disk directory C:\APLUS,
   enter the command:

            C:\APLUS\INSTALL B:

International users should be aware of the following:

 * If you are using the KEYB program to set up your keyboard, the following
   command MUST be executed after you load KEYB, otherwise most ANSIPLUS
   keyboard related features will not work:

            SETAPLUS LINK KEYEVENT

   The INSTALL program will automatically add this command to your AUTOEXEC.bat
   file if it finds a reference in it to KEYB.

 * If you are using the DISPLAY.sys device driver for code page switching, the
   ANSIPLUS device driver must be installed before DISPLAY.sys in your
   CONFIG.sys file.  The INSTALL program will also automatically handle this.

See "Installing ANSIPLUS" in the documentation for more information about
ANSIPLUS installation and configuration.


Recent ANSIPLUS Changes
------ -------- -------

 1/04/95 Version 4.01 released.

 1/04/95 Key repeat rates faster than 32 characters per second are now allowed
         for DOS sessions under Windows.

12/22/94 The screen saver will now issue VESA power management BIOS extension
         calls to reduce monitor power consumption.  The monitor is placed in
         standby mode after the screen has been blank for 5 minutes, suspend
         mode after 10 minutes, and turned off after 15 minutes.  This feature
         is disabled by default, but can be enabled by NEWAPLUS or SETAPLUS.

12/11/94 Three mouse related bug fixes/improvements:

          * Whenever Scroll Lock is on, Int 33h mouse queries made by
            applications now all report no mouse movement or button clicks.
            This keeps the application from taking any mouse-based actions
            until Scroll Lock has been released.  (However, applications that
            use a mouse exit routine to detect mouse clicks will still try to
            respond to the first click when Scroll Lock is on.  Thereafter,
            ANSIPLUS will control the mouse.)

          * When the screen is first scrolled back, if the application's mouse
            cursor was visible, it will now be hidden until Scroll Lock is
            released.  This prevents a "mouse dropping" from being left if the
            mouse is then used for copy/paste by ANSIPLUS while the screen is
            scrolled back.

          * When ANSIPLUS has been using the mouse, all button press and
            movement data are now cleared before the mouse is released back to
            the application.  This keeps the application from responding to
            clicks or motion that occurred while ANSIPLUS controlled the mouse.

12/06/94 Dragging the right mouse button can now be used to select text bounded
         by a rectangular area (for example, in a column) for copying to the
         clipboard.  The Tab key will also now toggle text selections between
         line and rectangular area views.

12/03/94 Bug fix: Because of an incorrectly assembled instruction, the ANSIPLUS
         test for A20 enabled was not working.  This caused the driver to crash
         if ANSIPLUS code was loaded to the HMA on a system without DOS=HIGH.

12/03/94 Bug fix: When using a monochrome or CGA video controller with less
         than 32K of directly addressable RAM, ANSIPLUS was assuming that 32K
         of video RAM could be used for scroll-back storage if no EMS memory
         was available.  The driver now determines the actual amount of video
         memory available.

10/20/94 4DOS 5.5 now supports color numbers on its internal COLOR command for
         selecting colors.  The ANSIPLUS SETCOLOR.exe utility program has also
         supported color selection by number for over two years, but in a
         different numerical order.  The new SETCOLOR "/4DOS" command tail
         option should be added for compatibility to use 4DOS's color ordering
         when SETCOLOR is defined as an alias for the 4DOS COLOR command.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

10/20/94 Bug fix: With Scroll Lock on and ANSIPLUS controlling the mouse, the
         ANSIPLUS Int 33h routine was returning the incorrect button status
         information to the running program in register AL for Int 33h
         functions 0005h and 0006h (get button press/release information).
         This could cause some programs to incorrectly conclude that a mouse
         button was being pressed when ANSIPLUS took over the mouse.

10/08/94 Video controller bug workaround: It has been reported that the ATI VGA
         Wonder fails to set the BIOS Regen Buffer Size variable at 40h:4Ch
         correctly in at least one extended text mode (5Bh), causing problems
         when ANSIPLUS clears the screen or addresses video pages.  Other video
         controllers may have similar problems.  As a workaround, when a text
         mode is selected, the ANSIPLUS driver will now correct the word at
         40h:4Ch if it is too small for all the rows and columns on the screen.

10/07/94 Bug fix: Esc [u would not restore the cursor position repeatedly once
         the ANSIPLUS 4.00 video context stack was empty.  This caused an
         incompatibility between ANSIPLUS and ANSI.sys Esc [s and Esc [u.

 9/29/94 Bug fix: SETAPLUS could not disable the "Prevent ANSI key reassignment
         redefinition" feature from the command line.

 9/28/94 Some "point-of-sale" keyboards include special "00" or "000" keys for
         entry of multiple zeros, but generate the zeros without simulating the
         lifting of the key between the characters.  Because ANSIPLUS will
         normally suppress repeated digits, the multiple-zero keys on these
         keyboards will enter only a single zero.  A configurable feature is
         now provided to allow repeated zeros when using such keyboards.

 9/28/94 Bug fix: The Russian keyboard uses character 0E0h for the lower case
         "er" character.  ANSIPLUS's DOS key input was incorrectly interpreting
         this key code as an Enhanced Keyboard key leadin, and suppressing it.

 9/08/94 Bug fix: As a result of changes for Release 4.00, the driver assumed
         that the VGA/EGA BIOS variable at 40h:84h always contained the number
         of screen lines.  This caused all output to be confined to the top
         screen line for the older MDA, CGA and Hercules video controllers.

 9/07/94 Bug fix: A Windows General Protection fault could occur when starting
         to scroll backwards if EMM386 was used with the NOEMS option, and if
         video RAM storage of scroll-back under Windows was also disabled.

 9/07/94 Bug fix: Keystack "/W" commands to insert time delays did not work
         correctly because key scan codes were being added to short delay times
         (up to 127 timer ticks), greatly increasing the delay.

 9/05/94 Bug fix: Mouse middle button functions in the 4DOS popup history
         window did not work as documented.

 9/05/94 The scroll-back bookmark at the current scrolled-back location can now
         be removed by hitting the Gray Minus key.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 9/03/94 Bug fix: In 132 column text modes only, lines with runs of more than
         127 identical (eg., blank) characters were compressed to scroll-back
         incorrectly, causing garbage to appear in the rightmost 5 columns of
         those lines when the screen was scrolled back.

 8/29/94 Version 4.00 released.

 8/24/94 The feature to preserve scroll-back data in XMS or HMA memory is now
         rarely needed because scroll-back generally resides in EMS memory.
         Because of this, if this feature is disabled at system bootup, the
         code to perform its function will now be deleted from the driver
         (saving 650 bytes), and the feature will be non-operational.

 8/20/94 The ANSIPLUS screen saver can now blank the screen under Windows when
         running in a full screen 386 Enhanced Mode DOS session.  This feature
         requires installation of the VWFD.386 Windows VxD, which is supplied
         with ANSIPLUS.  If VWFD.386 is not installed, the screen saver will be
         disabled under Windows.

 8/19/94 The ANSIPLUS driver now detects when VESA standard display modes are
         active and uses the VESA mode number in its analysis of text and
         graphic modes.

 8/16/94 When viewing scroll-back, the user can now set up to 6 "bookmarks" by
         using the Gray Plus key.  The marked page(s) can later be displayed
         instantly by hitting Gray Enter when Scroll Lock is on.

 8/16/94 The driver can now emulate the VT100 graphics character set, which is
         selected by the VT100 Esc (0 and Esc )0 escape sequences and is used
         by the VT100 to draw boxes around text on the screen.

 8/03/94 The INSTALL/NEWAPLUS program can now convert a Shareware ANSIPLUS.sys
         driver into a Registered ANSIPLUS.exe driver when installing to a disk
         that already contains a registered copy of ANSIPLUS.

 7/30/94 A second hot key combination now can be used to blank the screen
         immediately: Alt+Shift+Num Lock.

 7/28/94 A reduced-size version of the ANSIPLUS driver is now available.  This
         driver deletes five features, saving about 35 percent of the installed
         driver's size: scroll-back, copy/paste, direct video RAM output in
         graphics modes, graphics mode text treatments, and emulation of
         monochrome VGA on a color VGA.

 7/20/94 ANSIPLUS is now compatible with OS/2 2.x.  The driver can be loaded
         either by the DEVICE= command in CONFIG.sys or (for ANSIPLUS.exe) as a
         DOS TSR.  If loaded by the OS/2 CONFIG.sys file, the registered driver
         signon message will be suppressed when each new virtual DOS machine is
         started.  The unregistered Shareware driver will display the ANSIPLUS
         signon (with the 9 second delay) about one percent of the time.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 7/18/94 Bug fix: INSTALL/NEWAPLUS would search the current directory for
         ANSIPLUS files if the PATH in AUTOEXEC.bat ended with a semi-colon or
         contained consecutive semi-colons.  The installation would then fail
         because the target and source directories for files were the same.

 7/12/94 The mouse can now be used for text selection and keyboard paste
         operations.  These functions are available whenever Scroll Lock is on
         or when the currently running program or command shell does not use
         the mouse.  See "Special Keyboard and Mouse Functions" in Chapter 4 of
         the documentation for more information about this feature.

 7/09/94 When loading ANSIPLUS into UMBs ("/U") or HMA ("/H"), the shared code
         can now be split from the rest of the driver in two different places,
         depending on the amount of high memory available.  Either 6K or 11K
         will be left in low memory, and 28K or 23K will be in UMBs or HMA.

 6/29/94 Bug fix: If Scroll-Lock was activated while Int 16h function 00h or
         10h was waiting to read a character, the Scroll-Lock condition would
         not be enforced until after the next character was typed.

 6/22/94 The ANSIPLUS driver can now supply instance data to, and monitor the
         activities of, task switchers that use the Int 2Fh, AH=4Bh task
         switching interface functions.

 6/19/94 The Esc [s and Esc [u save and restore escape sequences now allow tags
         to identify items for later restoration.  Also added the capability to
         save and restore the current scrolling region boundaries, key
         reassignments, or scroll-back addition pointer.

 6/14/94 Added over two dozen new ANSI and ANSIPLUS escape sequences for
         scrolling, tab control, cursor positioning, and other functions:

          * Scrolling: scroll up (Esc [S), scroll up and add to scroll-back
            (Esc [!S), scroll down (Esc [T), scroll down from scroll-back (Esc
            [!T), scroll right (Esc [ A), scroll left (Esc [ @), insert lines
            from scroll-back (Esc [!L), delete lines and add to scroll-back
            (Esc [!M), set scrolling region (Esc [r).

          * Tab control: reset tabs (Esc [g), tab control (Esc [W), horizontal
            tab (Esc [I), vertical tab (Esc [Y), backward tab (Esc [Z), set
            horizontal tab (Esc H), set vertical tab (Esc J).

          * Cursor positioning: next line (Esc [E), preceding line (Esc [F),
            cursor horizontal absolute (Esc [G), cursor vertical absolute (Esc
            [d), cursor horizontal relative (Esc [a), cursor vertical relative
            (Esc [e), next line (Esc E).

          * Other functions: next page (Esc [U), preceding page (Esc [V),
            repeat character (Esc [b), erase character (Esc [X), time delay
            (Esc [!w).


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 6/03/94 Added several enhancements to ANSIPLUS driver initialization and to
         TSR installation to support loading ANSIPLUS when another copy of the
         driver has previously been loaded.  Also added special handling for
         initialization and execution under DESQview, and improved the TSR
         procedure to take over the system console.

 5/28/94 Bug fix: SETCOLOR SCHEME XXX got stuck in an error message loop if no
         scheme XXX existed.  The available color schemes are now listed when
         an unknown scheme name is supplied.

 5/24/94 Bug fix: The ANSIPLUS VGA screen blanking technique is apparently
         incompatible with a few VGA controllers (eg., Cirrus Logic GD610/20).
         For such controllers, a configurable feature has been added to use
         ANSIPLUS's EGA screen blanking method instead.

 5/24/94 Bug fix: The Novell DOS 7 version of KEYB.com does not steal key event
         interrupts (Int 09h) from drivers installed before it, while the
         MS-DOS KEYB program does.  The SETAPLUS LINK KEYEVENT command is
         therefore not needed for international users of Novell DOS, and the
         utility programs and documentation have been changed to handle this.

 5/18/94 Bug fix: In ANSIPLUS 3.10 only, the test for Windows running failed
         for Standard Mode, causing the screen saver to blank the Windows
         screen and other potential problems when Standard Mode was in use.
         Scroll-back is also now completely disabled for Windows Standard Mode.

 5/17/94 The driver now requires the VWFD.386 Windows VxD to be installed in
         order to use smooth scrolling under Windows.  VWFD.386 lets ANSIPLUS
         test whether the DOS virtual machine is running full screen or in a
         window.  Smooth scrolling is now used only for full screen DOS
         sessions.

 4/21/94 Bug fix: INSTALL.exe now tests for enough memory available to load
         (about 450K), and will exit with a message if there is not enough.
         The installation file copying process also will not abort if there is
         not enough memory to shell out and make 4DOS/NDOS file descriptions.

 4/20/94 Bug fix: When Norton Anti-Virus 3.03 is installed, the ANSIPLUS driver
         test for Windows running, which depended on the Windows Int 2Fh
         AX=1605h initialization broadcast, doesn't seem to work.  The driver
         now makes periodic Int 2Fh AX=1600h calls to test for Windows running.

 4/12/94 Bug fix: When the INSTALL/NEWAPLUS program analyzed the CONFIG.sys
         file, if an INSTALL= or INSTALLHIGH= command for loading a TSR was
         encountered which did not have any command tail parameters, all
         following lines in CONFIG.sys would be ignored.

 4/06/94 Version 3.10 released.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 3/08/94 The NEWAPLUS installation and configuration utility should now be able
         to locate CONFIG.sys and the ANSIPLUS driver file on systems using
         Stacker or similar disk compression utilities that can have their hard
         disk drive letters changed around.  NEWAPLUS will now search other
         drives for CONFIG.sys when it is not found on the original boot drive,
         and it will also search other drives when the ANSIPLUS driver is not
         found where CONFIG.sys says it will be.  A system environment variable
         (SET ANSIPLUS=d:) may also be used to identify the drive containing
         CONFIG.sys and the ANSIPLUS driver, and this will override any search.

 3/06/94 The NEWAPLUS and SETAPLUS utilities now use second-level menus to
         directly select features for explanation or revision, rather than
         forcing the user to go through all the features in a group one at a
         time.  Features now can also be enabled or disabled easily with
         special keys or the mouse directly from the menu.

 2/28/94 The ANSIPLUS scroll-back functions have been extensively rewritten.
         Major improvements include:

         (1) The driver can now use expanded memory (LIM EMS 4.0) to hold up to
             64k of scroll-back data (about 1,000 lines), roughly doubling
             scroll-back capacity.  Use of EMS for scroll-back instead of video
             RAM also eliminates compatibility problems with Windows video
             drivers caused by memory accesses to video RAM locations not
             visible on the virtual screen, or to RAM not retained by Windows.

         (2) When scrolling back, the Home/End, Page Up/Down and Tab/Shift-Tab
             keys now move instantly through the data, rather than a line at a
             time.

         (3) Under Windows, scroll-back lines now are captured as they are
             completed, rather than as they scroll off the top of the screen.
             This change was made because some Windows video drivers (eg.,
             Microsoft VGA) trap BIOS scrolling requests completely when
             running a DOS session in a window, making it impossible for
             ANSIPLUS to know when the screen has scrolled if a BIOS call was
             used to do it.  Some important DOS programs now mix DOS output
             with BIOS calls for scrolling (eg., 4DOS 5.0 (and NDOS 8.0) when
             displaying multi-colored directories).

 2/26/94 Under Windows, when running a DOS session in a window using
         Microsoft's 16-color VGA video driver, only 13 distinct colors were
         available on the ANSIPLUS 16 color palette (ie., 3 colors were
         duplicated: brown was the same as dark red, light blue was the same as
         light cyan, and pink was white.) Other video drivers do not seem to
         have this problem because they do not try to adapt to color palette
         settings made by programs running in a window.  The standard ANSIPLUS
         palette has been adjusted slightly to allow brown to show as dark
         yellow and light blue as light blue under the Microsoft VGA driver.
         Pink can be converted to light magenta by running the WINVGA16.com
         program now provided with ANSIPLUS.  See "ANSIPLUS and Windows 3" in
         the documentation for more information.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 2/12/94 Two new scroll-back control keys have been added for deleting lines
         from scroll-back storage: Control-Home will delete all scroll-back
         lines that are before the lines currently on the screen, and
         Control-End will delete all lines currently on the screen and later.

 1/31/94 The ANSIPLUS Int 2Fh installation check now returns the ANSIPLUS
         version number in CX: CH = major version, CL = minor version.

 1/05/94 After the screen saver has blanked the screen, if the screen is then
         unblanked by a keystroke, the key will now be ignored as input.

 1/04/94 The text currently available for scrollback can now be saved to a file
         or sent to the printer (ie., to file PRN).  The function is performed
         by two new SETAPLUS command options:

          SETAPLUS SAVESCROLLTEXT <file>  saves all scrollback text to a file
          SETAPLUS SAVESCROLLANSI <file>  saves the scrollback text with ANSI
                                          escape sequences for color control

 1/04/94 Bug fix: Under the 4DOS and NDOS command shells, when bright key
         echoing is enabled, ANSIPLUS will highlight the entire DOS command
         line during entry, not just keys echoed on the screen.  Unfortunately,
         the Int 2Fh calls issued before and after command entries by older
         versions of 4DOS (before 4.0) and NDOS (before 7.0) are not the same
         as those used currently, and this caused output highlighting to remain
         in effect after a command is entered.  The special command line
         highlighting feature is now disabled for the older 4DOS/NDOS command
         shells.

12/29/93 Bug fix: INSTALL/NEWAPLUS could hang while analyzing the system
         configuration if the system PATH referred to a non-existent drive.

12/17/93 Version 3.02 released.

12/17/93 Bug fix: The key input buffers are now cleared whenever the screen is
         frozen by the Scroll-Lock key, so type-ahead now will not be processed
         as Scroll-Back control.

12/04/93 Bug fix: Programs that mix DOS character output and Int 10h BIOS
         scrolling, such as 4DOS 5.0 when it is using multiple directory
         colors, would sometimes have the entire screen added to scroll-back
         storage by the BIOS scrolling call instead of just the lines scrolled
         off the top.

12/03/93 For systems with limited available XMS upper memory, ANSIPLUS can now
         load its shared code to expanded memory (EMS), leaving only about 5K
         of the driver that must be loaded into either low memory or XMS upper
         memory.  See the loading option discussion under "Changing the
         ANSIPLUS Startup Configuration" in the documentation for cautions on
         using this feature.  Configuration is handled by selecting the loading
         option in NEWAPLUS, or by the following CONFIG.sys command:

                DEVICE = ANSIPLUS.sys /E


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 9/30/93 To simplify setting up key reassignments when the system is booted,
         the new SETAPLUS SAVEKEYS <filename> command can now save all current
         key reassignments to a file which can later be loaded in AUTOEXEC.bat.
         If <filename> ends in ".com", the keys are saved as an executable
         program.  Otherwise, they are saved as an ASCII file that is loadable
         by the SETAPLUS LOADKEYS <filename> command.

 9/29/93 Bug fix: When the keyboard break interrupt was taken over by a TSR,
         ANSIPLUS would lose its ability to translate Control-Break into
         Control-C at the DOS prompt.  And when some applications bypassed DOS
         keyboard input (used Int 16h instead), but did not take over keyboard
         break, ANSIPLUS could defer action on a Control-Break entered to the
         application until after it terminated and normal DOS prompting and
         keyboard input was resumed.

 9/22/93 Version 3.01 released.

 9/11/93 Independent key reassignment has been extended to the gray keys on
         enhanced keyboards.  Gray keys that are also on the numeric keypad
         (for example, Home or PageUp) may optionally share reassignment with
         or be independent of the numeric keypad key.  Gray key reassignments
         may be defined either in SETAPLUS or by ANSI escape sequence.

 9/07/93 The screen saver blanking time can now be changed while the system is
         running, either with the new SETAPLUS BLANKTIME <minutes> command or
         from the SETAPLUS menu.

 9/06/93 The "typematic" key delay can now be controlled by ANSIPLUS.  Bootup
         configuration is set with NEWAPLUS, and runtime changes are made using
         the SETAPLUS menu or the new SETAPLUS DELAY <quartersecs> command.

 9/03/93 The SETAPLUS "Set Video Display Mode" menu now captures and displays
         VESA mode numbers instead of OEM mode numbers for VESA-defined modes.

 8/29/93 SETAPLUS INTERRUPT reports should now handle more driver and TSR
         combinations correctly.

 8/28/93 The screen saver now delays hooking Int 74h (PS/2 mouse events) or
         testing the MS-Mouse on Int 33h until after one minute of idle time
         passes (or half the screen saver blanking time, whichever is less).

 8/25/93 Key reassignment can now be applied either to keys entered through DOS
         or to all keys entered through both DOS and BIOS Interrupt 16h.  This
         new configurable feature now makes it possible to reassign keys for
         applications that bypass DOS and use Int 16h for keyboard input.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 8/21/93 Bug fix: As a "last resort" test for system activity, the screen saver
         was reading scan codes from the keyboard controller at port 60h.
         Unfortunately, on some computers, reading this port during timer ticks
         can interfere with processing of the arrow and page up/down keys on an
         enhanced keyboard and with a PS/2-type mouse.  Two changes were made
         to eliminate the problem: reading of port 60h by the screen saver is
         now a configurable feature (disabled by default); and when this
         feature is enabled, one minute of complete inactivity must elapse
         before the saver will read port 60h.

 8/03/93 Bug fix: To be consistent with the MS-DOS 4.0-6.0 ANSI.sys drivers,
         the escape sequence parser now generates a zero parameter when an
         omitted parameter is implied by the presence of a separator (so, for
         example, "Esc [;20H" is now equivalent to "Esc [0;20H").

 7/19/93 Bug fix: SETCOLOR SCHEME HELP got stuck in an error message loop.
         Now, the current color schemes in file SETCOLOR.sch are listed, or, if
         the file cannot be found, a single error message is displayed.

 7/14/93 The driver now saves and restores the VGA graphics controller index
         (port 3CEh) when analyzing video modes.

 6/22/93 Bug fixes: In CGA modes 4 or 5, the ANSIPLUS color palette was being
         loaded into the PAL/DAC registers, which changed the colors from the
         CGA 4-color scheme (black, magenta, cyan and white) to something else.
         The driver also now reduces the foreground and background colors from
         16 to 4 properly, assuring visibility of the foreground over the
         background for DOS output in the 4-color CGA modes.

 6/09/93 Bug fixes: INSTALL/NEWAPLUS refused to register drivers with serial
         numbers that start with zero.  Also, when the registered ANSIPLUS.exe
         driver was installed over the ANSIPLUS.sys Shareware driver, an
         incorrect DEVICE= line would be left in CONFIG.sys if the user had
         edited it to contain "ansiplus.sys" in lower case.

 5/29/93 Bug fix: If the "Prevent ANSI Key Reassignment Redefinition" feature
         was enabled in NEWAPLUS, subsequent executions of NEWAPLUS would
         terminate with a numeric overflow error.  This feature happens to use
         the 32nd feature bit, and operations to get/set this bit had a bug.

 5/25/93 Bug fix: SETCOLOR BORDER <colorname> was not setting the border to the
         correct named color.

 5/23/93 The INSTALL/NEWAPLUS program now will not copy ANSIPLUS files unless
         it was invoked by the INSTALL commmand.  If ANSIPLUS is already
         installed, running NEWAPLUS, even from a directory that contains
         INSTALL.inf, will only allow changes to the boot configuration for a
         currently installed driver.  In the installation copying process,
         NEWAPLUS will now check to be sure that the ANSIPLUS driver is not
         being installed in the same directory as it is being copied from.

 5/23/93 Bug fix: In ANSICOM, when a file was inserted via the Insert key, the
         screen was not updated properly after the insertion, and an execution
         error would sometimes be reported by the program.

 5/17/93 Version 3.00 released.

